/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.coregenome;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.coregenome.CoreGenomePrintDriver;
import cgdp.recog.coregenome.CoreGenomeViewModel;
import cgdp.recog.coregenome.PreviewUpdateListener;
import cgdp.recog.util.AbstractApplyDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class CoreGenomePrintOptionDialog
extends AbstractApplyDialog
implements ChangeListener {
    private static final String TITLE = "Core Genome Alignment Print Option";
    private MediatorImpl mediator;
    private CoreGenomeViewModel coreGenomeViewModel;
    private JSpinner rowCountSpinner;
    private JCheckBox onePageCheckBox;
    private JCheckBox legendCheckBox;
    private JCheckBox allRowOrganismNameCheckBox;
    private JButton pageSettingButton;
    private JCheckBox pageNumberCheckBox;
    private List previewUpdateListenerList = new ArrayList();

    CoreGenomePrintOptionDialog(Frame frame, MediatorImpl mediatorImpl, CoreGenomeViewModel coreGenomeViewModel) {
        super(frame);
        this.mediator = mediatorImpl;
        this.coreGenomeViewModel = coreGenomeViewModel;
        this.createComponents();
    }

    CoreGenomePrintOptionDialog(Dialog dialog, MediatorImpl mediatorImpl, CoreGenomeViewModel coreGenomeViewModel) {
        super(dialog);
        this.mediator = mediatorImpl;
        this.coreGenomeViewModel = coreGenomeViewModel;
        this.createComponents();
    }

    private void createComponents() {
        this.setTitle(TITLE);
        this.setModal(true);
        this.setResizable(false);
        JLabel jLabel = new JLabel("Row count par one page");
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(1, 1, 100, 1);
        this.rowCountSpinner = new JSpinner(spinnerNumberModel);
        this.rowCountSpinner.addChangeListener(this);
        this.onePageCheckBox = new JCheckBox("One page");
        this.onePageCheckBox.addActionListener(this);
        this.legendCheckBox = new JCheckBox("Show legend");
        this.legendCheckBox.addActionListener(this);
        this.allRowOrganismNameCheckBox = new JCheckBox("Show organism name every row");
        this.allRowOrganismNameCheckBox.addActionListener(this);
        this.pageNumberCheckBox = new JCheckBox("Show page number");
        this.pageNumberCheckBox.addActionListener(this);
        JLabel jLabel2 = new JLabel("Page setting");
        this.pageSettingButton = new JButton("Show");
        this.pageSettingButton.addActionListener(this);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 0, 10), 0, 0));
        this.getContentPane().add((Component)this.rowCountSpinner, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 10), 0, 0));
        this.getContentPane().add((Component)this.onePageCheckBox, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 20, 0, 10), 0, 0));
        this.getContentPane().add((Component)this.legendCheckBox, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 0, 10), 0, 0));
        this.getContentPane().add((Component)this.allRowOrganismNameCheckBox, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 0, 10), 0, 0));
        this.getContentPane().add((Component)this.pageNumberCheckBox, new GridBagConstraints(0, 4, 3, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 0, 10), 0, 0));
        this.getContentPane().add((Component)jLabel2, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 17, 0, new Insets(5, 15, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.pageSettingButton, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 10), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 6, 3, 1, 1.0, 0.0, 10, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.updateComponentStatus();
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void updateComponentStatus() {
        this.onePageCheckBox.removeActionListener(this);
        this.onePageCheckBox.setSelected(this.coreGenomeViewModel.isOnePagePrintFlag());
        this.onePageCheckBox.addActionListener(this);
        this.rowCountSpinner.removeChangeListener(this);
        this.rowCountSpinner.setValue(new Integer(this.coreGenomeViewModel.getRowCountParPage()));
        this.rowCountSpinner.addChangeListener(this);
        this.rowCountSpinner.setEnabled(!this.coreGenomeViewModel.isOnePagePrintFlag());
        this.legendCheckBox.removeActionListener(this);
        this.legendCheckBox.setSelected(this.coreGenomeViewModel.isShowLegend());
        this.legendCheckBox.addActionListener(this);
        this.allRowOrganismNameCheckBox.removeActionListener(this);
        this.allRowOrganismNameCheckBox.setSelected(this.coreGenomeViewModel.isAllRowShowOrganismName());
        this.allRowOrganismNameCheckBox.addActionListener(this);
        this.pageNumberCheckBox.removeActionListener(this);
        this.pageNumberCheckBox.setSelected(this.coreGenomeViewModel.isShowPageNumber());
        this.pageNumberCheckBox.addActionListener(this);
    }

    private int getRowCountParPage() {
        if (this.onePageCheckBox.isSelected()) {
            CoreGenomePrintDriver coreGenomePrintDriver = new CoreGenomePrintDriver(this.mediator.getPageFormat(), this.coreGenomeViewModel);
            return coreGenomePrintDriver.calcRowCountForOnePage();
        }
        return (Integer)this.rowCountSpinner.getValue();
    }

    @Override
    protected boolean apply() {
        this.coreGenomeViewModel.setShowLegend(this.legendCheckBox.isSelected());
        this.coreGenomeViewModel.setRowCountParPage(this.getRowCountParPage());
        this.coreGenomeViewModel.setOnePagePrintFlag(this.onePageCheckBox.isSelected());
        this.coreGenomeViewModel.setAllRowShowOrganismName(this.allRowOrganismNameCheckBox.isSelected());
        this.coreGenomeViewModel.setShowPageNumber(this.pageNumberCheckBox.isSelected());
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.onePageCheckBox) {
            this.rowCountSpinner.setEnabled(!this.onePageCheckBox.isSelected());
            this.updateLightPreview();
        } else if (actionEvent.getSource() == this.pageSettingButton) {
            this.mediator.pageSetup();
            this.updatePreview();
        } else if (actionEvent.getSource() == this.legendCheckBox) {
            this.updateLightPreview();
        } else if (actionEvent.getSource() == this.allRowOrganismNameCheckBox) {
            this.updateLightPreview();
        } else if (actionEvent.getSource() == this.pageNumberCheckBox) {
            this.updateLightPreview();
        }
    }

    void addPreviewUpdateListener(PreviewUpdateListener previewUpdateListener) {
        this.previewUpdateListenerList.add(previewUpdateListener);
    }

    void removeAllPreviewUpdateListener() {
        this.previewUpdateListenerList.clear();
    }

    private void updatePreview() {
        this.apply();
        for (PreviewUpdateListener previewUpdateListener : this.previewUpdateListenerList) {
            previewUpdateListener.updatePreview();
        }
    }

    private void updateLightPreview() {
        this.apply();
        for (PreviewUpdateListener previewUpdateListener : this.previewUpdateListenerList) {
            previewUpdateListener.updateLightPreview();
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.rowCountSpinner) {
            this.updateLightPreview();
        }
    }
}

