/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.data;

import cgdp.recog.bean.Const;
import cgdp.recog.funccat.FunctionCategoryExporter;
import cgdp.recog.info.cluster.ClusterInfoType;
import cgdp.recog.organism.ModifiedOrganismManager;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.server.AccessServer;
import cgdp.recog.system.property.ApplicationPropertyFacade;
import cgdp.recog.util.FileUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class DataManager {
    public static final String DATA_EXTENSION = ".dat";
    public static final String DIR_NAME_DATA = "data";
    public static final String DIR_NAME_CHROMOSOME = "chromosome";
    public static final String DIR_NAME_GENE = "genes";
    public static final String DIR_NAME_CONTIG = "contig";
    public static final String DIR_NAME_MAPPING = "mapping";

    public static Set getOrganismCodeSetNotExistGeneChromosomeFile(Collection collection) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : collection) {
            if (ApplicationPropertyFacade.isIncompleteOrganismCode(string)) {
                if (DataManager.isGlobalGeneFile(string) && DataManager.isGlobalChromosomeFile(string) && DataManager.isContigFile(string) && DataManager.isMappingFile(string)) continue;
                hashSet.add(string);
                continue;
            }
            if (DataManager.isGlobalGeneFile(string) && DataManager.isGlobalChromosomeFile(string)) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    public static String getDomClustDataDirPath(String string) {
        Project project = ProjectAccesser.getSelectedProject();
        return DataManager.getDomClustDataServerDirPath(project, string);
    }

    public static String getDomClustDataDirPath(Project project, String string) {
        return project.getDirectoryPath() + File.separator + string + File.separator + DIR_NAME_DATA + File.separator;
    }

    public static String getDomClustDataServerDirPath(Project project, String string) {
        return project.getDirectoryPath() + File.separator + string + File.separator + DIR_NAME_DATA + File.separator + AccessServer.getServerName() + File.separator;
    }

    public static void createDomClustDataDir(String string) {
        File file;
        File file2;
        File file3 = new File(DataManager.getDomClustDataDirPath(string));
        if (!file3.isDirectory()) {
            file3.mkdirs();
        }
        if (!(file2 = new File(DataManager.getDomClustChromosomeDirPath(string))).isDirectory()) {
            file2.mkdirs();
        }
        if (!(file = new File(DataManager.getDomClustGeneDirPath(string))).isDirectory()) {
            file.mkdirs();
        }
    }

    public static String getProjectDataDirPath() {
        return DataManager.getProjectDataDirpath(ProjectAccesser.getSelectedProject());
    }

    public static String getProjectDataDirpath(Project project) {
        return project.getDirectoryPath() + File.separator + DIR_NAME_DATA + File.separator + AccessServer.getServerName() + File.separator;
    }

    public static boolean isExistDataDir() {
        return new File(AccessServer.getDataDir()).isDirectory();
    }

    public static String getDataVersionFilepath() {
        return AccessServer.getDataDir() + "dataVersion";
    }

    public static boolean isDataversionFilepath() {
        String string = DataManager.getDataVersionFilepath();
        return new File(string).isFile();
    }

    private static boolean isGlobalGeneFile(String string) {
        return new File(DataManager.getGlobalGeneFilePath(string)).exists();
    }

    private static String getGlobalGeneFilePath(String string) {
        return DataManager.getGlobalGeneDatDir() + string + DATA_EXTENSION;
    }

    public static String getGeneFilePath(File file, String string) {
        return new File(DataManager.getGeneDatDir(file), string + DATA_EXTENSION).getAbsolutePath();
    }

    public static String getProjectGeneDirPath() {
        return DataManager.getProjectDataDirPath() + File.separator + DIR_NAME_GENE + File.separator;
    }

    public static String getProjectGeneFilePath(String string) {
        return DataManager.getProjectGeneDirPath() + string + DATA_EXTENSION;
    }

    public static String getDomClustGeneDirPath(String string) {
        return DataManager.getDomClustDataDirPath(string) + DIR_NAME_GENE + File.separator;
    }

    public static String getDomClustGeneFilePath(String string, String string2) {
        return DataManager.getDomClustGeneDirPath(string) + string2 + DATA_EXTENSION;
    }

    public static String getGlobalGeneDatDir() {
        return AccessServer.getDataDir() + DIR_NAME_GENE + File.separator;
    }

    private static String getGeneDatDir(File file) {
        return new File(file, DIR_NAME_GENE).getAbsolutePath();
    }

    public static String getGeneFilePath(String string) {
        String string2 = ModifiedOrganismManager.getInstance().getDomClustId();
        return DataManager.getGeneFilePath(string2, string);
    }

    public static String getGeneFilePath(String string, String string2) {
        String string3 = DataManager.getDomClustGeneFilePath(string, string2);
        if (new File(string3).isFile()) {
            return string3;
        }
        String string4 = DataManager.getProjectGeneFilePath(string2);
        if (new File(string4).isFile()) {
            return string4;
        }
        return DataManager.getGlobalGeneDatDir() + string2 + DATA_EXTENSION;
    }

    private static boolean isGlobalChromosomeFile(String string) {
        return new File(DataManager.getGlobalChromosomeFilePath(string)).exists();
    }

    private static String getGlobalChromosomeFilePath(String string) {
        return DataManager.getGlobalChromosomeDatDir() + string + DATA_EXTENSION;
    }

    public static String getChromosomeFilePath(String string) {
        String string2 = ModifiedOrganismManager.getInstance().getDomClustId();
        return DataManager.getChromosomeFilePath(string2, string);
    }

    public static String getChromosomeFilePath(String string, String string2) {
        File file = new File(DataManager.getDomClustChromosomeFilePath(string, string2));
        if (file.isFile()) {
            return file.getAbsolutePath();
        }
        File file2 = new File(DataManager.getProjectChromosomeFilePath(string2));
        if (file2.isFile()) {
            return file2.getAbsolutePath();
        }
        return DataManager.getGlobalChromosomeFilePath(string2);
    }

    public static String getChromosomeFilePath(File file, String string) {
        return new File(DataManager.getChromosomeDatDir(file), string + DATA_EXTENSION).getAbsolutePath();
    }

    public static String getProjectChromosomeDirPath() {
        return DataManager.getProjectDataDirPath() + DIR_NAME_CHROMOSOME + File.separator;
    }

    public static String getProjectChromosomeFilePath(String string) {
        return DataManager.getProjectChromosomeDirPath() + string + DATA_EXTENSION;
    }

    public static String getDomClustChromosomeDirPath(String string) {
        return DataManager.getDomClustDataDirPath(string) + DIR_NAME_CHROMOSOME + File.separator;
    }

    public static String getDomClustChromosomeFilePath(String string, String string2) {
        return DataManager.getDomClustChromosomeDirPath(string) + string2 + DATA_EXTENSION;
    }

    public static String getGlobalChromosomeDatDir() {
        return AccessServer.getDataDir() + DIR_NAME_CHROMOSOME + File.separator;
    }

    private static String getChromosomeDatDir(File file) {
        return new File(file, DIR_NAME_CHROMOSOME).getAbsolutePath();
    }

    private static boolean isContigFile(String string) {
        return new File(DataManager.getContigFilePath(string)).exists();
    }

    public static String getContigFilePath(String string) {
        return new File(DataManager.getGlobalContigDatDir(), string + DATA_EXTENSION).getAbsolutePath();
    }

    public static String getContigFilePath(File file, String string) {
        return new File(DataManager.getContigDatDir(file), string + DATA_EXTENSION).getAbsolutePath();
    }

    private static String getContigDatDir(File file) {
        return new File(file, DIR_NAME_CONTIG).getAbsolutePath();
    }

    public static String getGlobalContigDatDir() {
        return AccessServer.getDataDir() + DIR_NAME_CONTIG + File.separator;
    }

    public static String getProjectContigDirpath(Project project) {
        return DataManager.getProjectDataDirpath(project) + DIR_NAME_CONTIG + File.separator;
    }

    public static String getProjectContigFilepath(Project project, String string) {
        return DataManager.getProjectContigDirpath(project) + string + DATA_EXTENSION;
    }

    private static boolean isMappingFile(String string) {
        return new File(DataManager.getGlobalMappingFilePath(string)).exists();
    }

    public static String getGlobalMappingFilePath(String string) {
        return new File(DataManager.getGlobalMappingDirPath(), string + DATA_EXTENSION).getAbsolutePath();
    }

    private static String getGlobalMappingDirPath() {
        return AccessServer.getDataDir() + DIR_NAME_MAPPING + File.separator;
    }

    public static String getMappingFilePath(File file, String string) {
        return new File(DataManager.getMappingDatDir(file), string + DATA_EXTENSION).getAbsolutePath();
    }

    private static String getMappingDatDir(File file) {
        return new File(file, DIR_NAME_MAPPING).getAbsolutePath();
    }

    public static String getProjectMappingDatDir() {
        return DataManager.getProjectDataDirPath() + DIR_NAME_MAPPING + File.separator;
    }

    public static String getMapConfFilepath() {
        return DataManager.getProjectMappingDatDir() + "map_conf";
    }

    public static String getProjectMappingDirpath(Project project) {
        return DataManager.getProjectDataDirpath(project) + DIR_NAME_MAPPING + File.separator;
    }

    public static String getProjectMappingFilepath(Project project, String string) {
        return DataManager.getProjectMappingDirpath(project) + string + DATA_EXTENSION;
    }

    public static String getGenomeDat() {
        return AccessServer.getDataDir() + "genome.dat";
    }

    public static String getGenomeParamDat() {
        return AccessServer.getDataDir() + "genome_param.dat";
    }

    public static String getTaxonomyDat() {
        return AccessServer.getDataDir() + "taxonomy.dat";
    }

    public static boolean isExistTaxonomyDat() {
        File file = new File(DataManager.getTaxonomyDat());
        return file.isFile();
    }

    public static String getFunctionCategoryFilepath(String string) {
        return AccessServer.getDataDir() + FunctionCategoryExporter.getFilename(string);
    }

    public static String getFuncCatDatOnBase(String string) {
        return Const.BASE_DATA_DIR + FunctionCategoryExporter.getFilename(string);
    }

    public static String getProjectGeneUrlFilepath() {
        Project project = ProjectAccesser.getSelectedProject();
        return DataManager.getProjectGeneUrlFilepath(project);
    }

    public static String getProjectGeneUrlFilepath(Project project) {
        return project.getDirectoryPath() + File.separator + "gene_url";
    }

    public static String getUserDefDataGeneInfoDirpath() {
        return Const.USER_GENE_ATTR_DIR;
    }

    public static String getUserDefDataGeneInfoFilepath(String string) {
        return DataManager.getUserDefDataGeneInfoDirpath() + string + DATA_EXTENSION;
    }

    public static String getUserDefProjectGeneInfoDirpath() {
        Project project = ProjectAccesser.getSelectedProject();
        return DataManager.getUserDefProjectGeneInfoDirpath(project);
    }

    public static String getUserDefProjectGeneInfoDirpath(Project project) {
        return project.getDirectoryPath() + File.separator + "gene_attr" + File.separator;
    }

    public static String getUserDefProjectGeneInfoFilepath(String string) {
        Project project = ProjectAccesser.getSelectedProject();
        return DataManager.getUserDefProjectGeneInfoFilepath(project, string);
    }

    public static String getUserDefProjectGeneInfoFilepath(Project project, String string) {
        return DataManager.getUserDefProjectGeneInfoDirpath(project) + string + DATA_EXTENSION;
    }

    public static String getGeneSetConfFilepath() {
        return Const.USER_CONF_DIR + "gene_set";
    }

    public static String getGlobalGeneSetDirpath() {
        return Const.USER_GENE_SET_DIR;
    }

    public static String getGlobalGeneSetFilepath(String string) {
        return DataManager.getGlobalGeneSetDirpath() + string + DATA_EXTENSION;
    }

    public static String getProjectGeneSetDirpath() {
        Project project = ProjectAccesser.getSelectedProject();
        return DataManager.getProjectGeneSetDirpath(project);
    }

    public static String getProjectGeneSetDirpath(Project project) {
        return project.getDirectoryPath() + File.separator + "gene_set" + File.separator;
    }

    public static String getProjectGeneSetFilepath(String string) {
        Project project = ProjectAccesser.getSelectedProject();
        return DataManager.getProjectGeneSetFilepath(project, string);
    }

    public static String getProjectGeneSetFilepath(Project project, String string) {
        return DataManager.getProjectGeneSetDirpath(project) + string + DATA_EXTENSION;
    }

    public static String getDomClustDirpath(Project project, String string) {
        return project.getDirectoryPath() + File.separator + string + File.separator;
    }

    public static String getClusterInfoDirpath(String string) {
        Project project = ProjectAccesser.getSelectedProject();
        return DataManager.getDomClustDirpath(project, string);
    }

    public static String getClusterInfoFilepath(String string, int n) {
        return DataManager.getClusterInfoDirpath(string) + DataManager.getClusterInfoFilename(n);
    }

    public static String getClusterInfoFilepath(Project project, String string, int n) {
        return DataManager.getDomClustDirpath(project, string) + DataManager.getClusterInfoFilename(n);
    }

    private static String getClusterInfoFilename(int n) {
        String string = ClusterInfoType.isAll(n) ? "domclust_info_list" : (ClusterInfoType.isHomCluster(n) ? "homclust_info_list" : (ClusterInfoType.isCluster(n) ? "clust_info_list" : "subclust_info_list"));
        return string;
    }

    public static String getClusterSetConfFilepath() {
        return Const.USER_CONF_DIR + "cluster_set";
    }

    public static String getClusterSetDirpath(Project project, String string) {
        return DataManager.getDomClustDirpath(project, string) + "cluster_set" + File.separator;
    }

    public static String getClusterSetDirpath(String string) {
        return DataManager.getClusterInfoDirpath(string) + "cluster_set" + File.separator;
    }

    public static String getClusterSetFilepath(Project project, String string, String string2) {
        return DataManager.getClusterSetDirpath(project, string) + string2 + DATA_EXTENSION;
    }

    public static String getPatternFilepath(Project project, String string) {
        return project.getDirectoryPath() + File.separator + string + File.separator + "pattern";
    }

    public static String getOrganismSetFilepath(Project project, String string) {
        return project.getDirectoryPath() + File.separator + string + File.separator + "organism_set";
    }

    public static String getMergeClusterFilepath(Project project, String string) {
        return project.getDirectoryPath() + File.separator + string + File.separator + "merge_cluster";
    }

    public static String getSplitClusterFilepath(Project project, String string) {
        return project.getDirectoryPath() + File.separator + string + File.separator + "split_cluster";
    }

    public static String getTaxMapDirpath(Project project, String string) {
        return project.getDirectoryPath() + File.separator + string + File.separator + "taxmap" + File.separator;
    }

    public static String getTaxMapConfFilepath(Project project, String string) {
        return DataManager.getTaxMapDirpath(project, string) + "taxmap";
    }

    public static String getTaxMapFilepath(Project project, String string, String string2) {
        return DataManager.getTaxMapDirpath(project, string) + string2 + DATA_EXTENSION;
    }

    public static String getCoreGenomeConfFilepath(Project project) {
        return project.getDirectoryPath() + File.separator + "core_genome_conf";
    }

    public static String getCoreGenomeFilepath(Project project, String string) {
        String string2 = string;
        if (!string.endsWith(".coaln")) {
            string2 = string2 + ".coaln";
        }
        return project.getDirectoryPath() + File.separator + string2;
    }

    public static Set getDataExistOrganismCodeSet() {
        HashSet hashSet = new HashSet();
        String string = DataManager.getGlobalGeneDatDir();
        hashSet.addAll(DataManager.getDataExistOrganismCodeSet(string));
        String string2 = DataManager.getGlobalChromosomeDatDir();
        hashSet.addAll(DataManager.getDataExistOrganismCodeSet(string2));
        return hashSet;
    }

    private static Set getDataExistOrganismCodeSet(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        File file = new File(string);
        File[] fileArray = file.listFiles(new DataFilenameFilter());
        if (fileArray == null || fileArray.length == 0) {
            return hashSet;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            String string2 = file2.getName().substring(0, file2.getName().length() - DATA_EXTENSION.length());
            hashSet.add(string2);
        }
        return hashSet;
    }

    public static boolean createDataDirectory() {
        boolean bl = false;
        bl |= FileUtil.createDirectory(AccessServer.getDataDir());
        bl |= FileUtil.createDirectory(DataManager.getGlobalChromosomeDatDir());
        bl |= FileUtil.createDirectory(DataManager.getGlobalGeneDatDir());
        bl |= FileUtil.createDirectory(DataManager.getGlobalContigDatDir());
        return bl |= FileUtil.createDirectory(DataManager.getProjectMappingDatDir());
    }

    private static class DataFilenameFilter
    implements FilenameFilter {
        private DataFilenameFilter() {
        }

        @Override
        public boolean accept(File file, String string) {
            return string.endsWith(DataManager.DATA_EXTENSION);
        }
    }
}

