/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.data;

import cgdp.recog.util.GeneUtil;
import cgdp.recog.util.Range;
import cgdp.recog.util.StringTool;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class Gene {
    private static final String LOCATION_KEYWORD_JOIN = "join";
    private static final String CDS = "cds";
    private static final String RNA = "rna";
    private static final int NO_VALUE = -1;
    private int id;
    private String udate;
    private String spid;
    private String organism;
    private String locusTag;
    private int domainNo;
    private String geneName;
    private int chromId = -1;
    private int contigId = -1;
    private int start;
    private int end;
    private int direction;
    private String featureKey;
    private String accession;
    private String gi;
    private String geneId;
    private String description;
    private String location;
    private String translTable;
    private int codonStart;
    private int ntseq;
    private int aaseq;
    private int funccat;
    private int aalen;
    private double position;
    private int order;

    public Gene() {
        this.clear();
    }

    private void clear() {
        this.organism = "";
        this.locusTag = "";
        this.geneName = "";
        this.chromId = 0;
        this.start = 0;
        this.end = 0;
        this.direction = 0;
        this.featureKey = "";
        this.accession = "";
        this.gi = "";
        this.geneId = "";
        this.description = "";
    }

    public String getSpid() {
        return this.spid;
    }

    public void setSpid(String string) {
        this.spid = string;
    }

    public void setOrganism(String string) {
        this.organism = string;
    }

    public void setLocusTag(String string) {
        this.locusTag = string;
    }

    public void setDomainNo(int n) {
        this.domainNo = n;
    }

    public void setGeneName(String string) {
        this.geneName = string;
    }

    public void setChromId(int n) {
        this.chromId = n;
    }

    public int getContigId() {
        return this.contigId;
    }

    public void setContigId(int n) {
        this.contigId = n;
    }

    public void setStart(int n) {
        this.start = n;
    }

    public void setEnd(int n) {
        this.end = n;
    }

    public void setDirection(int n) {
        this.direction = n;
    }

    public void setFeatureKey(String string) {
        this.featureKey = string;
    }

    public void setAccession(String string) {
        this.accession = string;
    }

    public void setGi(String string) {
        this.gi = string;
    }

    public void setGeneId(String string) {
        this.geneId = string;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getOrganism() {
        return this.organism;
    }

    public String getLocusTag() {
        return this.locusTag;
    }

    public int getDomainNo() {
        return this.domainNo;
    }

    public String getLocusTagWithDomainNo() {
        String string = this.locusTag;
        if (this.isExistDomainNo()) {
            string = string + "(" + this.getDomainNo() + ")";
        }
        return string;
    }

    private boolean isExistDomainNo() {
        return this.getDomainNo() != 0;
    }

    public String getGeneName() {
        return this.geneName;
    }

    public int getChromId() {
        return this.chromId;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getLength() {
        return GeneUtil.getDNALength(this.getStart(), this.getEnd());
    }

    public int getDirection() {
        return this.direction;
    }

    public String getDisplayDirection() {
        return this.getDirection() == 1 ? "+" : "-";
    }

    public boolean isPositive() {
        return Gene.isPositive(this.getDirection());
    }

    public boolean isNegative() {
        return Gene.isNegative(this.getDirection());
    }

    public static boolean isPositive(int n) {
        return n == 1;
    }

    public static boolean isNegative(int n) {
        return n == -1;
    }

    public String getFeatureKey() {
        return this.featureKey;
    }

    public boolean isCDS() {
        return this.getFeatureKey().toLowerCase().equals(CDS);
    }

    public boolean isRNA() {
        return this.getFeatureKey().toLowerCase().indexOf(RNA) != -1;
    }

    public String getAccession() {
        return this.accession;
    }

    public String getGi() {
        return this.gi;
    }

    public String getGeneId() {
        return this.geneId;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String string) {
        this.location = string;
    }

    public int getAalen() {
        return this.aalen;
    }

    public void setAalen(int n) {
        this.aalen = n;
    }

    public void setPosition(double d) {
        this.position = d;
    }

    public double getPosition() {
        return this.position;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int n) {
        this.order = n;
    }

    public int getRange() {
        return this.end - this.start + 1;
    }

    public List getExonRegionList() {
        return Gene.getExonRegionList(this.getLocation());
    }

    public static List getExonRegionList(String string) {
        int n = string.lastIndexOf("(");
        n = n == -1 ? 0 : ++n;
        int n2 = string.indexOf(")");
        if (n2 == -1) {
            n2 = string.length();
        }
        String string2 = string.substring(n, n2);
        string2 = string2.replaceAll("<", "");
        string2 = string2.replaceAll(">", "");
        Vector vector = StringTool.splitString(string2, ",");
        ArrayList<Range> arrayList = new ArrayList<Range>();
        for (String string3 : vector) {
            Vector vector2 = StringTool.splitString(string3, "..");
            int n3 = Integer.parseInt((String)vector2.get(0));
            int n4 = vector2.size() == 2 ? Integer.parseInt((String)vector2.get(1)) : n3;
            Range range = new Range(n3, n4);
            arrayList.add(range);
        }
        return arrayList;
    }

    public boolean isJoin() {
        return this.getLocation().indexOf(LOCATION_KEYWORD_JOIN) != -1;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }

    public String getUdate() {
        return this.udate;
    }

    public void setUdate(String string) {
        this.udate = string;
    }

    public String getTranslTable() {
        return this.translTable;
    }

    public void setTranslTable(String string) {
        this.translTable = string;
    }

    public int getCodonStart() {
        return this.codonStart;
    }

    public void setCodonStart(int n) {
        this.codonStart = n;
    }

    public int getNtseq() {
        return this.ntseq;
    }

    public void setNtseq(int n) {
        this.ntseq = n;
    }

    public int getAaseq() {
        return this.aaseq;
    }

    public void setAaseq(int n) {
        this.aaseq = n;
    }

    public int getFunccat() {
        return this.funccat;
    }

    public void setFunccat(int n) {
        this.funccat = n;
    }
}

