/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.data;

import cgdp.recog.bean.Const;
import cgdp.recog.data.PatternColor;
import cgdp.recog.util.ColorUtil;
import cgdp.recog.util.StringTool;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JOptionPane;

public class PatternTbl
extends ArrayList {
    private static PatternTbl m_patternTbl = new PatternTbl();

    private PatternTbl() {
        try {
            this.readPattern();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, iOException.getMessage(), "Error", 0);
            System.exit(0);
        }
    }

    private void readPattern() throws IOException {
        String string;
        FileInputStream fileInputStream = new FileInputStream(Const.USER_PATTERN_DAT_PATH);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        while ((string = bufferedReader.readLine()) != null) {
            if (StringTool.isNull(string)) continue;
            Vector vector = StringTool.splitString(string, ",");
            if (vector.size() != 2) {
                vector.clear();
                vector = null;
                continue;
            }
            PatternColor patternColor = new PatternColor();
            patternColor.setForeground(ColorUtil.str2Color((String)vector.get(0)));
            patternColor.setBackground(ColorUtil.str2Color((String)vector.get(1)));
            this.add(patternColor);
            vector.clear();
            vector = null;
        }
        fileInputStream.close();
    }

    public void writePattern() throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(Const.USER_PATTERN_DAT_PATH);
        PrintWriter printWriter = new PrintWriter(fileOutputStream);
        for (PatternColor patternColor : this) {
            printWriter.print(ColorUtil.color2Str(patternColor.getForeground()));
            printWriter.print(",");
            printWriter.println(ColorUtil.color2Str(patternColor.getBackground()));
        }
        printWriter.flush();
        fileOutputStream.close();
    }

    public static PatternTbl getInstance() {
        return m_patternTbl;
    }
}

