/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.domclust;

import cgdp.recog.data.Cluster;
import cgdp.recog.data.Gene;
import cgdp.recog.data.GeneInformation;
import cgdp.recog.data.GeneTbl;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.GeneUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CluserInfoAdjuster {
    private static final ApplicationLogger logger = new ApplicationLogger(CluserInfoAdjuster.class);

    public static void registerGeneName(List list, List list2, String string) throws IOException {
        Object object;
        Object object2;
        Object object3;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        for (Object object4 : list) {
            object3 = ((Cluster)object4).getSpSet();
            Iterator<Object> iterator = object3.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                object2 = ((Cluster)object4).getLocusTagList(string2);
                object = object2.iterator();
                while (object.hasNext()) {
                    String string3 = GeneUtil.removeDomainNo((String)object.next());
                    hashMap.put(CluserInfoAdjuster.createKey(string2, string3), null);
                }
            }
        }
        for (Object object4 : list2) {
            try {
                object3 = new GeneTbl((String)object4);
                ((GeneTbl)object3).read();
                for (String string2 : ((HashMap)object3).keySet()) {
                    object2 = CluserInfoAdjuster.createKey((String)object4, string2);
                    if (!hashMap.containsKey(object2) || (object = (Gene)((HashMap)object3).get(string2)) == null) continue;
                    hashMap.put(object2, object);
                }
            }
            catch (Exception exception) {
                logger.warn("Failed to read gene file. " + (String)object4, exception);
            }
        }
        CluserInfoAdjuster.setGeneInfo(list, hashMap);
    }

    private static void setGeneInfo(List list, Map map) {
        for (Cluster cluster : list) {
            for (String string : cluster.getSpSet()) {
                List list2 = cluster.getGeneInformationList(string);
                if (list2 == null) continue;
                for (GeneInformation geneInformation : list2) {
                    String string2 = CluserInfoAdjuster.createKey(string, geneInformation.getLocusTagWithoutDomain());
                    Gene gene = (Gene)map.get(string2);
                    if (gene == null) continue;
                    geneInformation.setGeneName(gene.getGeneName());
                    if (!geneInformation.isMaxDomain()) continue;
                    geneInformation.setTo(gene.getLength());
                }
            }
        }
    }

    private static String createKey(String string, String string2) {
        return string + string2;
    }

    public static void addDomainInfo(List list) {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        for (Object object : list) {
            for (Object object2 : ((Cluster)object).getSpSet()) {
                Object object3 = (HashMap)hashMap.get(object2);
                if (object3 == null) {
                    object3 = new HashMap();
                    hashMap.put(object2, object3);
                }
                for (GeneInformation geneInformation : ((Cluster)object).getGeneInformationList((String)object2)) {
                    ArrayList<GeneInformation> arrayList = (ArrayList<GeneInformation>)object3.get(geneInformation.getLocusTag());
                    if (arrayList == null) {
                        arrayList = new ArrayList<GeneInformation>();
                        object3.put(geneInformation.getLocusTag(), arrayList);
                    }
                    arrayList.add(geneInformation);
                }
            }
        }
        for (Object object : hashMap.keySet()) {
            Map map = (Map)hashMap.get(object);
            for (Object object3 : map.keySet()) {
                List list2 = (List)map.get(object3);
                if (list2.size() == 1) continue;
                CluserInfoAdjuster.addDomainToLocusTag(list2);
                CluserInfoAdjuster.markMaxDomain(list2);
            }
        }
    }

    private static void addDomainToLocusTag(List list) {
        for (GeneInformation geneInformation : list) {
            if (!geneInformation.isDomain()) continue;
            geneInformation.setLocusTag(GeneUtil.combineLocusTagDomainNo(geneInformation.getLocusTag(), geneInformation.getDomainNo()));
        }
    }

    private static void markMaxDomain(List list) {
        GeneInformation geneInformation = null;
        for (GeneInformation geneInformation2 : list) {
            if (geneInformation == null) {
                geneInformation = geneInformation2;
                continue;
            }
            if (geneInformation.getDomainNo() >= geneInformation2.getDomainNo()) continue;
            geneInformation = geneInformation2;
        }
        geneInformation.setMaxDomain(true);
    }
}

