/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.filefilter;

import cgdp.recog.util.StringTool;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class FileExtension {
    public static final String DOMCLUST = ".dclst";
    public static final String OLD_DOMCLUST = ".cluster";
    public static final String DOMCLUST_TAB = ".clusttab";
    public static final String COREGENOME = ".coaln";
    public static final String OLD_COREGENOME = ".coregenome";
    public static final String PHYLOPAT = ".phpat";
    public static final String OLD_PHYLOPAT = ".phylopat";
    public static final String PPM_PDF = ".pdf";
    public static final String TAB = ".txt";
    public static final String GENE_ATTR = ".txt";
    public static final String FASTA = ".fa";
    public static final String DAT = ".dat";

    private FileExtension() {
    }

    public static List getDomClustFileExtensionList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(DOMCLUST);
        arrayList.add(OLD_DOMCLUST);
        return arrayList;
    }

    public static String getDomClustFileExtensionString() {
        return StringTool.conbineStrList(FileExtension.getDomClustFileExtensionList(), ",");
    }

    public static List getDomClustTabFileExtensionList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(DOMCLUST_TAB);
        return arrayList;
    }

    public static List getCoreGenomeFileExtensionList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(COREGENOME);
        arrayList.add(OLD_COREGENOME);
        return arrayList;
    }

    public static String getCoreGenomeFileExtensionString() {
        return StringTool.conbineStrList(FileExtension.getCoreGenomeFileExtensionList(), ",");
    }

    public static List getPhylopatFileExtensionList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(PHYLOPAT);
        arrayList.add(OLD_PHYLOPAT);
        return arrayList;
    }

    public static String getPhylopatFileExtensionString() {
        return StringTool.conbineStrList(FileExtension.getPhylopatFileExtensionList(), ",");
    }

    public static boolean isDomClustFile(File file) {
        if (file == null) {
            return false;
        }
        return FileExtension.isDomClustFile(file.getName());
    }

    public static boolean isDomClustFile(String string) {
        if (string == null) {
            return false;
        }
        return FileExtension.isMatchExtension(FileExtension.getDomClustFileExtensionList(), string);
    }

    public static boolean isDomClustTab(File file) {
        if (file == null) {
            return false;
        }
        return FileExtension.isMatchExtension(DOMCLUST_TAB, file.getName());
    }

    public static boolean isDomClustTab(String string) {
        if (string == null) {
            return false;
        }
        return FileExtension.isMatchExtension(DOMCLUST_TAB, string);
    }

    public static boolean isCoreGenomeFile(File file) {
        if (file == null) {
            return false;
        }
        return FileExtension.isCoreGenomeFile(file.getName());
    }

    public static boolean isCoreGenomeFile(String string) {
        if (string == null) {
            return false;
        }
        return FileExtension.isMatchExtension(FileExtension.getCoreGenomeFileExtensionList(), string);
    }

    public static boolean isPhylopat(File file) {
        if (file == null) {
            return false;
        }
        return FileExtension.isPhylopat(file.getName());
    }

    public static boolean isPhylopat(String string) {
        if (string == null) {
            return false;
        }
        return FileExtension.isMatchExtension(FileExtension.getPhylopatFileExtensionList(), string);
    }

    public static boolean isPPMPdf(File file) {
        if (file == null) {
            return false;
        }
        return FileExtension.isMatchExtension(PPM_PDF, file.getName());
    }

    public static boolean isPPMPdf(String string) {
        if (string == null) {
            return false;
        }
        return FileExtension.isMatchExtension(PPM_PDF, string);
    }

    public static boolean isMatchExtension(List list, String string) {
        if (list == null || list.isEmpty()) {
            return false;
        }
        for (String string2 : list) {
            if (!FileExtension.isMatchExtension(string2, string)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMatchExtension(String string, String string2) {
        return string2.endsWith(string);
    }

    public static boolean isAnyExtension(String string) {
        return FileExtension.isDomClustFile(string) || FileExtension.isCoreGenomeFile(string);
    }

    public static boolean isAnyExtension(File file) {
        return FileExtension.isDomClustFile(file) || FileExtension.isCoreGenomeFile(file);
    }

    public static boolean isDatExtention(String string) {
        return string.endsWith(DAT);
    }

    public static boolean isDatExtention(File file) {
        if (file == null) {
            return false;
        }
        return FileExtension.isDatExtention(file.getName());
    }
}

