/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.histogram;

import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.data.MultiCluster;
import cgdp.recog.histogram.HistogramCondition;
import cgdp.recog.util.CollectionUtil;
import java.awt.Font;
import java.util.List;
import java.util.Map;

public class HistogramContext {
    private static final Font IMAGE_FONT = new Font("Monospaced", 0, 12);
    private ClusterTbl clusterTbl;
    private int width;
    private int height;
    private int startRow;
    private int rowCount;
    private int offsetX;
    private int offsetTop;

    public ClusterTbl getClusterTbl() {
        return this.clusterTbl;
    }

    public void setClusterTbl(ClusterTbl clusterTbl) {
        this.clusterTbl = clusterTbl;
    }

    public HistogramCondition getHistogramCondition() {
        if (this.clusterTbl == null) {
            return new HistogramCondition();
        }
        HistogramCondition histogramCondition = this.clusterTbl.getHistogramCondition();
        if (histogramCondition == null) {
            histogramCondition = new HistogramCondition();
        }
        return histogramCondition;
    }

    public boolean isExistClusterTbl() {
        return this.clusterTbl != null;
    }

    public List getViewOrderList() {
        return this.clusterTbl.getViewOrderList();
    }

    public int getViewOrderListSize() {
        return this.getViewOrderList().size();
    }

    public List getViewOrganismCodeList() {
        return this.clusterTbl.getViewOrganismCodeList();
    }

    public List getViewClusterList() {
        return this.clusterTbl.getViewClusterList();
    }

    public int getViewClusterListSize() {
        return this.getViewClusterList().size();
    }

    public Cluster getViewCluster(int n) {
        return this.clusterTbl.getViewCluster(n);
    }

    public List getViewClusterListInPattern(int n) {
        return this.clusterTbl.getViewClusterListInPattern(n);
    }

    public Map getViewOrder(int n) {
        return this.clusterTbl.getViewOrder(n);
    }

    public boolean isExistViewOrderList() {
        return !CollectionUtil.isNull(this.getViewOrderList());
    }

    public boolean isDescriptionFunc() {
        return this.getHistogramCondition().isDescriptionFunc();
    }

    public boolean isFuncName() {
        return this.getHistogramCondition().isFuncName();
    }

    public boolean isValue() {
        return this.getHistogramCondition().isValue();
    }

    public boolean isDiff() {
        return this.getHistogramCondition().isDiff();
    }

    public boolean isLine() {
        return this.getHistogramCondition().isLine();
    }

    public boolean isMultiOrganism() {
        return this.getHistogramCondition().isMultiOrganism();
    }

    public String getRepresentativeOrganismCode() {
        return this.getHistogramCondition().getRepresentativeOrganismCode();
    }

    public List getClusterList(Map map) {
        return this.clusterTbl.getViewClusterList(map);
    }

    public int getClusterSize(Map map) {
        List list = this.getClusterList(map);
        if (CollectionUtil.isNull(list)) {
            return 0;
        }
        return list.size();
    }

    public boolean isOutgroup() {
        return this.clusterTbl.isOutgroup();
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public int getStartRow() {
        return this.startRow;
    }

    public void setStartRow(int n) {
        this.startRow = n;
    }

    public int getEndRow() {
        return this.getStartRow() + this.getRowCount();
    }

    public boolean isSelectedRow(int n) {
        return this.clusterTbl.containsSelectedIndex(n);
    }

    public boolean isExistSelected() {
        return this.clusterTbl.isExistSelectedCluster();
    }

    public int getSelectedBaseRowIndex() {
        return this.clusterTbl.getSelectedBaseRowIndex();
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(int n) {
        this.rowCount = n;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetX(int n) {
        this.offsetX = n;
    }

    public int getOffsetTop() {
        return this.offsetTop;
    }

    public void setOffsetTop(int n) {
        this.offsetTop = n;
    }

    public Font getFont() {
        return IMAGE_FONT;
    }

    public double calcIntervalY(int n) {
        double d = this.getHeight() - this.getOffsetTop();
        double d2 = !this.isExistViewOrderList() ? d : (n < this.getRowCount() ? d / (double)n : d / (double)this.getRowCount());
        return d2;
    }

    public double calcCellHeight() {
        List list = this.getViewOrderList();
        double d = this.calcIntervalY(list.size());
        double d2 = d < 1.0 ? 1.0 : d;
        return d2;
    }

    public double calcScaleX() {
        double d = 1.0;
        d = this.isExistHClustMergedResult() ? (double)this.getMaxSubClusterCount() : (double)this.getMaxClusterCount();
        double d2 = (double)(this.getWidth() - this.getOffsetX() - 5) / d;
        return d2;
    }

    private int getMaxClusterCount() {
        int n = -1;
        List list = this.getViewOrderList();
        for (Map map : list) {
            int n2 = this.getClusterSize(map);
            n = Math.max(n, n2);
        }
        return n;
    }

    public int calcRowIndex(int n, int n2) {
        return (int)Math.floor((double)(n2 - this.getOffsetTop()) / this.calcIntervalY(n)) + this.getStartRow();
    }

    public void copyHistogramContext(HistogramContext histogramContext) {
        this.setClusterTbl(histogramContext.clusterTbl);
        this.setWidth(histogramContext.getWidth());
        this.setHeight(histogramContext.getHeight());
        this.setOffsetTop(histogramContext.getOffsetTop());
        this.setOffsetX(histogramContext.getOffsetX());
        this.setRowCount(histogramContext.getRowCount());
        this.setStartRow(histogramContext.getStartRow());
    }

    public boolean isExistHClustMergedResult() {
        return this.clusterTbl.isExistHClustMergedResult();
    }

    int getMaxSubClusterCount() {
        int n = -1;
        List list = this.clusterTbl.getViewClusterList();
        for (Cluster cluster : list) {
            int n2 = 1;
            if (cluster.isTypeMergeCluster()) {
                n2 = ((MultiCluster)cluster).getSubClusterList().size();
            }
            n = Math.max(n, n2);
        }
        return n;
    }
}

