/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.util.AbstractApplyDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public abstract class AbstractServerInfoListDialog
extends AbstractApplyDialog {
    protected MediatorImpl mediator;
    private JTable infoTitleTable;
    private JButton deleteButton;

    protected AbstractServerInfoListDialog(Dialog dialog, MediatorImpl mediatorImpl) {
        super(dialog);
        this.mediator = mediatorImpl;
        this.createComponents();
    }

    protected AbstractServerInfoListDialog(Frame frame, MediatorImpl mediatorImpl) {
        super(frame);
        this.mediator = mediatorImpl;
        this.createComponents();
    }

    private void createComponents() {
        this.setTitle(this.getFrameTitle());
        this.setModal(true);
        this.infoTitleTable = new JTable(new InfoTitleListTableModel());
        TableColumnModel tableColumnModel = this.infoTitleTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(2);
        tableColumn.setMaxWidth(50);
        tableColumn.setMinWidth(50);
        this.infoTitleTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                AbstractServerInfoListDialog.this.setEnabledButton();
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.infoTitleTable, 20, 30);
        this.deleteButton = new JButton("Delete");
        this.deleteButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.deleteButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.getButtonPanel(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.setApplyButtonName("Download");
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 15, 10, 15), 0, 0));
        this.getContentPane().add((Component)jPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 15, 15, 15), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setEnabledButton();
    }

    protected abstract String getFrameTitle();

    private void setEnabledButton() {
        boolean bl = this.infoTitleTable.getSelectedRowCount() != 0;
        this.deleteButton.setEnabled(bl);
        this.applyButton.setEnabled(bl);
    }

    public void updateValue(List list) {
        this.getInfoTitleListTableModel().setInfoTitleList(list);
    }

    protected InfoTitleListTableModel getInfoTitleListTableModel() {
        return (InfoTitleListTableModel)this.infoTitleTable.getModel();
    }

    public List getSelectedInfoTitleList() {
        List list = this.getInfoTitleListTableModel().getInfoTitleList();
        int[] nArray = this.infoTitleTable.getSelectedRows();
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(list.get(nArray[i]));
        }
        return arrayList;
    }

    protected abstract void delete();

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.deleteButton) {
            this.delete();
        }
    }

    protected class InfoTitleListTableModel
    extends AbstractTableModel {
        private final String[] COLUMN_NAMES = new String[]{"Name", "Type", "Multi"};
        private List infoTitleList = new ArrayList();

        protected InfoTitleListTableModel() {
        }

        public void setInfoTitleList(List list) {
            this.infoTitleList = list;
            this.fireTableDataChanged();
        }

        public List getInfoTitleList() {
            return this.infoTitleList;
        }

        @Override
        public int getColumnCount() {
            return this.COLUMN_NAMES.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.COLUMN_NAMES[n];
        }

        public Class getColumnClass(int n) {
            if (n == 2) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public int getRowCount() {
            return this.infoTitleList.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            AbstractInfoTitle abstractInfoTitle = (AbstractInfoTitle)this.infoTitleList.get(n);
            if (n2 == 0) {
                return abstractInfoTitle.getName();
            }
            if (n2 == 1) {
                return abstractInfoTitle.getDisplayTypeName();
            }
            if (n2 == 2) {
                return new Boolean(abstractInfoTitle.isMulti());
            }
            return null;
        }

        public void removeAll(Collection collection) {
            this.infoTitleList.removeAll(collection);
            this.fireTableDataChanged();
        }
    }
}

