/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info.cluster;

import cgdp.recog.data.Cluster;
import cgdp.recog.info.AbstractInfo;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.cluster.ClusterInfo;
import cgdp.recog.info.cluster.ClusterInfoFacade;
import cgdp.recog.info.cluster.ClusterInfoKeyComparator;
import cgdp.recog.info.cluster.ClusterInfoTitle;
import cgdp.recog.info.cluster.ClusterInfoType;
import cgdp.recog.option.ClusterMode;
import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClusterInfoUtil {
    private ClusterInfoUtil() {
    }

    public static Map convertClusterInfoKeyMap(Map map, int n) {
        HashMap<String, ClusterInfo> hashMap = new HashMap<String, ClusterInfo>();
        for (Cluster cluster : map.keySet()) {
            ClusterInfo clusterInfo = (ClusterInfo)map.get(cluster);
            String string = ClusterInfoUtil.getClusterInfoKey(cluster, n);
            hashMap.put(string, clusterInfo);
        }
        return hashMap;
    }

    public static String getClusterInfoKey(Cluster cluster, int n) {
        String string = null;
        if (!ClusterInfoType.isAll(n)) {
            string = ClusterInfoType.isHomCluster(n) ? String.valueOf(cluster.getHomClusterId()) : (ClusterInfoType.isCluster(n) ? String.valueOf(cluster.getClusterId()) : Cluster.conbineClusterId(cluster.getClusterId(), cluster.getSubClusterId()));
        }
        return string;
    }

    static String getClusterInfoKey(AbstractInfo abstractInfo, int n) {
        String string;
        if (ClusterInfoType.isAll(n)) {
            string = (String)abstractInfo.getInfo(ClusterInfoFacade.getInfoTitle("domclust_id"));
        } else if (ClusterInfoType.isHomCluster(n)) {
            string = String.valueOf(((Float)abstractInfo.getInfo(ClusterInfoFacade.getInfoTitle("homclusterid"))).intValue());
        } else if (ClusterInfoType.isCluster(n)) {
            string = String.valueOf(((Float)abstractInfo.getInfo(ClusterInfoFacade.getInfoTitle("clusterid"))).intValue());
        } else {
            int n2 = ((Float)abstractInfo.getInfo(ClusterInfoFacade.getInfoTitle("clusterid"))).intValue();
            int n3 = ((Float)abstractInfo.getInfo(ClusterInfoFacade.getInfoTitle("subclusterid"))).intValue();
            string = Cluster.conbineClusterId(n2, n3);
        }
        return string;
    }

    static List getClusterInfoList(Map map, int n) {
        ArrayList arrayList = new ArrayList(map.keySet());
        Collections.sort(arrayList, new ClusterInfoKeyComparator(n));
        ArrayList<ClusterInfo> arrayList2 = new ArrayList<ClusterInfo>();
        for (String string : arrayList) {
            ClusterInfo clusterInfo = (ClusterInfo)map.get(string);
            clusterInfo.putInfo(ClusterInfoTitle.TITLE_ID, string);
            arrayList2.add(clusterInfo);
        }
        return arrayList2;
    }

    public static AbstractInfoTitle getPatternCoefTitle(int n) {
        ClusterInfoTitle clusterInfoTitle = ClusterMode.isBaseCluster(n) ? ClusterInfoFacade.getInfoTitle("CPatternCoef") : ClusterInfoFacade.getInfoTitle("SCPatternCoef");
        return clusterInfoTitle;
    }

    public static Map createInfoTypeCluterInfoTitleMap(Collection collection) {
        HashMap<Integer, HashSet<ClusterInfoTitle>> hashMap = new HashMap<Integer, HashSet<ClusterInfoTitle>>();
        for (ClusterInfoTitle clusterInfoTitle : collection) {
            int n = clusterInfoTitle.getInfoType();
            HashSet<ClusterInfoTitle> hashSet = (HashSet<ClusterInfoTitle>)hashMap.get(new Integer(n));
            if (hashSet == null) {
                hashSet = new HashSet<ClusterInfoTitle>();
                hashMap.put(new Integer(n), hashSet);
            }
            hashSet.add(clusterInfoTitle);
        }
        return hashMap;
    }

    public static List filterClusterInfoListByInfoType(List list, Set set) {
        ArrayList<ClusterInfoTitle> arrayList = new ArrayList<ClusterInfoTitle>();
        for (ClusterInfoTitle clusterInfoTitle : list) {
            if (!set.contains(new Integer(clusterInfoTitle.getInfoType()))) continue;
            arrayList.add(clusterInfoTitle);
        }
        return arrayList;
    }
}

