/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info.gene;

import cgdp.recog.info.InfoUtil;
import cgdp.recog.info.gene.GeneInfo;
import cgdp.recog.info.gene.GeneInfoDownloader;
import cgdp.recog.info.gene.GeneInfoFacade;
import cgdp.recog.info.gene.GeneInfoRegister;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.info.gene.GeneInfoUtil;
import cgdp.recog.process.AbstractThreadProcess;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.project.Project;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.GeneUtil;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GeneInfoDownloadExecuter
extends AbstractThreadProcess {
    private static final ApplicationLogger logger = new ApplicationLogger(GeneInfoDownloadExecuter.class);
    private Component parent;
    private Project project;
    private Collection organismCodeC;
    private Collection geneInfoTitleC;
    private String location = "Global";
    private Map organismCodeInfoListMap = new HashMap();
    private Set unableDownloadInfoTitleSet = new HashSet();
    private boolean errorHandling = true;
    private boolean overwriteCheck = false;

    public GeneInfoDownloadExecuter(Component component, Collection collection, Collection collection2, Project project) {
        this.parent = component;
        this.project = project;
        this.geneInfoTitleC = collection;
        this.organismCodeC = collection2;
    }

    public void setLocation(String string) {
        this.location = string;
    }

    public void setErrorHandling(boolean bl) {
        this.errorHandling = bl;
    }

    public void setOverwriteCheck(boolean bl) {
        this.overwriteCheck = bl;
    }

    @Override
    public void execute(ProgressImpl progressImpl) {
        progressImpl.setTotal(this.geneInfoTitleC.size());
        try {
            HashMap hashMap = new HashMap();
            Iterator iterator = this.geneInfoTitleC.iterator();
            while (iterator.hasNext()) {
                Object object;
                if (progressImpl.isCanceled()) {
                    this.setCancel(true);
                    return;
                }
                progressImpl.increment();
                GeneInfoTitle geneInfoTitle = (GeneInfoTitle)iterator.next();
                try {
                    GeneInfoDownloader geneInfoDownloader = new GeneInfoDownloader(geneInfoTitle, geneInfoTitle.getOrganismCodeSet(), this.project);
                    geneInfoDownloader.execute();
                    object = geneInfoDownloader.getGeneInfoList();
                    this.updateKeyInfoListMap((List)object, hashMap);
                }
                catch (Exception exception) {
                    object = "Fail to load gene property. " + geneInfoTitle.getName();
                    logger.warn((String)object, exception);
                    this.unableDownloadInfoTitleSet.add(geneInfoTitle);
                }
            }
            this.organismCodeInfoListMap = GeneInfoUtil.createOrganismCodeGeneInfoListMap(hashMap.values());
        }
        catch (Exception exception) {
            String string = "Fail to save gene properies.";
            logger.warn(string, exception);
            this.setError(true);
            this.setErrorMessage(string);
        }
    }

    private void updateKeyInfoListMap(List list, Map map) {
        for (GeneInfo geneInfo : list) {
            String string = GeneUtil.createOrganismLocusTagKey(geneInfo);
            GeneInfo geneInfo2 = (GeneInfo)map.get(string);
            if (geneInfo2 == null) {
                map.put(string, geneInfo);
                continue;
            }
            geneInfo2.putAllInfo(geneInfo);
        }
    }

    public Set getUnableDownloadInfoTitleSet() {
        return this.unableDownloadInfoTitleSet;
    }

    @Override
    public void done() {
        String[] stringArray;
        if (this.isCancel()) {
            return;
        }
        if (this.errorHandling) {
            if (this.isError()) {
                MessageManager.showErrorMessage(this.parent, this.getErrorMessages());
                return;
            }
            if (!CollectionUtil.isNull(this.unableDownloadInfoTitleSet)) {
                stringArray = new String[]{"The following gene property was not able to be downloaded.", InfoUtil.createInfoTitleNameString(this.unableDownloadInfoTitleSet)};
                MessageManager.showWarningMessage(this.parent, stringArray);
            }
        }
        try {
            stringArray = new ArrayList(this.geneInfoTitleC);
            stringArray.removeAll(this.unableDownloadInfoTitleSet);
            if (!(CollectionUtil.isNull(stringArray) || this.overwriteCheck && !GeneInfoFacade.validateInfoTitle(this.parent, (List)stringArray))) {
                GeneInfoRegister.saveGeneInfo(this.location, (List)stringArray, this.organismCodeInfoListMap);
            }
        }
        catch (Exception exception) {
            String string = "Fail to save gene properties.";
            logger.warn(string, exception);
            MessageManager.showWarningMessage(this.parent, string);
        }
        stringArray = this.getAfterRunnable();
        if (stringArray != null) {
            stringArray.run();
        }
    }
}

