/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info.gene;

import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.InfoImporter;
import cgdp.recog.info.gene.GeneInfo;
import cgdp.recog.info.gene.GeneInfoFacade;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.info.gene.GeneInfoTitleComparator;
import cgdp.recog.info.gene.GeneInfoTypeValidater;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.StringTool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

class GeneInfoListImporter
extends InfoImporter {
    protected static final String DELIMITER = "\t";
    private String location;
    private Map geneInfoMap = new HashMap();
    private int locusTagIndex = -1;
    private String targetLocusTag;
    private Set targetLocusTagSet = new HashSet();
    private Set organismCodeSet = new HashSet();

    protected GeneInfoListImporter(String string, String string2) {
        super(string);
        this.location = string2;
    }

    @Override
    protected void initTitleConvertMap(Map map) {
        List list = GeneInfoFacade.getGeneInfoTitleList();
        for (AbstractInfoTitle abstractInfoTitle : list) {
            map.put(abstractInfoTitle.getKey().toLowerCase(), abstractInfoTitle);
        }
    }

    public static GeneInfoListImporter createRegisterGeneInfoImporter(String string, String string2) {
        GeneInfoListImporter geneInfoListImporter = new GeneInfoListImporter(string, string2);
        geneInfoListImporter.addConvertTitle("Organism", GeneInfoTitle.TITLE_ORGANISM_CODE);
        geneInfoListImporter.addConvertTitle("locustag", GeneInfoTitle.TITLE_LOCUSTAG_SERVER);
        return geneInfoListImporter;
    }

    public static GeneInfoListImporter createGeneInfoImporter(String string, String string2, String string3) {
        GeneInfoListImporter geneInfoListImporter = new GeneInfoListImporter(string, string2);
        geneInfoListImporter.addConvertTitle("Organism", GeneInfoTitle.TITLE_ORGANISM_CODE);
        geneInfoListImporter.addConvertTitle("locustag", GeneInfoTitle.TITLE_LOCUSTAG_SERVER);
        geneInfoListImporter.setTargetLocusTag(string3);
        return geneInfoListImporter;
    }

    public void setTargetLocusTag(String string) {
        this.targetLocusTag = string;
    }

    private boolean isTargetLocusTag() {
        return !StringTool.isNull(this.targetLocusTag) && this.locusTagIndex != -1;
    }

    public void setTargetLocusTagSet(Set set) {
        this.targetLocusTagSet = set;
    }

    private boolean isMultiTargetLocusTag() {
        return !CollectionUtil.isNull(this.targetLocusTagSet) && this.locusTagIndex != -1;
    }

    @Override
    protected void parseDataLineCore(int n, String string) {
        String string2;
        String string3 = null;
        GeneInfo geneInfo = new GeneInfo();
        Vector vector = StringTool.splitString(string, DELIMITER);
        if (this.isTargetLocusTag() && !(string2 = (String)vector.get(this.locusTagIndex)).equals(this.targetLocusTag)) {
            return;
        }
        if (this.isMultiTargetLocusTag() && !this.targetLocusTagSet.contains(string2 = (String)vector.get(this.locusTagIndex))) {
            return;
        }
        if (vector.size() != this.getInfoTitleList().size()) {
            this.setError(true);
            this.setErrorMessage("The data is not correct. [" + string + "]");
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            GeneInfoTitle geneInfoTitle = (GeneInfoTitle)this.infoTitleList.get(i);
            String string4 = String.valueOf(vector.get(i)).trim();
            if (geneInfoTitle.equals(GeneInfoTitle.TITLE_STRAND) && !GeneInfoTypeValidater.validateStrandValue(geneInfoTitle, string4)) {
                this.setError(true);
                this.setErrorMessage("The data is not correct. column=" + geneInfoTitle.getName() + "(" + geneInfoTitle.getTypeName() + ") value=" + string4);
                return;
            }
            if (!geneInfoTitle.equals(GeneInfoTitle.TITLE_STRAND) && !GeneInfoTypeValidater.validateValue(geneInfoTitle, string4)) {
                this.setError(true);
                this.setErrorMessage("The data is not correct. column=" + geneInfoTitle.getName() + "(" + geneInfoTitle.getTypeName() + ") value=" + string4);
                return;
            }
            if (geneInfoTitle.equalsKey("sp") || geneInfoTitle.equalsKey("Organism")) {
                string3 = string4;
                this.organismCodeSet.add(string3);
                continue;
            }
            geneInfo.putInfo(geneInfoTitle, string4);
        }
        if (string3 == null) {
            return;
        }
        ArrayList<GeneInfo> arrayList = (ArrayList<GeneInfo>)this.geneInfoMap.get(string3);
        if (arrayList == null) {
            arrayList = new ArrayList<GeneInfo>();
            this.geneInfoMap.put(string3, arrayList);
        }
        arrayList.add(geneInfo);
        if (this.isTargetLocusTag()) {
            this.setReadData(true);
        }
    }

    @Override
    protected void afterProcess() {
        for (GeneInfoTitle geneInfoTitle : this.getInfoTitleList()) {
            if (!geneInfoTitle.isEditable()) continue;
            geneInfoTitle.setOrganismCodeSet(new HashSet(this.organismCodeSet));
        }
    }

    @Override
    protected AbstractInfoTitle createInfoTitle(String string) {
        return GeneInfoTitle.createGeneInfoTitle(string, this.location);
    }

    @Override
    protected void parseHeaderLine(String string) {
        super.parseHeaderLine(string);
        this.locusTagIndex = super.getInfoTitleList().indexOf(GeneInfoTitle.TITLE_LOCUSTAG_SERVER);
    }

    @Override
    public List getInfoTitleList() {
        ArrayList arrayList = new ArrayList(super.getInfoTitleList());
        Collections.sort(arrayList, new GeneInfoTitleComparator());
        return arrayList;
    }

    Map getGeneInfoMap() {
        return this.geneInfoMap;
    }

    List getGeneInfoList() {
        ArrayList<GeneInfo> arrayList = new ArrayList<GeneInfo>();
        for (String string : this.geneInfoMap.keySet()) {
            List list = (List)this.geneInfoMap.get(string);
            for (GeneInfo geneInfo : list) {
                geneInfo.putInfo(GeneInfoTitle.TITLE_ORGANISM_CODE, string);
                arrayList.add(geneInfo);
            }
        }
        return arrayList;
    }
}

