/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.mapping;

import cgdp.recog.data.Chromosome;
import cgdp.recog.data.ContigTbl;
import cgdp.recog.mapping.ContigGap;
import cgdp.recog.mapping.ContigGapGroup;
import cgdp.recog.mapping.ContigGapTableModel;
import cgdp.recog.mapping.MapCondition;
import cgdp.recog.mapping.MapConf;
import cgdp.recog.mapping.MapConfComparator;
import cgdp.recog.mapping.MapFacade;
import cgdp.recog.mapping.MapRecode;
import cgdp.recog.mapping.MapRecodeContigTableModel;
import cgdp.recog.organism.OrganismComboBox;
import cgdp.recog.system.property.ApplicationPropertyFacade;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FocusTextField;
import cgdp.recog.util.ListSelectUtil;
import cgdp.recog.util.MapUtil;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.RestrictTextField;
import cgdp.recog.util.StringTool;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;

public class MapEditDialog
extends AbstractApplyDialog
implements ItemListener {
    private static final ApplicationLogger logger = new ApplicationLogger(MapEditDialog.class);
    private static MapEditDialog MAP_EDIT_DIALOG;
    private static final String TITLE = "Edit the incomplete genome's mapping information";
    private OrganismComboBox organismComboBox;
    private FocusTextField nameTextField;
    private JComboBox nameComboBox;
    private JButton deleteMappingButton;
    private JPanel newNamePanel;
    private JPanel editNamePanel;
    private JTable contigTable;
    private JTable editTable;
    private RestrictTextField endGapField;
    private JComboBox shapeComboBox;
    private JButton addButton;
    private JButton deleteButton;
    private JButton upButton;
    private JButton downButton;
    private JComboBox chrNoComboBox;
    private JButton addChrButton;
    private JButton editChrButton;
    private JButton deleteChrButton;
    private Map contigGapGroupMap = new HashMap();
    private Map chromosomeMap = new HashMap();
    private String targetChrNo;
    private boolean editMode = false;
    private Map mapConfMap = new HashMap();
    private MapConf targetMapConf;
    private Set removeMapConfSet = new HashSet();

    public MapEditDialog(Frame frame) {
        super(frame);
        this.createComponents();
    }

    public static void createInstance(Frame frame) {
        MAP_EDIT_DIALOG = new MapEditDialog(frame);
    }

    public static MapEditDialog getInstance() {
        return new MapEditDialog((Frame)MAP_EDIT_DIALOG.getParent());
    }

    private void createComponents() {
        this.setTitle(TITLE);
        this.setModal(true);
        this.setResizable(false);
        this.newNamePanel = this.createNewNamePanel();
        this.editNamePanel = this.createEditNamePanel();
        this.contigTable = new JTable(new MapRecodeContigTableModel());
        this.contigTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                MapEditDialog.this.setEnableAddButton();
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.contigTable, 20, 30);
        jScrollPane.getViewport().setPreferredSize(new Dimension(150, 200));
        this.editTable = new JTable(new ContigGapTableModel());
        this.editTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                MapEditDialog.this.setEnableDeleteButton();
                MapEditDialog.this.setEnableUpDownButton();
            }
        });
        TableColumn tableColumn = this.editTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(150);
        TableColumn tableColumn2 = this.editTable.getColumnModel().getColumn(1);
        tableColumn2.setCellEditor(new DefaultCellEditor(this.createDirectionComboBox()));
        tableColumn2.setPreferredWidth(50);
        JScrollPane jScrollPane2 = new JScrollPane(this.editTable, 20, 30);
        jScrollPane2.getViewport().setPreferredSize(new Dimension(300, 200));
        JPanel jPanel = this.createChromPanel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.createOrgnismPanel(), new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 17, 2, new Insets(15, 15, 0, 15), 0, 0));
        this.getContentPane().add((Component)this.newNamePanel, new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0, 17, 2, new Insets(15, 15, 0, 15), 0, 0));
        this.getContentPane().add((Component)this.editNamePanel, new GridBagConstraints(0, 2, 4, 1, 0.0, 0.0, 17, 2, new Insets(15, 15, 0, 15), 0, 0));
        this.getContentPane().add((Component)jPanel, new GridBagConstraints(2, 3, 2, 1, 0.0, 0.0, 17, 2, new Insets(15, 10, 10, 10), 0, 0));
        this.getContentPane().add((Component)jScrollPane, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 20, 0, 10), 0, 0));
        this.getContentPane().add((Component)this.createAddDeleteButtonPanel(), new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 3, new Insets(10, 10, 0, 10), 0, 0));
        this.getContentPane().add((Component)jScrollPane2, new GridBagConstraints(2, 4, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 10, 0, 10), 0, 0));
        this.getContentPane().add((Component)this.createUpDownPanel(), new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 17, 3, new Insets(10, 10, 0, 20), 0, 0));
        this.getContentPane().add((Component)this.createEndGapPanel(), new GridBagConstraints(2, 5, 1, 1, 1.0, 0.0, 13, 2, new Insets(10, 10, 0, 10), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 6, 4, 1, 0.0, 0.0, 10, 0, new Insets(10, 15, 15, 15), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private JPanel createOrgnismPanel() {
        JLabel jLabel = new JLabel("Organism");
        this.organismComboBox = new OrganismComboBox();
        this.organismComboBox.addItemListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.organismComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel createNewNamePanel() {
        JLabel jLabel = new JLabel("Name");
        this.nameTextField = new FocusTextField();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.nameTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 25, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel createEditNamePanel() {
        JLabel jLabel = new JLabel("Name");
        this.nameComboBox = new JComboBox();
        this.nameComboBox.addItemListener(this);
        this.deleteMappingButton = new JButton("Delete Mapping");
        this.deleteMappingButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.nameComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 25, 0, 0), 0, 0));
        jPanel.add((Component)this.deleteMappingButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel createChromPanel() {
        JLabel jLabel = new JLabel("Chr.");
        this.chrNoComboBox = new JComboBox();
        this.addChrButton = new JButton("Add Chr.");
        this.addChrButton.addActionListener(this);
        this.editChrButton = new JButton("Edit Chr.");
        this.editChrButton.addActionListener(this);
        this.deleteChrButton = new JButton("Delete Chr.");
        this.deleteChrButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.chrNoComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        jPanel.add((Component)this.addChrButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        jPanel.add((Component)this.editChrButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        jPanel.add((Component)this.deleteChrButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel createAddDeleteButtonPanel() {
        this.addButton = new JButton(">>");
        this.addButton.addActionListener(this);
        this.deleteButton = new JButton("<<");
        this.deleteButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.addButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.deleteButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 10, 0, new Insets(15, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel createUpDownPanel() {
        this.upButton = new JButton("Up");
        this.upButton.addActionListener(this);
        this.downButton = new JButton("Down");
        this.downButton.addActionListener(this);
        this.upButton.setPreferredSize(new Dimension(this.downButton.getPreferredSize().width, this.upButton.getPreferredSize().height));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.upButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.downButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 11, 0, new Insets(15, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel createEndGapPanel() {
        JLabel jLabel = new JLabel("Shape");
        this.shapeComboBox = this.createShapeComboBox();
        this.shapeComboBox.addItemListener(this);
        JLabel jLabel2 = new JLabel("End Gap");
        this.endGapField = new RestrictTextField(10);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.shapeComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 10), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.endGapField, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        return jPanel;
    }

    private JComboBox createShapeComboBox() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem("linear");
        jComboBox.addItem("circular");
        return jComboBox;
    }

    private JComboBox createDirectionComboBox() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem("+");
        jComboBox.addItem("-");
        return jComboBox;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateValue(String string, boolean bl) {
        try {
            List list;
            this.editMode = bl;
            this.updateOrganismComboBox(string);
            this.updateMapConfMap(string);
            if (this.editMode) {
                this.updateNameComboBox();
                String string2 = this.targetMapConf.getFilename();
                list = MapFacade.geMapRecodeList(string, string2);
                this.contigGapGroupMap = MapFacade.createContigGapGroupMap(list, string);
            } else {
                list = MapFacade.getDefaultMapRecodeList(string);
                this.contigGapGroupMap = MapFacade.createContigGapGroupMap(list, string);
            }
            this.updateValue(string, list);
            boolean bl2 = true;
            return bl2;
        }
        catch (Exception exception) {
            String string3 = "Fail to initialize the mapping dialog.";
            logger.warn(string3, exception);
            boolean bl3 = false;
            return bl3;
        }
        finally {
            this.setVisibleNamePanel();
        }
    }

    private void updateValue(String string, List list) throws Exception {
        this.updateChromosomeMap(string);
        this.updateChrNoComboBox();
        if (!MapUtil.isNull(this.contigGapGroupMap)) {
            this.chrNoComboBox.setSelectedIndex(0);
        }
        this.updateEditTable();
        this.updateShapeComboBox();
        ContigTbl contigTbl = new ContigTbl(string);
        contigTbl.read();
        System.err.println("RRRLIST++" + list);
        List list2 = MapFacade.removeGap(list);
        Set set = MapFacade.getContigIdSetFromMapRecode(list);
        list2.addAll(MapFacade.createMapRecodeFromContig(contigTbl.values(), set));
        System.err.println("***" + (MapRecode)list2.get(0));
        System.err.println("***" + ((MapRecode)list2.get(0)).getContig());
        Collections.sort(list2, new ContigMapRecodeComparator());
        this.getMapRecodeContigTableModel().setMapRecodeList(list2);
        this.setEnableAddButton();
        this.setEnableDeleteButton();
        this.setEnableUpDownButton();
        this.setVisibleNameField();
    }

    private void updateChromosomeMap(String string) {
        MapConf mapConf = (MapConf)this.mapConfMap.get(this.getMapName());
        String string2 = null;
        if (mapConf != null) {
            string2 = mapConf.getFilename();
        }
        List list = MapFacade.createChromosomeList(this.getOrganismCode(), this.contigGapGroupMap, string2);
        this.chromosomeMap.clear();
        for (Chromosome chromosome : list) {
            this.chromosomeMap.put(chromosome.getName(), chromosome);
        }
    }

    private void setVisibleNamePanel() {
        this.newNamePanel.setVisible(!this.editMode);
        this.editNamePanel.setVisible(this.editMode);
    }

    private void updateMapConfMap(String string) {
        this.mapConfMap.clear();
        List list = MapFacade.getMapConfList(string);
        for (MapConf mapConf : list) {
            String string2 = mapConf.getName();
            this.mapConfMap.put(string2, mapConf);
            if (!mapConf.isSelected()) continue;
            this.targetMapConf = mapConf;
        }
    }

    private void updateNameComboBox() {
        ArrayList<MapConf> arrayList = new ArrayList<MapConf>();
        String string = this.getOrganismCode();
        for (MapConf mapConf : this.mapConfMap.values()) {
            if (!mapConf.equalsOrganism(string)) continue;
            arrayList.add(mapConf);
        }
        Collections.sort(arrayList, new MapConfComparator());
        for (MapConf mapConf : arrayList) {
            this.nameComboBox.addItem(mapConf.getName());
        }
    }

    private void updateOrganismComboBox(String string) {
        List list = ApplicationPropertyFacade.getIncompleteOrganismList();
        this.organismComboBox.removeItemListener(this);
        this.organismComboBox.removeAllItems();
        this.organismComboBox.updateValueByOrganism(list);
        this.organismComboBox.setSelectedOrganismCode(string);
        this.organismComboBox.addItemListener(this);
    }

    private MapRecodeContigTableModel getMapRecodeContigTableModel() {
        return (MapRecodeContigTableModel)this.contigTable.getModel();
    }

    private ContigGapTableModel getContigGapTableModel() {
        return (ContigGapTableModel)this.editTable.getModel();
    }

    private void setEnableAddButton() {
        if (StringTool.isNull(this.getChromosomeNo())) {
            this.addButton.setEnabled(false);
            return;
        }
        int n = this.contigTable.getSelectedRow();
        this.addButton.setEnabled(n != -1);
    }

    private void setEnableDeleteButton() {
        if (StringTool.isNull(this.getChromosomeNo())) {
            this.deleteButton.setEnabled(false);
            return;
        }
        int n = this.editTable.getSelectedRow();
        this.deleteButton.setEnabled(n != -1);
    }

    private void setEnableUpDownButton() {
        if (StringTool.isNull(this.getChromosomeNo())) {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
            return;
        }
        int[] nArray = this.editTable.getSelectedRows();
        if (nArray == null || nArray.length == 0) {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
            return;
        }
        this.upButton.setEnabled(nArray[0] != 0);
        this.downButton.setEnabled(nArray[nArray.length - 1] != this.editTable.getRowCount() - 1);
    }

    private void setVisibleNameField() {
        this.editNamePanel.setVisible(this.editMode);
        this.newNamePanel.setVisible(!this.editMode);
    }

    private void setEnableEndGap() {
        this.endGapField.setEnabled(!this.isCircular());
    }

    private String getChrShape() {
        return (String)this.shapeComboBox.getSelectedItem();
    }

    private boolean isCircular() {
        return Chromosome.isCircular(this.getChrShape());
    }

    private String getChromosomeNo() {
        String string = (String)this.chrNoComboBox.getSelectedItem();
        return string;
    }

    private String getOrganismCode() {
        return this.organismComboBox.getSelectedOrganismCode();
    }

    private boolean isExistContigGapList() {
        if (MapUtil.isNull(this.contigGapGroupMap)) {
            return false;
        }
        for (ContigGapGroup contigGapGroup : this.contigGapGroupMap.values()) {
            if (!contigGapGroup.isExistContigGap()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean check() {
        if (this.editMode && this.nameComboBox.getItemCount() == 0) {
            return true;
        }
        if (StringTool.isNull(this.getMapName())) {
            String string = "Input name.";
            MessageManager.showErrorMessage((Component)this, string);
            return false;
        }
        if (!this.isExistContigGapList()) {
            String string = "Select contig.";
            MessageManager.showErrorMessage((Component)this, string);
            return false;
        }
        if (this.mapConfMap.containsKey(this.getMapName()) && (!this.editMode || this.editMode && !this.targetMapConf.equalsMapName(this.getMapName()))) {
            String[] stringArray = new String[]{"You have already made the mapping information [" + this.getMapName() + "].", "Input the another name."};
            MessageManager.showErrorMessage((Component)this, stringArray);
            return false;
        }
        return true;
    }

    @Override
    protected boolean apply() {
        return true;
    }

    private void updateChrNoComboBox() {
        this.chrNoComboBox.removeItemListener(this);
        this.chrNoComboBox.removeAllItems();
        if (!MapUtil.isNull(this.contigGapGroupMap)) {
            List list = MapFacade.getChromosomeNoList(this.contigGapGroupMap);
            for (String string : list) {
                this.chrNoComboBox.addItem(string);
            }
        }
        this.chrNoComboBox.addItemListener(this);
    }

    private String getMapName() {
        if (this.editMode) {
            return (String)this.nameComboBox.getSelectedItem();
        }
        return this.nameTextField.getText();
    }

    private MapConf getMapConf() {
        String string = this.getMapName();
        MapConf mapConf = (MapConf)this.mapConfMap.get(string);
        return mapConf;
    }

    private int getEndGap() {
        String string = this.endGapField.getText();
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public MapCondition createMapCondition() {
        Object object;
        MapConf mapConf;
        this.updateContigMapGroup();
        if (this.editMode) {
            mapConf = this.targetMapConf;
        } else {
            mapConf = new MapConf();
            object = this.createFilename(this.getOrganismCode());
            mapConf.setFilename((String)object);
        }
        if (mapConf != null) {
            mapConf.setOrganismCode(this.getOrganismCode());
            mapConf.setName(this.getMapName());
        }
        object = new MapCondition();
        ((MapCondition)object).setMapConf(mapConf);
        ((MapCondition)object).setContigGapGroupMap(this.contigGapGroupMap);
        ((MapCondition)object).setRemoveMapConfSet(this.removeMapConfSet);
        return object;
    }

    private String createFilename(String string) {
        return string + System.currentTimeMillis();
    }

    private void addChr() {
        ChrNoAddDialog chrNoAddDialog = new ChrNoAddDialog(this);
        chrNoAddDialog.updateValue(null);
        chrNoAddDialog.setVisible(true);
        if (!chrNoAddDialog.isCanceled()) {
            String string = chrNoAddDialog.getChromosomeNo();
            ContigGapGroup contigGapGroup = new ContigGapGroup();
            contigGapGroup.setChrNo(string);
            this.contigGapGroupMap.put(string, contigGapGroup);
            this.updateChromosomeMap(this.getOrganismCode());
            this.updateChrNoComboBox();
            this.chrNoComboBox.setSelectedItem(string);
            this.updateEditTable();
            this.setEnableAddButton();
            this.targetChrNo = string;
        }
    }

    private void editChr() {
        String string = this.getChromosomeNo();
        ChrNoAddDialog chrNoAddDialog = new ChrNoAddDialog(this);
        chrNoAddDialog.updateValue(string);
        chrNoAddDialog.setVisible(true);
        if (!chrNoAddDialog.isCanceled()) {
            String string2 = chrNoAddDialog.getChromosomeNo();
            ContigGapGroup contigGapGroup = (ContigGapGroup)this.contigGapGroupMap.get(string);
            contigGapGroup.setChrNo(string2);
            this.contigGapGroupMap.remove(string);
            this.contigGapGroupMap.put(string2, contigGapGroup);
            this.updateChromosomeMap(this.getOrganismCode());
            this.updateChrNoComboBox();
            this.chrNoComboBox.removeItemListener(this);
            this.chrNoComboBox.setSelectedItem(string2);
            this.chrNoComboBox.addItemListener(this);
            this.updateEditTable();
            Chromosome chromosome = (Chromosome)this.chromosomeMap.get(string2);
            contigGapGroup.setChromosome(chromosome);
            List list = ListSelectUtil.getSelectedDataList(this.contigTable);
            this.getMapRecodeContigTableModel().fireTableDataChanged();
            ListSelectUtil.select(this.contigTable, list);
            this.targetChrNo = string2;
        }
    }

    private void deleteChr() {
        List list;
        String string = this.getChromosomeNo();
        if (!MessageManager.showConfirmMessage((Component)this, "Delete Chromosome No. [" + string + "]")) {
            return;
        }
        ContigGapGroup contigGapGroup = (ContigGapGroup)this.contigGapGroupMap.remove(string);
        if (contigGapGroup != null) {
            contigGapGroup.clearChromosome();
        }
        this.updateChromosomeMap(this.getOrganismCode());
        this.updateChrNoComboBox();
        if (!MapUtil.isNull(this.contigGapGroupMap)) {
            list = MapFacade.getChromosomeNoList(this.contigGapGroupMap);
            String string2 = (String)list.get(0);
            this.chrNoComboBox.setSelectedItem(string2);
        }
        this.updateEditTable();
        this.setEnableAddButton();
        list = ListSelectUtil.getSelectedDataList(this.contigTable);
        this.getMapRecodeContigTableModel().fireTableDataChanged();
        ListSelectUtil.select(this.contigTable, list);
    }

    private void add() {
        Object object;
        Object object22;
        List list = ListSelectUtil.getSelectedDataList(this.contigTable);
        List list2 = MapFacade.createContigGapList(list);
        for (Object object22 : this.contigGapGroupMap.keySet()) {
            object = (ContigGapGroup)this.contigGapGroupMap.get(object22);
            ((ContigGapGroup)object).removeAllContigGapList(list2);
        }
        String string = this.getChromosomeNo();
        object22 = (Chromosome)this.chromosomeMap.get(string);
        for (ContigGap contigGap : list2) {
            contigGap.setChromosome((Chromosome)object22);
        }
        object = (ContigGapGroup)this.contigGapGroupMap.get(string);
        ((ContigGapGroup)object).addAllContigGapList(list2);
        this.getContigGapTableModel().setContigGapList(((ContigGapGroup)object).getContigGapList());
        ListSelectUtil.select(this.editTable, list2);
        this.getMapRecodeContigTableModel().fireTableDataChanged();
        ListSelectUtil.select(this.contigTable, list);
        this.setEnableUpDownButton();
        this.setEnableDeleteButton();
    }

    private void delete() {
        List list = ListSelectUtil.remove(this.editTable);
        for (ContigGap contigGap : list) {
            contigGap.clearChromosome();
        }
        List list2 = ListSelectUtil.getSelectedDataList(this.contigTable);
        this.getMapRecodeContigTableModel().fireTableDataChanged();
        ListSelectUtil.select(this.contigTable, list2);
    }

    private void up() {
        ListSelectUtil.up(this.editTable);
    }

    private void down() {
        ListSelectUtil.down(this.editTable);
    }

    private void updateContigMapGroup() {
        ArrayList arrayList = new ArrayList(this.getContigGapTableModel().getContigGaplist());
        ContigGapGroup contigGapGroup = new ContigGapGroup();
        contigGapGroup.setChrNo(this.targetChrNo);
        contigGapGroup.setContigGapList(arrayList);
        contigGapGroup.setEndGapLength(this.getEndGap());
        contigGapGroup.setShape(this.getChrShape());
        this.contigGapGroupMap.put(this.targetChrNo, contigGapGroup);
    }

    private void updateEditTable() {
        if (MapUtil.isNull(this.contigGapGroupMap)) {
            this.getContigGapTableModel().setContigGapList(new ArrayList());
            this.endGapField.setText("");
            this.targetChrNo = null;
        } else {
            String string = this.getChromosomeNo();
            ContigGapGroup contigGapGroup = (ContigGapGroup)this.contigGapGroupMap.get(string);
            if (contigGapGroup == null) {
                this.getContigGapTableModel().setContigGapList(new ArrayList());
                this.endGapField.setText("");
                this.targetChrNo = null;
            } else {
                this.getContigGapTableModel().setContigGapList(contigGapGroup.getContigGapList());
                this.endGapField.setText(String.valueOf(contigGapGroup.getEndGapLength()));
                this.targetChrNo = string;
            }
        }
        this.setEnableDeleteButton();
        this.setEnableUpDownButton();
    }

    private void updateShapeComboBox() {
        String string = this.getChromosomeNo();
        Chromosome chromosome = (Chromosome)this.chromosomeMap.get(string);
        String string2 = "linear";
        if (chromosome != null) {
            string2 = chromosome.getShape();
        }
        this.shapeComboBox.removeItemListener(this);
        this.shapeComboBox.setSelectedItem(string2);
        this.shapeComboBox.addItemListener(this);
    }

    private void changeMapping() {
        try {
            MapConf mapConf = this.getMapConf();
            if (mapConf == null) {
                this.clearMapping();
            } else {
                String string = this.getOrganismCode();
                String string2 = mapConf.getFilename();
                List list = MapFacade.geMapRecodeList(string, string2);
                this.contigGapGroupMap = MapFacade.createContigGapGroupMap(list, string);
                this.targetMapConf = mapConf;
                this.updateValue(string, list);
            }
        }
        catch (Exception exception) {
            logger.warn("Fail to change the mapping informatioin. " + this.getMapName(), exception);
        }
    }

    private void clearMapping() {
        try {
            String string = this.getOrganismCode();
            this.contigGapGroupMap = new HashMap();
            this.targetMapConf = null;
            this.updateValue(string, new ArrayList());
        }
        catch (Exception exception) {
            logger.warn("Fail to clear the mapping informatioin. " + this.getMapName(), exception);
        }
    }

    private void deleteMapping() {
        MapConf mapConf = this.targetMapConf;
        Object[] objectArray = new String[]{"Delete the mapping information?", mapConf.getName()};
        if (!MessageManager.showConfirmMessage((Component)this, objectArray)) {
            return;
        }
        this.removeMapConfSet.add(mapConf);
        this.nameComboBox.removeItem(mapConf.getName());
        if (this.nameComboBox.getItemCount() > 0) {
            this.nameComboBox.setSelectedIndex(0);
            this.changeMapping();
        } else {
            this.nameComboBox.setSelectedIndex(-1);
            this.clearMapping();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.addChrButton) {
            this.addChr();
        } else if (actionEvent.getSource() == this.editChrButton) {
            this.editChr();
        } else if (actionEvent.getSource() == this.deleteChrButton) {
            this.deleteChr();
        } else if (actionEvent.getSource() == this.addButton) {
            this.add();
        } else if (actionEvent.getSource() == this.deleteButton) {
            this.delete();
        } else if (actionEvent.getSource() == this.upButton) {
            this.up();
        } else if (actionEvent.getSource() == this.downButton) {
            this.down();
        } else if (actionEvent.getSource() == this.deleteMappingButton) {
            this.deleteMapping();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.organismComboBox) {
            String string = this.getOrganismCode();
            this.updateValue(string, this.editMode);
        } else if (itemEvent.getSource() == this.chrNoComboBox) {
            this.updateContigMapGroup();
            this.updateEditTable();
            this.updateShapeComboBox();
        } else if (itemEvent.getSource() == this.nameComboBox) {
            this.changeMapping();
        } else if (itemEvent.getSource() == this.shapeComboBox) {
            this.setEnableEndGap();
        }
    }

    private class ContigMapRecodeComparator
    implements Comparator {
        private ContigMapRecodeComparator() {
        }

        public int compare(Object object, Object object2) {
            MapRecode mapRecode = (MapRecode)object;
            MapRecode mapRecode2 = (MapRecode)object2;
            if (!mapRecode.isExistChromosome() && mapRecode2.isExistChromosome()) {
                return -1;
            }
            if (mapRecode.isExistChromosome() && !mapRecode2.isExistChromosome()) {
                return 1;
            }
            if (mapRecode.isExistChromosome() && mapRecode2.isExistChromosome()) {
                int n = mapRecode.getChrNo().compareTo(mapRecode2.getChrNo());
                if (n != 0) {
                    return n;
                }
                System.err.println("m1:" + mapRecode.getChrNo() + " " + mapRecode.getContig());
                System.err.println("m2:" + mapRecode2.getChrNo() + " " + mapRecode2.getContig());
                return mapRecode.getContig().getDisplayName().compareTo(mapRecode2.getContig().getDisplayName());
            }
            return mapRecode.getContig().getDisplayName().compareTo(mapRecode2.getContig().getDisplayName());
        }
    }

    private class ChrNoAddDialog
    extends AbstractApplyDialog {
        private FocusTextField nameTextField;

        public ChrNoAddDialog(Dialog dialog) {
            super(dialog);
            this.createComponents();
        }

        private void createComponents() {
            this.setTitle("Add Chromosome No.");
            this.setModal(true);
            this.setResizable(false);
            JLabel jLabel = new JLabel("Chromosome No.");
            this.nameTextField = new FocusTextField(10);
            this.getContentPane().setLayout(new GridBagLayout());
            this.getContentPane().add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 15, 0, 0), 0, 0));
            this.getContentPane().add((Component)this.nameTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(15, 0, 0, 15), 0, 0));
            this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 0, new Insets(15, 0, 15, 15), 0, 0));
            this.pack();
            this.setLocationRelativeTo(this.getParent());
        }

        public void updateValue(String string) {
            if (!StringTool.isNull(string)) {
                this.nameTextField.setText(string);
            }
        }

        public String getChromosomeNo() {
            return this.nameTextField.getText();
        }

        @Override
        protected boolean check() {
            if (StringTool.isNull(this.getChromosomeNo())) {
                MessageManager.showErrorMessage((Component)this, "Input chromosome No.");
                return false;
            }
            return true;
        }

        @Override
        protected boolean apply() {
            return true;
        }
    }
}

