/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.multiplealign;

import cgdp.recog.bean.Const;
import cgdp.recog.bean.MainWindow;
import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.info.AbstractInfo;
import cgdp.recog.info.gene.GeneInfo;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.server.AccessServer;
import cgdp.recog.server.ServerAccessException;
import cgdp.recog.system.OS;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.GeneUtil;
import cgdp.recog.util.Launcher;
import cgdp.recog.util.SimpleServerConnection;
import cgdp.recog.util.StringTool;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class MultipleAlignmentExecuter {
    private static final ApplicationLogger logger = new ApplicationLogger(MultipleAlignmentExecuter.class);
    private static final String EXTENSION_FASTA = ".fasta";
    private static final String EXTENSTION_ALN = ".aln";
    private static final String EXTENSTION_PH = ".ph";
    private static final String EXTENSTION_PHB = ".phb";
    private static final String DELIMITER = ":";
    private MediatorImpl mediator;
    private ClusterTbl clusterTbl;
    private MainWindow mainWindow;
    private Collection geneInfoC = new ArrayList();
    private String outputFilepath;

    public MultipleAlignmentExecuter(MediatorImpl mediatorImpl, ClusterTbl clusterTbl, MainWindow mainWindow) {
        this.mediator = mediatorImpl;
        this.clusterTbl = clusterTbl;
        this.mainWindow = mainWindow;
    }

    public int executeMultipleAlignment(ProgressImpl progressImpl) throws Exception {
        this.outputFilepath = Const.WORK_DIR + new Date().getTime();
        String string = this.getFastAFilepath();
        int n = this.createInputFile(progressImpl, string);
        if (n == -1) {
            return n;
        }
        if (n < 2) {
            logger.warn("Two amino acid sequences or more are necessary to execute this processing.");
            return n;
        }
        progressImpl.nextProc();
        progressImpl.setTotal(100);
        progressImpl.setCount(-1);
        progressImpl.increment();
        progressImpl.setEnabledCancelButton(false);
        this.executeMultipleAlignment(progressImpl, string);
        return n;
    }

    private int createInputFile(ProgressImpl progressImpl, String string) throws Exception {
        if (!AccessServer.getInstance().isEnableAccess()) {
            throw new ServerAccessException();
        }
        SequenceDownloader sequenceDownloader = new SequenceDownloader(this.geneInfoC);
        sequenceDownloader.execute();
        int n = sequenceDownloader.getGeneCount();
        FileUtil.outputFile(sequenceDownloader.getSequence(), string);
        return n;
    }

    private void executeMultipleAlignment(final ProgressImpl progressImpl, String string) throws IOException {
        OptionTbl optionTbl = OptionTbl.getInstance();
        List list = optionTbl.getOptionValues().getClustalWAlignOpts(OS.isWindows());
        String[] stringArray = new String[2 + list.size()];
        stringArray[0] = optionTbl.getOptionValues().getClustalW();
        stringArray[1] = OS.isWindows() ? "/INFILE=" + string : "-INFILE=" + string;
        Iterator iterator = list.iterator();
        int n = 2;
        while (iterator.hasNext()) {
            stringArray[n] = (String)iterator.next();
            ++n;
        }
        Launcher launcher = new Launcher(stringArray){

            @Override
            protected void handleInputStream(String string) {
                super.handleInputStream(string);
                if (string.indexOf("Pairwise") != -1) {
                    progressImpl.setCount(49);
                    progressImpl.increment();
                } else if (string.indexOf("Start of Multiple Alignment") != -1) {
                    progressImpl.setCount(99);
                    progressImpl.increment();
                }
            }
        };
        launcher.execute();
    }

    public void createTreeFile(ProgressImpl progressImpl, String string) throws IOException {
        this.outputFilepath = MultipleAlignmentExecuter.removeExtentionFromAlnFile(string);
        OptionTbl optionTbl = OptionTbl.getInstance();
        List list = optionTbl.getOptionValues().getClustalWTreeOpts(OS.isWindows());
        String[] stringArray = new String[2 + list.size()];
        stringArray[0] = optionTbl.getOptionValues().getClustalW();
        stringArray[1] = OS.isWindows() ? "/INFILE=" + string : "-INFILE=" + string;
        Iterator iterator = list.iterator();
        int n = 2;
        while (iterator.hasNext()) {
            stringArray[n] = (String)iterator.next();
            ++n;
        }
        Launcher launcher = new Launcher(stringArray);
        launcher.execute();
    }

    private String createOrganismLocusTagKey(Collection collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object : collection) {
            String string = GeneUtil.removeDomainNo(((GeneInfo)object).getLocusTag());
            String string2 = (String)((AbstractInfo)object).getInfo(GeneInfoTitle.TITLE_ORGANISM_CODE);
            arrayList.add(this.createOrganismLocusTag(string2, string));
        }
        Collections.sort(arrayList);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("&no_header=1");
        stringBuffer.append("&fields=sp,name,sequence");
        for (String string : arrayList) {
            stringBuffer.append("&key=");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private Map createOrganismLocusTagMap(String string, List list) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = GeneUtil.removeDomainNo((String)iterator.next());
            hashMap.put(string2, string);
        }
        return hashMap;
    }

    private String createOrganismLocusTag(String string, String string2) {
        return string + DELIMITER + string2;
    }

    public void setGeneInfoC(Collection collection) {
        this.geneInfoC = collection;
    }

    public String getFastAFilepath() {
        return this.outputFilepath + EXTENSION_FASTA;
    }

    public String getAlnFilepath() {
        return this.outputFilepath + EXTENSTION_ALN;
    }

    public String getTreeFilepath() {
        OptionTbl optionTbl = OptionTbl.getInstance();
        if (optionTbl.getOptionValues().isTreeBootstrap()) {
            return this.outputFilepath + EXTENSTION_PHB;
        }
        return this.outputFilepath + EXTENSTION_PH;
    }

    public static String removeExtentionFromAlnFile(String string) {
        String string2 = string;
        int n = string.lastIndexOf(".");
        if (n != -1) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    public boolean isExistAlnFile() {
        return new File(this.getAlnFilepath()).isFile();
    }

    private class SequenceDownloader
    extends SimpleServerConnection {
        private StringBuffer sb = new StringBuffer();
        private int geneCount = 0;

        public SequenceDownloader(Collection collection) {
            this.setContextPath("/htbin/RECOG/getData");
            String string = MultipleAlignmentExecuter.this.createOrganismLocusTagKey(collection);
            this.setOptions("table=proteinseq" + string);
        }

        @Override
        public void parseOutputString(int n, String string) {
            if (StringTool.isNull(string)) {
                return;
            }
            Vector vector = StringTool.splitString(string, "\t");
            String string2 = (String)vector.get(0);
            String string3 = (String)vector.get(1);
            String string4 = (String)vector.get(2);
            this.sb.append(">" + MultipleAlignmentExecuter.this.createOrganismLocusTag(string2, string3));
            this.sb.append(FileUtil.LINE_SEPARETOR);
            this.sb.append(StringTool.breakLine(string4, 80));
            ++this.geneCount;
        }

        public String getSequence() {
            return this.sb.toString();
        }

        public int getGeneCount() {
            return this.geneCount;
        }
    }
}

