/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.multiplealign;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.AminoCode;
import cgdp.recog.data.AminoCodeTbl;
import cgdp.recog.menu.ColorTool2;
import cgdp.recog.multiplealign.ClustalTreeTool2;
import cgdp.recog.multiplealign.DnaTool;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.option.OptionValues;
import cgdp.recog.process.CommandImpl;
import cgdp.recog.util.ApplicationFrame;
import cgdp.recog.util.ColorUtil;
import cgdp.recog.util.StringTool;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class MultipleAlignmentFrame
extends ApplicationFrame
implements ActionListener {
    private MediatorImpl mediator;
    private OptionTbl optionTbl;
    private AminoCodeTbl aminoCodeTbl;
    private Font m_font;
    private int m_width;
    private int m_height;
    private String alnFile;
    private JTextPane m_textPane;
    private DefaultStyledDocument m_doc;
    private List m_posList;

    public MultipleAlignmentFrame(JFrame jFrame, MediatorImpl mediatorImpl) {
        this.mediator = mediatorImpl;
        this.mediator.register(this);
        this.clear();
        this.setTitle("Multiple Alignment");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MultipleAlignmentFrame.this.mediator.closeMultipleAlignmentFrame();
            }
        });
        this.createToolBar();
        this.createComponent();
        this.pack();
        OptionValues optionValues = this.optionTbl.getOptionValues();
        if (optionValues.getMultiFrameW() != 0 && optionValues.getMultiFrameH() != 0) {
            this.setBounds(optionValues.getMultiFrameX(), optionValues.getMultiFrameY(), optionValues.getMultiFrameW(), optionValues.getMultiFrameH());
        } else {
            this.setLocationRelativeTo(null);
        }
    }

    private void clear() {
        this.optionTbl = OptionTbl.getInstance();
        this.aminoCodeTbl = AminoCodeTbl.getInstance();
        this.m_font = new Font("Monospaced", 0, 12);
        FontMetrics fontMetrics = this.getFontMetrics(this.m_font);
        this.m_width = fontMetrics.stringWidth("A") * 100;
        this.m_height = (int)((double)this.getToolkit().getScreenSize().height * 0.6);
        this.alnFile = "";
        this.m_posList = new ArrayList();
    }

    private void createToolBar() {
        JToolBar jToolBar = new JToolBar();
        this.getContentPane().add((Component)jToolBar, "North");
        jToolBar.add(new ColorTool2(this, this.mediator));
        jToolBar.addSeparator();
        jToolBar.add(new ClustalTreeTool2(this, this.mediator));
    }

    private void createComponent() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "Center");
        StyleContext styleContext = new StyleContext();
        this.m_doc = new DefaultStyledDocument(styleContext);
        this.m_textPane = new JTextPane(){

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return false;
            }
        };
        this.m_textPane.setFont(this.m_font);
        this.m_textPane.setEditable(false);
        this.m_textPane.setDocument(this.m_doc);
        JScrollPane jScrollPane = new JScrollPane(this.m_textPane);
        jScrollPane.getViewport().setBackground(Color.white);
        jScrollPane.setPreferredSize(new Dimension(this.m_width, this.m_height));
        jPanel.add((Component)jScrollPane, "Center");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFiles(String string) throws Exception {
        this.alnFile = string;
        this.m_posList.clear();
        FileInputStream fileInputStream = null;
        BufferedReader bufferedReader = null;
        try {
            fileInputStream = new FileInputStream(this.alnFile);
            bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            boolean bl = false;
            int n2 = -1;
            String string2 = bufferedReader.readLine();
            stringBuffer.append(string2 + "\n");
            n = string2.length() + 1;
            while ((string2 = bufferedReader.readLine()) != null) {
                Object object;
                if (!bl && StringTool.isNull(string2)) {
                    stringBuffer.append("\n");
                    ++n;
                    continue;
                }
                if (n2 == -1) {
                    object = new StringTokenizer(string2, " ");
                    ((StringTokenizer)object).nextToken();
                    n2 = string2.indexOf(((StringTokenizer)object).nextToken());
                }
                if (StringTool.isNull(string2) || string2.length() < n2) {
                    stringBuffer.append("\n");
                    ++n;
                } else {
                    stringBuffer.append(string2 + "\n");
                    object = string2.substring(n2);
                    int n3 = n + n2;
                    for (int i = 0; i < ((String)object).length(); ++i) {
                        if (!DnaTool.isAmino(((String)object).charAt(i))) continue;
                        this.m_posList.add(new Integer(n3 + i));
                    }
                    n += string2.length() + 1;
                }
                bl = true;
            }
            this.m_textPane.setText(stringBuffer.toString());
            this.m_textPane.setCaretPosition(0);
            this.setAminoCodeColor();
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
    }

    public void setAminoCodeColor() {
        String string = this.m_textPane.getText();
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        try {
            this.m_doc.replace(0, string.length(), string, simpleAttributeSet);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        Iterator iterator = this.m_posList.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            AminoCode aminoCode = (AminoCode)this.aminoCodeTbl.get(String.valueOf(string.charAt(n)));
            Color color = aminoCode != null ? ColorUtil.str2Color(aminoCode.getColor()) : Color.black;
            SimpleAttributeSet simpleAttributeSet2 = new SimpleAttributeSet();
            StyleConstants.setForeground(simpleAttributeSet2, color);
            this.m_doc.setCharacterAttributes(n, 1, simpleAttributeSet2, false);
        }
    }

    public String getAlnFile() {
        return this.alnFile;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ((CommandImpl)actionEvent.getSource()).execute();
    }
}

