/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.option;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.funccat.FuncCatTable;
import cgdp.recog.funccat.FuncCatTbl;
import cgdp.recog.server.AccessServer;
import cgdp.recog.server.ServerAccessCheckTask;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.TabPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;

class ColorSettingPanel
extends TabPanel {
    private MediatorImpl mediator;
    private FuncCatTable funcCatTable;

    ColorSettingPanel(Component component, MediatorImpl mediatorImpl) {
        super(component);
        this.mediator = mediatorImpl;
        this.init();
    }

    private void init() {
        this.funcCatTable = new FuncCatTable(this.mediator);
        this.funcCatTable.setTableHeight(280);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.funcCatTable, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(10, 10, 5, 10), 0, 0));
    }

    private String getFunctionCategoryType() {
        return this.funcCatTable.getSelectedFunctionCategoryType();
    }

    private List getFunctionCategoryList() {
        return this.funcCatTable.getFunctionCategoryList();
    }

    @Override
    protected void changeDefault() {
        block4: {
            if (!AccessServer.getInstance().isEnableAccess()) {
                boolean bl;
                while (bl = AccessServer.showAccessErrorMessageRetry(this.parent)) {
                    ServerAccessCheckTask.getInstance().checkAccessServer(AccessServer.getInstance().getServerUrl());
                    if (!AccessServer.getInstance().isEnableAccess()) continue;
                    break block4;
                }
                return;
            }
        }
        try {
            FuncCatTbl funcCatTbl = FuncCatTbl.getInstance();
            funcCatTbl.downloadDefualtFunctionCategory(this.getFunctionCategoryType());
            this.funcCatTable.restoreFuncCatColor();
        }
        catch (Exception exception) {
            MessageManager.showErrorMessage((Component)this, "Fail to download function category file.");
        }
    }

    @Override
    public boolean check() {
        return true;
    }

    @Override
    protected void updateParameters() {
        this.mediator.applyFunctionCategoryColor(this.getFunctionCategoryType(), this.getFunctionCategoryList());
    }
}

