/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.organism;

import cgdp.recog.organism.Organism;
import cgdp.recog.util.MapUtil;
import cgdp.recog.util.StringTool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class SplitOrganism
extends Organism {
    public static final String DELIMITER_NO = "-";
    private Organism parentOrganism;
    private int splitNo;
    private boolean other = false;

    public SplitOrganism(Organism organism, int n) {
        this.setType(3);
        this.parentOrganism = organism;
        this.splitNo = n;
        this.updateValue(organism, n);
    }

    private void updateValue(Organism organism, int n) {
        this.setAbbrev(organism.getAbbrev() + DELIMITER_NO + n);
        if (!MapUtil.isNull(organism.getChromosomeShapeMap())) {
            this.setChromosomeShapeMap(new HashMap(organism.getChromosomeShapeMap()));
        }
        this.setGroupType(organism.getGroupType());
        this.setName(organism.getName());
        this.setOrganismCode(organism.getOrganismCode() + DELIMITER_NO + n);
        this.setStrain(organism.getStrain());
    }

    public Organism getParentOrganism() {
        return this.parentOrganism;
    }

    public void setParentOrganism(Organism organism) {
        this.parentOrganism = organism;
    }

    @Override
    public List getSystemOrganismCodeList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getParentOrganism().getOrganismCode());
        return arrayList;
    }

    @Override
    public String getNameForTaxonomy() {
        return super.getNameForTaxonomy() + DELIMITER_NO + this.splitNo;
    }

    @Override
    public String getDisplayOrganismName() {
        return super.getDisplayOrganismName() + DELIMITER_NO + this.splitNo;
    }

    public void setOther(boolean bl) {
        this.other = bl;
    }

    public boolean isOther() {
        return this.other;
    }

    public boolean equalsParentOrganismCode(String string) {
        return this.getParentOrganism().equalsOrganismCode(string);
    }

    int getSplitNo() {
        return this.splitNo;
    }

    String getOrganismCodePrefix() {
        Vector vector = StringTool.splitString(this.getOrganismCode(), DELIMITER_NO);
        return (String)vector.get(0);
    }
}

