/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.pattern;

import cgdp.recog.pattern.Pattern;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FileImporter;
import cgdp.recog.util.StringTool;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class PatternImporter
extends FileImporter {
    private static final ApplicationLogger logger = new ApplicationLogger(PatternImporter.class);
    private static final String TITLE_PATTERN = "Pattern";
    private static final String PREFIX_NAME = "#NAME";
    private static final String DELIMITER_PARAM = "\t";
    private static final String DELIMITER_SP = ":";
    private static final String DELIMITER_PATTERN = "//";
    private List patternList = new ArrayList();
    private String filepath;
    private Pattern pattern;

    public PatternImporter(String string) {
        this.filepath = string;
        this.setExistHeader(false);
    }

    @Override
    protected String getFilepath() {
        return this.filepath;
    }

    @Override
    protected void parseDataLine(int n, String string) {
        if (StringTool.isNull(string)) {
            return;
        }
        if (string.equals(TITLE_PATTERN)) {
            this.pattern = new Pattern();
        } else if (string.startsWith(PREFIX_NAME)) {
            String string2 = this.getValue(PREFIX_NAME, string);
            this.pattern.setName(string2);
        } else if (string.equals(DELIMITER_PATTERN)) {
            this.patternList.add(this.pattern);
        } else {
            Vector vector = StringTool.splitString(string, DELIMITER_SP);
            String string3 = (String)vector.get(0);
            String string4 = (String)vector.get(1);
            boolean bl = new Boolean((String)vector.get(2));
            try {
                double d = Double.parseDouble(string4);
                this.pattern.addOrganism(string3, d, bl);
            }
            catch (NumberFormatException numberFormatException) {
                logger.warn("Fail to parse value. value = " + string4, numberFormatException);
            }
        }
    }

    private String getValue(String string, String string2) {
        return string2.substring(string.length() + 1);
    }

    @Override
    protected void parseHeaderLine(String string) {
    }

    public List getPatternList() {
        return this.patternList;
    }
}

