/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.ppm;

import cgdp.recog.coregenome.OrthologGroup;
import cgdp.recog.data.Cluster;
import cgdp.recog.funccat.FuncCatTbl;
import cgdp.recog.funccat.FunctionCategoryType;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.cluster.ClusterInfoFacade;
import cgdp.recog.info.cluster.ClusterInfoTitle;
import cgdp.recog.ppm.PPMLabelType;
import cgdp.recog.util.MathUtil;
import java.util.HashMap;
import java.util.Map;

public class PPMLabelCondition {
    static final int LOAD_CLUSTER = 1;
    static final int LOAD_INFO = 2;
    static final String NAME_ClUSTER_ID = "Cluster ID";
    static final String NAME_FUNC_NO = "Function Category No";
    static final String NAME_ClUSTER_GENE_NAME = "Gene name";
    private static final String NAME_REF_GENE_NAME = "Gene name of the reference genome";
    private static final String NAME_REF_LOCUS_TAG = "Locus Tag of the reference genome";
    static final String NAME_CLUSTER_SCORE = "Cluster score";
    static final String NAME_CLUSTER_DIST = "Cluster dist";
    static final String NAME_CLUSTER_GENE_COUNT = "Gene count";
    static final String NAME_PATTERN_COEF = "Phylogenetic Pattern Coefficient";
    private int ppmLabelType = 2;
    private String name = "";
    private int loadCluster = 1;
    private int loadSubCluster = 1;
    private int loadHomCluster = 1;
    private ClusterInfoTitle subClusterInfoTitle;
    private ClusterInfoTitle clusterInfoTitle;
    private ClusterInfoTitle homClusterInfoTitle;
    private Map clusterInfoMap = new HashMap();

    public int getPpmLabelType() {
        return this.ppmLabelType;
    }

    public void setPpmLabelType(int n) {
        this.ppmLabelType = n;
    }

    public String getName() {
        return this.name;
    }

    void setName(String string) {
        this.name = string;
    }

    public void setLoadCluster(int n) {
        this.loadCluster = n;
    }

    public int getLoadCluster() {
        return this.loadCluster;
    }

    public int getLoadHomCluster() {
        return this.loadHomCluster;
    }

    public void setLoadHomCluster(int n) {
        this.loadHomCluster = n;
    }

    public int getLoadSubCluster() {
        return this.loadSubCluster;
    }

    public void setLoadSubCluster(int n) {
        this.loadSubCluster = n;
    }

    private static boolean isLoadCluster(int n) {
        return n == 1;
    }

    private static boolean isLoadInfo(int n) {
        return n == 2;
    }

    public ClusterInfoTitle getClusterInfoTitle() {
        return this.clusterInfoTitle;
    }

    void setClusterInfoTitle(ClusterInfoTitle clusterInfoTitle) {
        this.clusterInfoTitle = clusterInfoTitle;
    }

    public ClusterInfoTitle getSubClusterInfoTitle() {
        return this.subClusterInfoTitle;
    }

    void setSubClusterInfoTitle(ClusterInfoTitle clusterInfoTitle) {
        this.subClusterInfoTitle = clusterInfoTitle;
    }

    public ClusterInfoTitle getHomClusterInfoTitle() {
        return this.homClusterInfoTitle;
    }

    void setHomClusterInfoTitle(ClusterInfoTitle clusterInfoTitle) {
        this.homClusterInfoTitle = clusterInfoTitle;
    }

    public String getSubFuncionCategory(Cluster cluster, String string) {
        ClusterInfoTitle clusterInfoTitle = null;
        String string2 = FuncCatTbl.getInstance().getFunctionCategoryType();
        if (FunctionCategoryType.isMBGD(string2)) {
            clusterInfoTitle = ClusterInfoFacade.getInfoTitle("SCFuncMbgd");
        } else if (FunctionCategoryType.isCOG(string2)) {
            clusterInfoTitle = ClusterInfoFacade.getInfoTitle("SCFuncCog");
        } else if (FunctionCategoryType.isKEGG(string2)) {
            clusterInfoTitle = ClusterInfoFacade.getInfoTitle("SCFuncKegg");
        } else if (FunctionCategoryType.isTIGR(string2)) {
            clusterInfoTitle = ClusterInfoFacade.getInfoTitle("SCFuncTigr");
        }
        clusterInfoTitle.setInfoType(4);
        String string3 = this.getClusterLabelCore(cluster, clusterInfoTitle, string, this.getLoadCluster(), false, false);
        if (string3 != null && string3 instanceof String) {
            return string3;
        }
        return "";
    }

    public String getClusterLabel(Cluster cluster, String string) {
        if (this.getClusterInfoTitle() == null) {
            return "";
        }
        boolean bl = this.getClusterInfoTitle().isNumeric();
        boolean bl2 = false;
        if (this.getClusterInfoTitle().equalsKey("clusterid") || this.getClusterInfoTitle().equalsKey("CGeneCount")) {
            bl = false;
            bl2 = true;
        }
        return this.getClusterLabelCore(cluster, this.getClusterInfoTitle(), string, this.getLoadCluster(), bl, bl2);
    }

    public String getSubClusterLabel(Cluster cluster, String string) {
        if (this.getSubClusterInfoTitle() == null) {
            return "";
        }
        boolean bl = this.getSubClusterInfoTitle().isNumeric();
        boolean bl2 = false;
        if (this.getSubClusterInfoTitle().equalsKey("subclusterid") || this.getSubClusterInfoTitle().equalsKey("SCGeneCount") || this.getSubClusterInfoTitle().equalsKey("clusterid") || this.getSubClusterInfoTitle().equalsKey("CGeneCount")) {
            bl = false;
            bl2 = true;
        }
        return this.getClusterLabelCore(cluster, this.getSubClusterInfoTitle(), string, this.getLoadSubCluster(), bl, bl2);
    }

    public String getHomClusterLabel(Cluster cluster, String string) {
        if (this.getHomClusterInfoTitle() == null) {
            return "";
        }
        boolean bl = this.getHomClusterInfoTitle().isNumeric();
        boolean bl2 = false;
        if (this.getHomClusterInfoTitle().equalsKey("homclusterid")) {
            bl = false;
            bl2 = true;
        }
        return this.getClusterLabelCore(cluster, this.getHomClusterInfoTitle(), string, this.getLoadHomCluster(), bl, bl2);
    }

    private String getClusterLabelCore(Cluster cluster, ClusterInfoTitle clusterInfoTitle, String string, int n, boolean bl, boolean bl2) {
        String string2 = "";
        if (clusterInfoTitle == null) {
            return string2;
        }
        Object object = null;
        if (PPMLabelCondition.isLoadCluster(n)) {
            object = cluster.getValue(clusterInfoTitle);
        } else if (PPMLabelCondition.isLoadInfo(n)) {
            object = ClusterInfoFacade.getValue(cluster, clusterInfoTitle, string);
        }
        if (object != null) {
            if (bl && clusterInfoTitle.isNumeric()) {
                object = PPMLabelCondition.getNumericLabel((Number)object);
            } else if (bl2 && clusterInfoTitle.isNumeric()) {
                object = new Integer(((Number)object).intValue());
            }
            string2 = String.valueOf(object);
        }
        return string2;
    }

    private static String getNumericLabel(Number number) {
        String string = "";
        if (number != null) {
            double d = number.doubleValue();
            d = d < 1.0 ? MathUtil.roundDecimal(d, 4) : (d < 10.0 ? MathUtil.roundDecimal(d, 3) : (d < 100.0 ? MathUtil.roundDecimal(d, 2) : MathUtil.roundDecimal(d, 1)));
            string = String.valueOf(d);
        }
        return string;
    }

    public static String getOrthologGroupLabel(OrthologGroup orthologGroup, int n) {
        String string = "";
        if (PPMLabelType.isClusterId(n)) {
            string = orthologGroup.getConbineClusterId();
        } else if (PPMLabelType.isClusterGeneName(n)) {
            string = orthologGroup.getClusterGeneName();
        } else if (PPMLabelType.isRefGeneName(n)) {
            string = orthologGroup.getDisplayGeneName();
        } else if (!PPMLabelType.isRefLocusTag(n)) {
            string = orthologGroup.getDisplayGeneName();
        }
        return string;
    }

    public boolean equalsType(int n) {
        return this.getPpmLabelType() == n;
    }

    public boolean containsInfoTitle(AbstractInfoTitle abstractInfoTitle) {
        if (this.getHomClusterInfoTitle() != null && this.getHomClusterInfoTitle().equals(abstractInfoTitle)) {
            return true;
        }
        if (this.getClusterInfoTitle() != null && this.getClusterInfoTitle().equals(abstractInfoTitle)) {
            return true;
        }
        return this.getSubClusterInfoTitle() == null || !this.getSubClusterInfoTitle().equals(abstractInfoTitle);
    }
}

