/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.project;

import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;

class ProjectTableModel
extends AbstractTableModel {
    private static String[] COLUMN_NAMES = new String[]{"Name", "URL", "Select"};
    private List projectList = new ArrayList();

    ProjectTableModel(List list) {
        this.projectList = list;
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMN_NAMES[n];
    }

    @Override
    public int getRowCount() {
        return this.projectList.size();
    }

    public Class getColumnClass(int n) {
        if (n == 2) {
            return Boolean.class;
        }
        return String.class;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Project project = (Project)this.projectList.get(n);
        if (n2 == 0) {
            return project.getProjectName();
        }
        if (n2 == 1) {
            return project.getServerUrl();
        }
        if (n2 == 2) {
            return new Boolean(project.isSelect());
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 2;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        Project project = (Project)this.projectList.get(n);
        if (n2 == 2) {
            this.clearSelect();
            boolean bl = (Boolean)object;
            project.setSelect(bl);
            this.fireTableRowsUpdated(0, this.getRowCount());
        }
    }

    private void clearSelect() {
        for (Project project : this.projectList) {
            project.setSelect(false);
        }
    }

    List getProjectList() {
        return this.projectList;
    }

    void addProject(Project project) {
        this.projectList.add(project);
        Collections.sort(this.projectList, new ProjectComparator());
        this.fireTableRowsInserted(0, this.getRowCount() - 1);
    }

    void removeProject(Project project) {
        this.projectList.remove(project);
        this.fireTableDataChanged();
    }

    Project getProject(int n) {
        if (n < 0 || n >= this.getRowCount()) {
            return null;
        }
        return (Project)this.projectList.get(n);
    }
}

