/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.property;

import cgdp.recog.data.ClusterTbl;
import cgdp.recog.domclust.DomClustQuery;
import cgdp.recog.filter.FilterFacade;
import cgdp.recog.hcluster.HClustCondition;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.property.PropertyTableCellRenderer;
import cgdp.recog.sort.SortCondition;
import cgdp.recog.system.property.ApplicationPropertyConf;
import cgdp.recog.util.StringTool;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PropertyMapCreater {
    public static final String TITLE_SERVER = "Server";
    public static final String TITLE_COMMENT = "Comment";
    private ClusterTbl clusterTbl;

    public PropertyMapCreater(ClusterTbl clusterTbl) {
        this.clusterTbl = clusterTbl;
    }

    public static Set createEditableComboBoxProperryTitleSet() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(TITLE_SERVER);
        return hashSet;
    }

    public static Set createTextAreaPropertyTitleSet() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(TITLE_COMMENT);
        return hashSet;
    }

    public Map createPropertyMap() {
        SortCondition sortCondition;
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        if (this.clusterTbl == null) {
            return linkedHashMap;
        }
        ApplicationPropertyConf applicationPropertyConf = this.clusterTbl.getApplicationPropertyConf();
        linkedHashMap.put("Project", ProjectAccesser.getSelectedProject().getProjectName());
        linkedHashMap.put("File name", this.clusterTbl.getDisplayDomClustName());
        linkedHashMap.put("Cluster Tab ID", this.clusterTbl.getClusterId());
        linkedHashMap.put("Number of Select Genomes", new Integer(this.clusterTbl.getViewOrganismCount()));
        linkedHashMap.put("Ingroup organisms", this.getOrganismCodeString(this.clusterTbl.getIngroupSpList()));
        linkedHashMap.put("Outgroup organisms", this.getOrganismCodeString(this.clusterTbl.getOutgroupSpList()));
        linkedHashMap.put("Number of Phylogenetic Patterns", new Integer(this.clusterTbl.getViewOrderList().size()));
        linkedHashMap.put("Number of Clusters", new Integer(this.clusterTbl.getViewClusterList().size()));
        linkedHashMap.put(TITLE_SERVER, this.clusterTbl.getServerUrl());
        if (applicationPropertyConf != null) {
            linkedHashMap.put(TITLE_COMMENT, StringTool.displayNewLine2NewLine(applicationPropertyConf.getComment()));
            linkedHashMap.put("Created by", applicationPropertyConf.getCreateUser());
            linkedHashMap.put("Created on", applicationPropertyConf.getCreateDate());
            linkedHashMap.put("Updated by", applicationPropertyConf.getUpdateUser());
            linkedHashMap.put("Updated on", applicationPropertyConf.getUpdateDate());
        }
        if ((sortCondition = this.clusterTbl.getSortCondition()) != null) {
            linkedHashMap.put(PropertyTableCellRenderer.addTitlePrefix("Sort"), "");
            linkedHashMap.putAll(sortCondition.createDisplayOptionMap());
        }
        linkedHashMap.putAll(FilterFacade.getInstance().createPropertyMap());
        linkedHashMap.put(PropertyTableCellRenderer.addTitlePrefix("DomClust Options"), "");
        linkedHashMap.putAll(DomClustQuery.createDisplayOptionMap(this.clusterTbl.getDomClustOption()));
        if (this.clusterTbl.isExistHClustResult()) {
            HClustCondition hClustCondition = this.clusterTbl.getHClustCondition();
            linkedHashMap.put(PropertyTableCellRenderer.addTitlePrefix("Phylopat Cluster"), "");
            linkedHashMap.putAll(hClustCondition.createDisplayOptionMap());
        }
        return linkedHashMap;
    }

    private String getOrganismCodeString(List list) {
        return StringTool.conbineStrList(list);
    }
}

