/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.propvect;

import cgdp.recog.calc.AbstractCalcCondition;
import cgdp.recog.data.Cluster;
import cgdp.recog.pattern.Pattern;
import cgdp.recog.pattern.PatternFactory;
import cgdp.recog.propvect.CalcDistance;
import cgdp.recog.propvect.CompressedPropVectArray;
import cgdp.recog.propvect.NumVect;
import cgdp.recog.propvect.NumVectArray;
import cgdp.recog.propvect.PhyloPat;
import cgdp.recog.propvect.PhyloPatArray;
import cgdp.recog.propvect.PropVect;
import cgdp.recog.propvect.PropVectArray;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PropVectFacade {
    private PropVectFacade() {
    }

    public static PropVectArray createPropVectArray(List list, List list2) {
        PhyloPatArray phyloPatArray = new PhyloPatArray();
        phyloPatArray.setColnum(list.size());
        for (int i = 0; i < list2.size(); ++i) {
            Cluster cluster = (Cluster)list2.get(i);
            Map map = cluster.getPatternMap();
            PropVect propVect = ((PropVectArray)phyloPatArray).createNewElement(String.valueOf(i));
            for (int j = 0; j < list.size(); ++j) {
                String string = (String)list.get(j);
                int n = map.containsKey(string) ? 1 : 0;
                propVect.set(j, String.valueOf(n));
            }
            phyloPatArray.add(propVect);
        }
        return phyloPatArray;
    }

    public static NumVectArray createNumVectArray(AbstractCalcCondition abstractCalcCondition, List list, List list2) {
        NumVectArray numVectArray = new NumVectArray();
        numVectArray.setColnum(list.size());
        for (int i = 0; i < list2.size(); ++i) {
            Cluster cluster = (Cluster)list2.get(i);
            NumVect numVect = (NumVect)numVectArray.createNewElement(String.valueOf(i));
            Pattern pattern = PatternFactory.createNumericPattern(list, cluster, abstractCalcCondition);
            for (int j = 0; j < list.size(); ++j) {
                String string = (String)list.get(j);
                numVect.set(j, pattern.getValue(string));
            }
            numVectArray.add(numVect);
        }
        return numVectArray;
    }

    public static String getPatternFromPropVect(PropVect propVect) {
        if (propVect instanceof PhyloPat) {
            int[] nArray = ((PhyloPat)propVect).vect;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < nArray.length; ++i) {
                stringBuffer.append(nArray[i]);
            }
            return stringBuffer.toString();
        }
        if (propVect instanceof NumVect) {
            float[] fArray = ((NumVect)propVect).vect;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < fArray.length; ++i) {
                stringBuffer.append(fArray[i]);
            }
            return stringBuffer.toString();
        }
        if (propVect instanceof PropVect) {
            Object[] objectArray = propVect.vect;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuffer.append(objectArray[i]);
            }
            return stringBuffer.toString();
        }
        return "";
    }

    public static Map createEquivMap(CompressedPropVectArray compressedPropVectArray) {
        HashMap<String, LinkedList> hashMap = new HashMap<String, LinkedList>();
        for (int i = 0; i < compressedPropVectArray.equivList.size(); ++i) {
            LinkedList linkedList = (LinkedList)compressedPropVectArray.equivList.get(i);
            PropVect propVect = (PropVect)linkedList.get(0);
            hashMap.put(propVect.getName(), linkedList);
        }
        return hashMap;
    }

    public static Set getPropVectNameSet(CompressedPropVectArray compressedPropVectArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < compressedPropVectArray.equivList.size(); ++i) {
            LinkedList linkedList = (LinkedList)compressedPropVectArray.equivList.get(i);
            for (PropVect propVect : linkedList) {
                hashSet.add(propVect.getName());
            }
        }
        return hashSet;
    }

    public static double calcDistance(int n, Pattern pattern, Pattern pattern2, List list) {
        PhyloPat phyloPat = PropVectFacade.createPhyloPat(pattern, list);
        PhyloPat phyloPat2 = PropVectFacade.createPhyloPat(pattern2, list);
        double d = 1.0;
        PhyloPatArray phyloPatArray = new PhyloPatArray();
        phyloPatArray.setColnum(list.size());
        CalcDistance calcDistance = phyloPatArray.createCalcDistance(n, d);
        double d2 = calcDistance.calc(phyloPat, phyloPat2);
        if (n == 0) {
            d2 /= 2.0;
        }
        return d2;
    }

    private static PhyloPat createPhyloPat(Pattern pattern, List list) {
        PhyloPat phyloPat = new PhyloPat(list.size());
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            if (pattern.isIgnore(string)) continue;
            double d = pattern.getValue(string);
            int n = d == 0.0 ? 0 : 1;
            phyloPat.set(i, n);
        }
        return phyloPat;
    }

    public static double calcNumVectDistance(int n, Pattern pattern, Pattern pattern2, List list) {
        NumVect numVect = PropVectFacade.createNumVect(pattern, list);
        NumVect numVect2 = PropVectFacade.createNumVect(pattern2, list);
        double d = 1.0;
        NumVectArray numVectArray = new NumVectArray();
        numVectArray.setColnum(list.size());
        CalcDistance calcDistance = numVectArray.createCalcDistance(n, d);
        double d2 = calcDistance.calc(numVect, numVect2);
        if (n == 0) {
            d2 /= 2.0;
        }
        return d2;
    }

    private static NumVect createNumVect(Pattern pattern, List list) {
        NumVect numVect = new NumVect(list.size());
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            if (pattern.isIgnore(string)) continue;
            double d = pattern.getValue(string);
            numVect.set(i, d);
        }
        return numVect;
    }
}

