/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set.cluster;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.process.CommandImpl;
import cgdp.recog.set.cluster.ClusterSet;
import cgdp.recog.set.cluster.ClusterSetFacade;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JMenuItem;

class ClusterDeleteItem
extends JMenuItem
implements CommandImpl {
    private static final ApplicationLogger logger = new ApplicationLogger(ClusterDeleteItem.class);
    private Component parent;
    private MediatorImpl mediator;
    private ClusterSet clusterSet;
    private Collection removeClusterC;

    ClusterDeleteItem(ActionListener actionListener, Component component, MediatorImpl mediatorImpl, ClusterSet clusterSet, Collection collection) {
        super("Delete cluster");
        this.parent = component;
        this.mediator = mediatorImpl;
        this.clusterSet = clusterSet;
        this.removeClusterC = collection;
        this.addActionListener(actionListener);
    }

    @Override
    public void execute() {
        try {
            if (MessageManager.showConfirmMessage(this.parent, "Delete clusters?")) {
                ClusterSetFacade.getInstance().deleteElementListFromSet(this.mediator, this.clusterSet, this.removeClusterC);
            }
        }
        catch (Exception exception) {
            String string = "Fail to delete cluster set.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage(this.parent, string);
        }
    }
}

