/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set.cluster;

import cgdp.recog.data.ClusterTbl;
import cgdp.recog.filefilter.FileFilterFactory;
import cgdp.recog.info.gene.GeneInfoFilterMultiOptionPanel;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.option.OptionValues;
import cgdp.recog.set.SetComboBox;
import cgdp.recog.set.cluster.ClusterSet;
import cgdp.recog.set.cluster.ClusterSetFacade;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.FileSelectPanel;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.OverwriteAddOptionPanel;
import cgdp.recog.util.StringTool;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.filechooser.FileFilter;

public class ClusterSetImportDialog
extends AbstractApplyDialog {
    private static final String TITLE = "Register cluster set";
    private static final FileFilter FILE_FITER_CLUSTER_SET = FileFilterFactory.createClusterSetFileWithDirFilter();
    private SetComboBox setComboBox;
    private boolean displayFileField = true;
    private FileSelectPanel fileSelectPanel;
    private JLabel fileTitleLabel;
    private OverwriteAddOptionPanel overwriteAddOptionPanel;
    private GeneInfoFilterMultiOptionPanel matchOptionPanel;
    private ClusterTbl clusterTbl;
    private String location;

    private ClusterSetImportDialog(Frame frame) {
        super(frame);
        this.createComponents();
    }

    private ClusterSetImportDialog(Dialog dialog) {
        super(dialog);
        this.createComponents();
    }

    public static ClusterSetImportDialog getInstanse(Component component) {
        if (component instanceof Frame) {
            return new ClusterSetImportDialog((Frame)component);
        }
        if (component instanceof Dialog) {
            return new ClusterSetImportDialog((Dialog)component);
        }
        return null;
    }

    private void createComponents() {
        this.setTitle(TITLE);
        this.setModal(true);
        this.setResizable(true);
        JLabel jLabel = new JLabel("Name");
        this.setComboBox = new SetComboBox();
        this.setComboBox.setEditable(true);
        this.fileSelectPanel = new FileSelectPanel(FILE_FITER_CLUSTER_SET);
        this.fileSelectPanel.setAcceptAllFileFilterUsed(false);
        OptionValues optionValues = OptionTbl.getInstance().getOptionValues();
        String string = optionValues.getUserImportDir();
        this.fileSelectPanel.setDefaultPath(string + "/*");
        this.fileTitleLabel = new JLabel("File");
        this.overwriteAddOptionPanel = new OverwriteAddOptionPanel();
        this.matchOptionPanel = new GeneInfoFilterMultiOptionPanel(false);
        this.matchOptionPanel.setBorder(BorderFactory.createTitledBorder("Match condition"));
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 15, 0, 10), 0, 0));
        this.getContentPane().add((Component)this.setComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(15, 0, 0, 15), 0, 0));
        this.getContentPane().add((Component)this.fileTitleLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 15, 0, 10), 0, 0));
        this.getContentPane().add((Component)this.fileSelectPanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(10, 0, 0, 15), 0, 0));
        this.getContentPane().add((Component)this.overwriteAddOptionPanel, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 15, 0, 15), 0, 0));
        this.getContentPane().add((Component)this.matchOptionPanel, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 2, new Insets(10, 15, 0, 15), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 0, new Insets(10, 15, 15, 15), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public void updateValue(String string, ClusterTbl clusterTbl, boolean bl) {
        this.updateValue(string, clusterTbl, bl, false);
    }

    public void updateValue(String string, ClusterTbl clusterTbl, boolean bl, boolean bl2) {
        this.displayFileField = bl;
        this.fileTitleLabel.setVisible(bl);
        this.fileSelectPanel.setVisible(bl);
        this.matchOptionPanel.setVisible(bl2);
        this.location = string;
        this.clusterTbl = clusterTbl;
        this.updateSetNameComboBox();
        this.overwriteAddOptionPanel.updateValue(2);
        this.pack();
    }

    private void updateSetNameComboBox() {
        List list = ClusterSetFacade.getInstance().getClusterSetListCurrentDomClust(this.clusterTbl.getClusterId());
        this.setComboBox.updateValue(list);
    }

    private boolean isOverwrite() {
        return this.overwriteAddOptionPanel.isOverwrite();
    }

    public ClusterSet createClusterSet() {
        ClusterSet clusterSet = new ClusterSet();
        ClusterSet clusterSet2 = (ClusterSet)this.setComboBox.getSelectedElementSet();
        if (clusterSet2 != null) {
            clusterSet.copy(clusterSet2);
            if (!this.isOverwrite()) {
                clusterSet.addAddList();
            }
        } else {
            clusterSet.setName(this.getSetName());
            clusterSet.setLocation(this.location);
            clusterSet.setDomClustId(this.clusterTbl.getClusterId());
            clusterSet.setDomClustFilename(this.clusterTbl.getDomClustName());
            clusterSet.setSetType(2);
            clusterSet.setNew();
        }
        return clusterSet;
    }

    private String getSetName() {
        return this.setComboBox.getSelectedSetName();
    }

    public String getFilepath() {
        return this.fileSelectPanel.getPath();
    }

    public int getMatchOption() {
        return this.matchOptionPanel.getMultiType();
    }

    @Override
    protected boolean check() {
        Object[] objectArray;
        Object[] objectArray2;
        Object object;
        if (StringTool.isNull(this.getSetName())) {
            MessageManager.showErrorMessage((Component)this, "Input name.");
            return false;
        }
        if (this.displayFileField) {
            object = this.getFilepath();
            if (StringTool.isNull((String)object)) {
                MessageManager.showErrorMessage((Component)this, "Input file.");
                return false;
            }
            if (!new File((String)object).isFile()) {
                MessageManager.showErrorMessage((Component)this, "Can't read file. " + (String)object);
                return false;
            }
        }
        return (object = this.getDuplicateClusterSet()) == null || !(this.isOverwrite() ? !MessageManager.showConfirmMessage((Component)this, objectArray2 = new String[]{"You have already made cluster set [" + this.getSetName() + "].", "Overwrite the cluster set [" + this.getSetName() + "]?"}) : !MessageManager.showConfirmMessage((Component)this, objectArray = new String[]{"You have already made cluster set [" + this.getSetName() + "].", "Add selected clusters to the cluster set [" + this.getSetName() + "]?"}));
    }

    private ClusterSet getDuplicateClusterSet() {
        ClusterSet clusterSet = this.createClusterSet();
        return (ClusterSet)ClusterSetFacade.getInstance().getSameElementSet(clusterSet);
    }

    @Override
    protected boolean apply() {
        return true;
    }
}

