/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set.gene;

import cgdp.recog.data.DataManager;
import cgdp.recog.set.gene.GeneSet;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FileImporter;
import cgdp.recog.util.StringTool;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

class GeneSetConfImporter
extends FileImporter {
    private static final ApplicationLogger logger = new ApplicationLogger(GeneSetConfImporter.class);
    private static final String DELIMITER = "\t";
    private List geneSetList = new ArrayList();
    private String filepath;

    GeneSetConfImporter() {
        this(DataManager.getGeneSetConfFilepath());
    }

    GeneSetConfImporter(String string) {
        this.filepath = string;
    }

    @Override
    protected String getFilepath() {
        return this.filepath;
    }

    @Override
    protected void parseDataLine(int n, String string) {
        GeneSet geneSet = this.parseGeneSet(string);
        this.geneSetList.add(geneSet);
    }

    private GeneSet parseGeneSet(String string) {
        Vector vector = StringTool.splitString(string, DELIMITER);
        GeneSet geneSet = new GeneSet();
        geneSet.setId(String.valueOf(vector.get(0)));
        geneSet.setName(String.valueOf(vector.get(1)));
        geneSet.setListFilename(String.valueOf(vector.get(2)));
        geneSet.setLocation(String.valueOf(vector.get(3)));
        int n = Integer.parseInt(String.valueOf(vector.get(4)));
        geneSet.setElementSize(n);
        return geneSet;
    }

    @Override
    protected void parseHeaderLine(String string) {
    }

    @Override
    protected void beforeProcess() {
        try {
            File file = new File(this.getFilepath());
            if (!file.isFile()) {
                file.createNewFile();
            }
        }
        catch (IOException iOException) {
            logger.warn("Fail to create gene set conf file.", iOException);
        }
    }

    public List getGeneSetList() {
        return this.geneSetList;
    }
}

