/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set.gene;

import cgdp.recog.filefilter.FileFilterFactory;
import cgdp.recog.info.LocationComboBox;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.option.OptionValues;
import cgdp.recog.set.SetComboBox;
import cgdp.recog.set.gene.GeneSet;
import cgdp.recog.set.gene.GeneSetFacade;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FileSelectPanel;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.OverwriteAddOptionPanel;
import cgdp.recog.util.StringTool;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.filechooser.FileFilter;

public class GeneSetImportDialog
extends AbstractApplyDialog
implements ItemListener {
    private static final ApplicationLogger logger = new ApplicationLogger(GeneSetImportDialog.class);
    private static final String TITLE = "Register gene set";
    private static final FileFilter FILE_FITER_GENE_SET = FileFilterFactory.createGeneSetFileWithDirFilter();
    private SetComboBox setComboBox;
    private boolean displayFileField = true;
    private FileSelectPanel fileSelectPanel;
    private JLabel fileTitleLabel;
    private LocationComboBox locationComboBox;
    private OverwriteAddOptionPanel overwriteAddOptionPanel;

    private GeneSetImportDialog(Frame frame) {
        super(frame);
        this.createComponents();
    }

    private GeneSetImportDialog(Dialog dialog) {
        super(dialog);
        this.createComponents();
    }

    public static GeneSetImportDialog getInstanse(Component component) {
        if (component instanceof Frame) {
            return new GeneSetImportDialog((Frame)component);
        }
        if (component instanceof Dialog) {
            return new GeneSetImportDialog((Dialog)component);
        }
        return null;
    }

    private void createComponents() {
        this.setTitle(TITLE);
        this.setModal(true);
        this.setResizable(true);
        JLabel jLabel = new JLabel("Name");
        this.setComboBox = new SetComboBox();
        this.setComboBox.setEditable(true);
        this.fileTitleLabel = new JLabel("File");
        this.fileSelectPanel = new FileSelectPanel(FILE_FITER_GENE_SET);
        this.fileSelectPanel.setAcceptAllFileFilterUsed(false);
        OptionValues optionValues = OptionTbl.getInstance().getOptionValues();
        String string = optionValues.getUserImportDir();
        this.fileSelectPanel.setDefaultPath(string + "/*");
        JLabel jLabel2 = new JLabel("Location");
        this.locationComboBox = new LocationComboBox();
        this.locationComboBox.addItemListener(this);
        this.overwriteAddOptionPanel = new OverwriteAddOptionPanel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 10), 0, 0));
        this.getContentPane().add((Component)this.setComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 0, 0, 10), 0, 0));
        this.getContentPane().add((Component)this.fileTitleLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 10), 0, 0));
        this.getContentPane().add((Component)this.fileSelectPanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 0, 5, 10), 0, 0));
        this.getContentPane().add((Component)jLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 10), 0, 0));
        this.getContentPane().add((Component)this.locationComboBox, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 5, 10), 0, 0));
        this.getContentPane().add((Component)this.overwriteAddOptionPanel, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 10), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 0, new Insets(5, 10, 10, 10), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public void updateValue(String string, boolean bl) {
        this.displayFileField = bl;
        this.fileTitleLabel.setVisible(bl);
        this.fileSelectPanel.setVisible(bl);
        this.locationComboBox.updateLocationConboBox();
        this.locationComboBox.setSelectedItem(string);
        this.updateSetNameComboBox();
        this.overwriteAddOptionPanel.updateValue(2);
    }

    private void updateSetNameComboBox() {
        String string = this.getLocationString();
        List list = GeneSetFacade.getInstance().getGeneSetListGlobalAndSameLocation(string);
        this.setComboBox.updateValue(list);
    }

    private String getSetName() {
        return this.setComboBox.getSelectedSetName();
    }

    public String getFilepath() {
        return this.fileSelectPanel.getPath();
    }

    private String getLocationString() {
        return this.locationComboBox.getLocationString();
    }

    private boolean isOverwrite() {
        return this.overwriteAddOptionPanel.isOverwrite();
    }

    public GeneSet createGeneSet() {
        GeneSet geneSet = new GeneSet();
        GeneSet geneSet2 = (GeneSet)this.setComboBox.getSelectedElementSet();
        if (geneSet2 != null) {
            geneSet.copy(geneSet2);
            if (!this.isOverwrite()) {
                geneSet.addAddList();
            }
        } else {
            geneSet.setName(this.getSetName());
            geneSet.setLocation(this.getLocationString());
            geneSet.setSetType(1);
            geneSet.setNew();
        }
        return geneSet;
    }

    private GeneSet getDuplicateGeneSet() {
        GeneSet geneSet = this.createGeneSet();
        return (GeneSet)GeneSetFacade.getInstance().getSameElementSet(geneSet);
    }

    @Override
    protected boolean check() {
        Object[] objectArray;
        Object[] objectArray2;
        Object object;
        if (StringTool.isNull(this.getSetName())) {
            MessageManager.showErrorMessage((Component)this, "Input name.");
            return false;
        }
        if (this.displayFileField) {
            object = this.getFilepath();
            if (StringTool.isNull((String)object)) {
                MessageManager.showErrorMessage((Component)this, "Input file.");
                return false;
            }
            if (!new File((String)object).isFile()) {
                MessageManager.showErrorMessage((Component)this, "Can't read file. " + (String)object);
                return false;
            }
        }
        return (object = this.getDuplicateGeneSet()) == null || !(this.isOverwrite() ? !MessageManager.showConfirmMessage((Component)this, objectArray2 = new String[]{"You have already made gene set [" + this.getSetName() + "].", "Overwrite the gene set [" + this.getSetName() + "]?"}) : !MessageManager.showConfirmMessage((Component)this, objectArray = new String[]{"You have already made gene set [" + this.getSetName() + "].", "Add selected genes to the gene set [" + this.getSetName() + "]?"}));
    }

    @Override
    protected boolean apply() {
        OptionValues optionValues = OptionTbl.getInstance().getOptionValues();
        optionValues.setUserImportDir(this.getFilepath());
        return true;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.locationComboBox) {
            this.updateSetNameComboBox();
        }
    }
}

