/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set.gene;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.info.LocationType;
import cgdp.recog.info.gene.GeneDownloadDialog;
import cgdp.recog.process.ProcessImpl;
import cgdp.recog.process.ProgressDialog;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.set.AbstractElementSet;
import cgdp.recog.set.AbstractElementSetFacade;
import cgdp.recog.set.SetDeleteAfterRunnable;
import cgdp.recog.set.SetDeleteRequestExecuter;
import cgdp.recog.set.SetTableCellRenderer;
import cgdp.recog.set.gene.GeneSet;
import cgdp.recog.set.gene.GeneSetDownloadExecuter;
import cgdp.recog.set.gene.GeneSetEditDialog;
import cgdp.recog.set.gene.GeneSetFacade;
import cgdp.recog.set.gene.GeneSetIOException;
import cgdp.recog.set.gene.GeneSetImportDialog;
import cgdp.recog.set.gene.GeneSetTableModel;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.AbstractControlTabPanel;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class GeneSetTabPanel
extends AbstractControlTabPanel {
    private static final ApplicationLogger logger = new ApplicationLogger(GeneSetTabPanel.class);
    private MediatorImpl mediator;
    private JTable geneSetTable;

    public GeneSetTabPanel(Dialog dialog, MediatorImpl mediatorImpl) {
        super(dialog);
        this.mediator = mediatorImpl;
        this.createComponents();
    }

    private void createComponents() {
        this.geneSetTable = new JTable(new GeneSetTableModel());
        TableColumnModel tableColumnModel = this.geneSetTable.getColumnModel();
        for (int i = 0; i < this.geneSetTable.getColumnCount(); ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            tableColumn.setCellRenderer(new SetTableCellRenderer());
        }
        this.geneSetTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                GeneSetTabPanel.this.setEnabledButton();
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.geneSetTable, 20, 30);
        this.setLayout(new GridBagLayout());
        this.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.getControlButtonPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.setEnabledButton();
    }

    public void updateValue() {
        List list = this.getGeneSetList();
        GeneSetTableModel geneSetTableModel = this.getGeneSetTableModel();
        geneSetTableModel.setElementSetList(list);
    }

    private List getGeneSetList() {
        List list = GeneSetFacade.getInstance().getElementSetList();
        Project project = ProjectAccesser.getSelectedProject();
        if (project.isServer()) {
            try {
                List list2 = GeneSetFacade.downloadGeneSetList(project);
                list.addAll(list2);
            }
            catch (Exception exception) {
                String string = "Fail to load gene set from server.";
                logger.warn(string, exception);
                MessageManager.showErrorMessage(this.parent, string);
            }
        }
        return list;
    }

    private void setEnabledButton() {
        int n = this.geneSetTable.getSelectedRow();
        super.setEnabledButton(n);
        if (n == -1) {
            this.downloadButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.editButton.setEnabled(false);
            this.uploadButton.setEnabled(false);
        } else {
            this.deleteButton.setEnabled(this.enableDelete());
            GeneSetTableModel geneSetTableModel = this.getGeneSetTableModel();
            AbstractElementSet abstractElementSet = geneSetTableModel.getElementSet(n);
            List list = this.getSelectedGeneSetList();
            if (LocationType.isNameServer(abstractElementSet.getLocation())) {
                List list2 = AbstractElementSetFacade.getServerSetList(list);
                this.downloadButton.setEnabled(list2.size() == list.size());
                this.editButton.setEnabled(true);
                this.uploadButton.setEnabled(false);
            } else {
                List list3 = AbstractElementSetFacade.getLocalSetList(list);
                this.downloadButton.setEnabled(false);
                this.editButton.setEnabled(true);
                this.uploadButton.setEnabled(list3.size() == list.size());
            }
        }
    }

    private boolean enableDelete() {
        List list = this.getSelectedGeneSetList();
        if (CollectionUtil.isNull(list)) {
            return false;
        }
        List list2 = AbstractElementSetFacade.getServerSetList(list);
        return CollectionUtil.isNull(list2) || list2.size() == list.size();
    }

    private List getSelectedGeneSetList() {
        ArrayList<GeneSet> arrayList = new ArrayList<GeneSet>();
        int[] nArray = this.geneSetTable.getSelectedRows();
        if (nArray == null || nArray.length == 0) {
            return arrayList;
        }
        GeneSetTableModel geneSetTableModel = this.getGeneSetTableModel();
        for (int i = 0; i < nArray.length; ++i) {
            GeneSet geneSet = geneSetTableModel.getGeneSet(nArray[i]);
            arrayList.add(geneSet);
        }
        return arrayList;
    }

    private GeneSetTableModel getGeneSetTableModel() {
        GeneSetTableModel geneSetTableModel = (GeneSetTableModel)this.geneSetTable.getModel();
        return geneSetTableModel;
    }

    @Override
    protected void add() {
        try {
            Project project = ProjectAccesser.getSelectedProject();
            GeneSetImportDialog geneSetImportDialog = GeneSetImportDialog.getInstanse(this.parent);
            geneSetImportDialog.updateValue(project.getProjectName(), true);
            geneSetImportDialog.setVisible(true);
            if (geneSetImportDialog.isCanceled()) {
                return;
            }
            GeneSet geneSet = geneSetImportDialog.createGeneSet();
            geneSet.setNew();
            String string = geneSetImportDialog.getFilepath();
            List list = GeneSetFacade.getGeneInfoListFromUserFile(string);
            geneSet.setElementList(list);
            GeneSetTableModel geneSetTableModel = this.getGeneSetTableModel();
            geneSetTableModel.add(geneSet);
        }
        catch (GeneSetIOException geneSetIOException) {
            logger.warn(geneSetIOException.getMessage(), geneSetIOException);
            MessageManager.showErrorMessage(this.parent, geneSetIOException.getMessage());
        }
        catch (IOException iOException) {
            String string = "Fail to register gene set.";
            logger.warn(string, iOException);
            MessageManager.showErrorMessage(this.parent, string);
        }
    }

    @Override
    protected void edit() {
        Object object;
        int n = this.geneSetTable.getSelectedRow();
        if (n == -1) {
            return;
        }
        GeneSetTableModel geneSetTableModel = this.getGeneSetTableModel();
        GeneSet geneSet = geneSetTableModel.getGeneSet(n);
        if (!geneSet.isExistElement()) {
            object = GeneSetFacade.getInstance().importElementList(geneSet);
            geneSet.setElementList((List)object);
        }
        object = GeneSetEditDialog.getInstance();
        ((GeneSetEditDialog)object).updateValue(geneSet);
        ((Dialog)object).setVisible(true);
        if (((AbstractApplyDialog)object).isCanceled()) {
            return;
        }
        GeneSet geneSet2 = ((GeneSetEditDialog)object).createGeneSet();
        geneSet.copy(geneSet2);
        geneSet.setStatus(geneSet2.getStatus());
        geneSetTableModel.updateElementSetList();
    }

    @Override
    protected void delete() {
        if (!this.enableDelete()) {
            return;
        }
        List list = this.getSelectedGeneSetList();
        List list2 = AbstractElementSetFacade.getServerSetList(list);
        List list3 = AbstractElementSetFacade.getLocalSetList(list);
        if (list.size() == list2.size()) {
            Object[] objectArray = new String[]{"Delete the following sets?", AbstractElementSetFacade.getElementSetNameString(list2)};
            if (!MessageManager.showConfirmMessage((Component)this, objectArray)) {
                return;
            }
            SetDeleteRequestExecuter setDeleteRequestExecuter = new SetDeleteRequestExecuter(this.parent, list2);
            setDeleteRequestExecuter.setAfterRunnable(new SetDeleteAfterRunnable(){

                @Override
                public void run() {
                    GeneSetTabPanel.this.updateValue();
                }
            });
            new ProgressDialog((Dialog)this.parent, this.mediator, 1, "Delete gene set...", false, (ProcessImpl)setDeleteRequestExecuter);
        } else if (list.size() == list3.size()) {
            int[] nArray = this.geneSetTable.getSelectedRows();
            if (nArray == null || nArray.length == 0) {
                return;
            }
            GeneSetTableModel geneSetTableModel = this.getGeneSetTableModel();
            ArrayList arrayList = new ArrayList();
            List list4 = geneSetTableModel.getElementSetList();
            for (int i = 0; i < nArray.length; ++i) {
                arrayList.add(list4.get(nArray[i]));
            }
            Object[] objectArray = new String[]{"Delete the following gene sets?", GeneSetFacade.getElementSetNameString(arrayList)};
            if (!MessageManager.showConfirmMessage((Component)this, objectArray)) {
                return;
            }
            geneSetTableModel.remove(nArray);
        }
    }

    @Override
    protected void download() {
        List list = this.getSelectedGeneSetList();
        List list2 = AbstractElementSetFacade.getServerSetList(list);
        GeneDownloadDialog geneDownloadDialog = new GeneDownloadDialog((Dialog)this.parent);
        Project project = ProjectAccesser.getSelectedProject();
        List list3 = AbstractElementSetFacade.getElementSetNameList(list2);
        geneDownloadDialog.updateValue(project.getProjectName(), list3);
        geneDownloadDialog.setVisible(true);
        if (geneDownloadDialog.isCanceled()) {
            return;
        }
        String string = geneDownloadDialog.getLocationString();
        List list4 = GeneSetFacade.convertServerToLocalSet(list2, string);
        if (!AbstractElementSetFacade.validateSet(this, list4)) {
            return;
        }
        GeneSetDownloadExecuter geneSetDownloadExecuter = new GeneSetDownloadExecuter(this, list4, project);
        geneSetDownloadExecuter.setAfterRunnable(new Runnable(){

            @Override
            public void run() {
                GeneSetTabPanel.this.updateValue();
                GeneSetTabPanel.this.mediator.updateGeneSetTree();
            }
        });
        new ProgressDialog((Dialog)this.parent, this.mediator, 1, "Download gene set...", false, (ProcessImpl)geneSetDownloadExecuter);
    }

    @Override
    protected void upload() {
        List list = this.getSelectedGeneSetList();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                GeneSetTabPanel.this.updateValue();
            }
        };
        this.mediator.uploadGeneSet(this.parent, list, runnable);
    }

    @Override
    protected void changeDefault() {
    }

    @Override
    public boolean check() {
        return true;
    }

    @Override
    protected void updateParameters() {
        try {
            GeneSetTableModel geneSetTableModel = this.getGeneSetTableModel();
            List list = geneSetTableModel.getElementSetList();
            GeneSetFacade.getInstance().registerElementSetList(list);
            this.mediator.updateGeneSetTree();
        }
        catch (Exception exception) {
            String string = "Fail to register gene sets.";
            logger.warn("Fail to register gene sets.", exception);
            MessageManager.showErrorMessage((Component)this, string);
        }
    }
}

