/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set.venn;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.ClusterComparator;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.data.ClusterUtil;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.set.cluster.ClusterListTable;
import cgdp.recog.set.venn.AbstractVennInfoListDialog;
import edu.emory.mathcs.backport.java.util.Collections;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.List;
import javax.swing.JScrollPane;

public class VennClusterListDialog
extends AbstractVennInfoListDialog {
    private ClusterTbl clusterTbl;

    private VennClusterListDialog(Dialog dialog, MediatorImpl mediatorImpl, ClusterTbl clusterTbl) {
        super(dialog, mediatorImpl);
        this.clusterTbl = clusterTbl;
    }

    private VennClusterListDialog(Frame frame, MediatorImpl mediatorImpl, ClusterTbl clusterTbl) {
        super(frame, mediatorImpl);
        this.clusterTbl = clusterTbl;
    }

    public static VennClusterListDialog getInstance(Component component, MediatorImpl mediatorImpl, ClusterTbl clusterTbl) {
        if (component instanceof Dialog) {
            return new VennClusterListDialog((Dialog)component, mediatorImpl, clusterTbl);
        }
        return new VennClusterListDialog((Frame)component, mediatorImpl, clusterTbl);
    }

    @Override
    protected JScrollPane createInfoListTable() {
        return new ClusterListTable();
    }

    @Override
    protected void createSet() {
        Project project = ProjectAccesser.getSelectedProject();
        this.mediator.registerSetByClusterList(this, 11, project.getProjectName(), this.getClusterListTable().getClusterList());
    }

    @Override
    protected void export() {
        this.mediator.export(2, this.getClusterListTable().getClusterList());
    }

    @Override
    protected String getCountLabel() {
        return "Cluster Count:";
    }

    @Override
    protected String getDialogTitle() {
        return "Cluster List";
    }

    @Override
    protected String getSetButtonLabel() {
        return "Create cluster set...";
    }

    @Override
    protected void updateInfoListTable(List list) {
        List list2 = this.clusterTbl.getClusterList(ClusterUtil.getClusterIdSet(list));
        Collections.sort(list2, new ClusterComparator(6));
        this.getClusterListTable().setClusterList(list2);
    }

    private ClusterListTable getClusterListTable() {
        return (ClusterListTable)this.elementListTable;
    }
}

