/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.sort;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.calc.CoefCondition;
import cgdp.recog.calc.ProfilePanel;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.util.AbstractApplyDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Set;

public class PatternCoefDialog
extends AbstractApplyDialog {
    private static PatternCoefDialog PATTERN_COEF_DIALOG;
    private static final String TITLE = "Sort by phylogenetic pattern similarity";
    private MediatorImpl mediator;
    private ProfilePanel profilePanel;

    private PatternCoefDialog(Frame frame, MediatorImpl mediatorImpl) {
        super(frame);
        this.mediator = mediatorImpl;
        this.createComponents();
    }

    public static void createInstance(Frame frame, MediatorImpl mediatorImpl) {
        PATTERN_COEF_DIALOG = new PatternCoefDialog(frame, mediatorImpl);
    }

    public static PatternCoefDialog getInstance() {
        return PATTERN_COEF_DIALOG;
    }

    private void createComponents() {
        this.setTitle(TITLE);
        this.setModal(true);
        this.setResizable(false);
        this.profilePanel = new ProfilePanel(this);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.profilePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(15, 15, 5, 15), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(10, 15, 15, 15), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public void updateValue(Set set) {
        this.profilePanel.updateValue(set);
    }

    public int getProfile() {
        return this.profilePanel.getProfile();
    }

    public AbstractInfoTitle getInfoTitle() {
        return this.profilePanel.getInfoTitle();
    }

    public int getDistType() {
        return this.profilePanel.getDistTypeForHClust();
    }

    public CoefCondition createCoefCondition() {
        CoefCondition coefCondition = CoefCondition.createCoefCondition(null, this.getProfile(), this.getInfoTitle(), this.getDistType(), true, false, false);
        return coefCondition;
    }

    @Override
    protected boolean apply() {
        return true;
    }
}

