/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.sort;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.controltree.ControlTitleNode;
import cgdp.recog.controltree.ControlTitleType;
import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.data.SuperCluster;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.sort.GeneInfoSortCondition;
import cgdp.recog.sort.GeneInfoSortConditionGroup;
import cgdp.recog.sort.GeneInfoSortTreeNode;
import cgdp.recog.sort.SortCondition;
import cgdp.recog.sort.SortMenuFactory;
import cgdp.recog.sort.SortTreeNode;
import cgdp.recog.tree.TreeController;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class SortTreeController
implements TreeController {
    private MediatorImpl mediator;
    private ClusterTbl clusterTbl;

    public SortTreeController(MediatorImpl mediatorImpl) {
        this.mediator = mediatorImpl;
    }

    @Override
    public void createTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (this.clusterTbl == null) {
            return;
        }
        SortCondition sortCondition = this.clusterTbl.getSortCondition();
        if (sortCondition instanceof GeneInfoSortConditionGroup) {
            this.createGeneInfoSortTree(defaultMutableTreeNode, (GeneInfoSortConditionGroup)sortCondition);
        } else if (sortCondition instanceof SortCondition) {
            this.createSortTree(defaultMutableTreeNode, sortCondition);
        }
    }

    private void createGeneInfoSortTree(DefaultMutableTreeNode defaultMutableTreeNode, GeneInfoSortConditionGroup geneInfoSortConditionGroup) {
        SortTreeNode sortTreeNode = new SortTreeNode(geneInfoSortConditionGroup);
        for (GeneInfoSortCondition geneInfoSortCondition : geneInfoSortConditionGroup.getGeneInfoSortConditionList()) {
            GeneInfoSortTreeNode geneInfoSortTreeNode = new GeneInfoSortTreeNode(geneInfoSortConditionGroup, geneInfoSortCondition);
            sortTreeNode.add(geneInfoSortTreeNode);
        }
        defaultMutableTreeNode.add(sortTreeNode);
    }

    private void createSortTree(DefaultMutableTreeNode defaultMutableTreeNode, SortCondition sortCondition) {
        SortTreeNode sortTreeNode = new SortTreeNode(sortCondition);
        defaultMutableTreeNode.add(sortTreeNode);
    }

    @Override
    public JPopupMenu createPopupMenu(JTree jTree, ActionListener actionListener) {
        TreePath[] treePathArray = jTree.getSelectionPaths();
        if (treePathArray == null || treePathArray.length == 0) {
            return null;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (this.isShowSortMenu(treePathArray)) {
            jPopupMenu.add(this.createShortcutSortMenu(actionListener));
        } else if (this.isShowTitleSortMenu(treePathArray)) {
            jPopupMenu.add(this.createShortcutSortMenu(actionListener));
        } else if (this.isShowKeySortMenu(treePathArray)) {
            jPopupMenu.add(this.createShortcutSortMenu(actionListener));
        }
        return jPopupMenu;
    }

    private boolean isShowSortMenu(TreePath[] treePathArray) {
        if (treePathArray[0].getPathCount() != 2) {
            return false;
        }
        TreePath treePath = treePathArray[0];
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(1);
        if (!(defaultMutableTreeNode instanceof ControlTitleNode)) {
            return false;
        }
        return ControlTitleType.isSort(((ControlTitleNode)defaultMutableTreeNode).getControlTitleType());
    }

    private boolean isShowTitleSortMenu(TreePath[] treePathArray) {
        if (treePathArray[0].getPathCount() != 3) {
            return false;
        }
        TreePath treePath = treePathArray[0];
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(1);
        if (!(defaultMutableTreeNode instanceof ControlTitleNode)) {
            return false;
        }
        if (!ControlTitleType.isSort(((ControlTitleNode)defaultMutableTreeNode).getControlTitleType())) {
            return false;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePath.getPathComponent(2);
        return defaultMutableTreeNode2 instanceof SortTreeNode;
    }

    private boolean isShowKeySortMenu(TreePath[] treePathArray) {
        if (treePathArray[0].getPathCount() != 4) {
            return false;
        }
        TreePath treePath = treePathArray[0];
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(1);
        if (!(defaultMutableTreeNode instanceof ControlTitleNode)) {
            return false;
        }
        if (!ControlTitleType.isSort(((ControlTitleNode)defaultMutableTreeNode).getControlTitleType())) {
            return false;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePath.getPathComponent(3);
        return defaultMutableTreeNode2 instanceof GeneInfoSortTreeNode;
    }

    private JMenu createShortcutSortMenu(ActionListener actionListener) {
        JMenu jMenu;
        if (OptionTbl.getInstance().getOptionValues().isIntensive()) {
            Map map = this.clusterTbl.getSelectedBasePattern();
            List list = this.clusterTbl.getViewClusterList(map);
            SuperCluster superCluster = new SuperCluster(list);
            jMenu = SortMenuFactory.createSortMenuForAggregate(actionListener, this.mediator, superCluster, this.clusterTbl.getViewOrganismCodeList());
        } else {
            String string = this.clusterTbl.getSelectedOrganismCode();
            Cluster cluster = this.clusterTbl.getSelectedBaseCluster();
            jMenu = SortMenuFactory.createSortMenuForDisaggregate(actionListener, this.mediator, this.clusterTbl, cluster, string);
        }
        return jMenu;
    }

    public void setClusterTbl(ClusterTbl clusterTbl) {
        this.clusterTbl = clusterTbl;
    }

    public void actionAfterDoubleClick(DefaultMutableTreeNode defaultMutableTreeNode) {
    }
}

