/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.system.property;

import cgdp.recog.system.property.ApplicationPropertyConf;
import cgdp.recog.system.property.ApplicationPropertyFacade;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.FocusTextField;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.StringTool;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ApplicationPropertyDialog
extends AbstractApplyDialog {
    private static ApplicationPropertyDialog APPLICATION_PROPERTY_DIALOG;
    private static final String TITLE = "Save";
    private FocusTextField nameTextField;
    private JTextArea commentArea;
    private String baseName;

    private ApplicationPropertyDialog(Frame frame) {
        super(frame);
        this.createComponents();
    }

    public static void createInstance(Frame frame) {
        APPLICATION_PROPERTY_DIALOG = new ApplicationPropertyDialog(frame);
    }

    public static ApplicationPropertyDialog getInstance() {
        return APPLICATION_PROPERTY_DIALOG;
    }

    private void createComponents() {
        this.setTitle(TITLE);
        this.setModal(true);
        this.setResizable(true);
        JLabel jLabel = new JLabel("Name");
        this.nameTextField = new FocusTextField(30);
        JLabel jLabel2 = new JLabel("Comment");
        this.commentArea = new JTextArea(5, 40);
        JScrollPane jScrollPane = new JScrollPane(this.commentArea);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 15, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.nameTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 0, 15), 0, 0));
        this.getContentPane().add((Component)jLabel2, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 0, new Insets(10, 10, 0, 15), 0, 0));
        this.getContentPane().add((Component)jScrollPane, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 1, new Insets(10, 10, 0, 15), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 0, new Insets(10, 15, 15, 15), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public void updateValue(String string, String string2) {
        this.baseName = string;
        this.nameTextField.setText(string);
        String string3 = StringTool.displayNewLine2NewLine(string2);
        this.commentArea.setText(string3);
    }

    @Override
    public String getName() {
        return this.nameTextField.getText();
    }

    public String getComment() {
        String string = this.commentArea.getText();
        return StringTool.newLine2DisplayNewLine(string);
    }

    @Override
    protected boolean check() {
        String string = this.getName();
        if (StringTool.isNull(string)) {
            MessageManager.showErrorMessage((Component)this, "Input name.");
            return false;
        }
        ApplicationPropertyConf applicationPropertyConf = ApplicationPropertyFacade.getConf(string);
        return applicationPropertyConf == null || !StringTool.isNull(this.baseName) || applicationPropertyConf.equalsName(this.baseName) || MessageManager.showConfirmOverwriteMessage(this, string);
    }

    @Override
    protected boolean apply() {
        return true;
    }
}

