/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.RankComparator;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.option.OptionValues;
import cgdp.recog.util.StringTool;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class RankSelectPanel
extends JPanel {
    private static final int COMBOBOX_WIDTH = 100;
    private JComboBox rankComboBox;

    public RankSelectPanel(MediatorImpl mediatorImpl) {
        mediatorImpl.register(this);
        this.init();
    }

    public void init() {
        JLabel jLabel = new JLabel("Rank:");
        this.rankComboBox = new JComboBox();
        this.rankComboBox.setPreferredSize(new Dimension(100, this.rankComboBox.getPreferredSize().height));
        this.rankComboBox.setMinimumSize(new Dimension(100, this.rankComboBox.getPreferredSize().height));
        this.rankComboBox.setSelectedItem("genus");
        this.setLayout(new GridBagLayout());
        this.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        this.add((Component)this.rankComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        this.updateRankItem();
    }

    public void updateRankItem() {
        String string = (String)this.rankComboBox.getSelectedItem();
        this.rankComboBox.removeAllItems();
        OptionValues optionValues = OptionTbl.getInstance().getOptionValues();
        List list = optionValues.getRankItemList();
        Collections.sort(list, new RankComparator(1));
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.rankComboBox.addItem(iterator.next());
        }
        if (!StringTool.isNull(string)) {
            this.rankComboBox.setSelectedItem(string);
        }
    }

    public String getSelectedRank() {
        return (String)this.rankComboBox.getSelectedItem();
    }
}

