/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.server.AccessServer;
import cgdp.recog.system.URLList;
import cgdp.recog.taxonomy.TaxSearchCondition;
import cgdp.recog.util.FocusTextField;
import cgdp.recog.util.StringTool;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TaxSearchPanel
extends JPanel
implements ActionListener {
    private MediatorImpl mediator;
    private FocusTextField keywordTextField;
    private JComboBox targetComboBox;
    private Map targetMap = new HashMap();
    private CooserURLLabel searchLabel;

    public TaxSearchPanel(MediatorImpl mediatorImpl) {
        this.mediator = mediatorImpl;
        this.createComponents();
    }

    private void createComponents() {
        this.createTargetComboBox();
        this.keywordTextField = new FocusTextField();
        this.keywordTextField.addActionListener(this);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.targetComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.keywordTextField, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        String string = AccessServer.getInstance().getServerUrl() + URLList.getInstance().getOrganismSelection() + "?mode=recog";
        String string2 = "Chooser";
        this.searchLabel = new CooserURLLabel(string, string2, this.mediator);
        this.add((Component)this.searchLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.searchLabel.setToolTipText(string2);
    }

    private void createTargetComboBox() {
        this.targetComboBox = new JComboBox();
        this.targetComboBox.addItem("Name");
        this.targetComboBox.addItem("Sp Code");
        this.targetMap.put("Name", new Integer(2));
        this.targetMap.put("Sp Code", new Integer(1));
    }

    private String getKeywords() {
        return this.keywordTextField.getText();
    }

    private int getTarget() {
        String string = (String)this.targetComboBox.getSelectedItem();
        return (Integer)this.targetMap.get(string);
    }

    private int getSearchType() {
        int n = this.getTarget();
        if (TaxSearchCondition.isFullName(n)) {
            return 3;
        }
        return 1;
    }

    private TaxSearchCondition createCondition() {
        String string = this.getKeywords().replaceAll(" ", ",");
        HashSet hashSet = new HashSet(StringTool.splitString(string, ","));
        TaxSearchCondition taxSearchCondition = new TaxSearchCondition();
        taxSearchCondition.setKeywordSet(hashSet);
        taxSearchCondition.setTargetType(this.getTarget());
        taxSearchCondition.setResultType(1);
        taxSearchCondition.setSearchType(this.getSearchType());
        return taxSearchCondition;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.keywordTextField) {
            if (StringTool.isNull(this.getKeywords())) {
                return;
            }
            TaxSearchCondition taxSearchCondition = this.createCondition();
            this.mediator.searchTaxonomyTreePath(taxSearchCondition);
        }
    }

    private class CooserURLLabel
    extends JLabel {
        private String href;
        private final String text;
        private MediatorImpl mediator;

        public CooserURLLabel(String string, String string2, MediatorImpl mediatorImpl) {
            this.href = string;
            this.text = string2;
            this.mediator = mediatorImpl;
            String string3 = "<html><a href=''>" + this.text + "</a>";
            this.setText(string3);
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    CooserURLLabel.this.href = AccessServer.getInstance().getServerUrl() + URLList.getInstance().getOrganismSelection() + "?mode=recog";
                    CooserURLLabel.this.mediator.viewUrl(CooserURLLabel.this.href);
                }
            });
        }
    }
}

