/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.data.InnerTbl;
import cgdp.recog.data.OuterTbl;
import cgdp.recog.data.PublicSpecTbl;
import cgdp.recog.data.RankDif;
import cgdp.recog.mapping.MapMenu;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.organism.ModifiedOrganismManager;
import cgdp.recog.organism.Organism;
import cgdp.recog.organism.OrganismUtil;
import cgdp.recog.process.CommandImpl;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.server.ServerTbl;
import cgdp.recog.system.OS;
import cgdp.recog.system.property.ApplicationPropertyFacade;
import cgdp.recog.taxonomy.AutoGroupItem;
import cgdp.recog.taxonomy.GroupItem;
import cgdp.recog.taxonomy.OrganismColorCancelItem;
import cgdp.recog.taxonomy.OrganismColorItem;
import cgdp.recog.taxonomy.TaxFacade;
import cgdp.recog.taxonomy.TaxonomyTreeCellRenderer;
import cgdp.recog.taxonomy.TaxonomyTreeEx;
import cgdp.recog.taxonomy.TaxonomyTreeExCellRenderer;
import cgdp.recog.taxonomy.TaxonomyTreeNode;
import cgdp.recog.taxonomy.TaxonomyTreeNodeComparator;
import cgdp.recog.taxonomy.TreeExTransferHandler;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.MapUtil;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.StringTool;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TaxonomyTree
extends JTree
implements MouseListener,
ActionListener {
    private static final ApplicationLogger logger = new ApplicationLogger(TaxonomyTree.class);
    protected MediatorImpl m_mediatorImpl;
    protected OptionTbl m_optionTbl;
    protected ClusterTbl m_clusterTbl;
    protected OuterTbl m_outerTbl;
    protected InnerTbl m_innerTbl;
    protected PublicSpecTbl m_publicSpecTbl;
    protected ServerTbl m_serverTbl;
    protected List m_nodeList;
    protected TaxonomyTreeNode m_root;
    protected boolean enableShowModifiedOrganism = false;

    public TaxonomyTree(MediatorImpl mediatorImpl) throws Exception {
        this.m_mediatorImpl = mediatorImpl;
        this.m_mediatorImpl.register(this);
        this.clear();
        if (this instanceof TaxonomyTreeEx) {
            this.setDragEnabled(true);
            this.setCellRenderer(new TaxonomyTreeExCellRenderer());
            this.setTransferHandler(new TreeExTransferHandler());
        } else {
            this.setCellRenderer(new TaxonomyTreeCellRenderer());
        }
        this.addMouseListener(this);
        if (this instanceof TaxonomyTreeEx) {
            this.addNoData();
        } else {
            Project project = ProjectAccesser.getSelectedProject();
            if (project != null) {
                this.createComponent(project.getOrganismCodeList());
            } else {
                this.createComponent(null);
            }
        }
        this.setToolTipText("");
    }

    private void clear() throws Exception {
        this.m_optionTbl = OptionTbl.getInstance();
        this.m_clusterTbl = null;
        this.m_outerTbl = OuterTbl.getInstance();
        this.m_innerTbl = InnerTbl.getInstance();
        this.m_publicSpecTbl = PublicSpecTbl.getInstance();
        this.m_serverTbl = ServerTbl.getInstance();
        this.m_nodeList = new ArrayList();
        this.m_root = null;
        this.readTaxonomyDat();
    }

    public void readTaxonomyDat() throws Exception {
        this.m_nodeList = TaxFacade.getTaxonomyTreeNodeList();
        if (this.isEnableShowModifiedOrganism()) {
            this.m_nodeList = ModifiedOrganismManager.getInstance().modifyTaxonomyTreeNodeList(this.m_nodeList);
        }
    }

    public void setEnableShowModifiedOrganism(boolean bl) {
        this.enableShowModifiedOrganism = bl;
    }

    protected boolean isEnableShowModifiedOrganism() {
        return this.enableShowModifiedOrganism;
    }

    public void addNoData() {
        if (this.m_root != null) {
            this.removeNode(this.m_root);
            this.removeNode();
        }
        this.m_root = new TaxonomyTreeNode(1, "No Data", "nd", "null", 0, 0, 0L);
        this.setModel(new DefaultTreeModel(this.m_root));
    }

    private void createComponent(Collection collection) {
        try {
            this.m_root = this.createTreeStructure(this.m_nodeList, collection);
            if (this.m_root == null) {
                return;
            }
            if (this.m_optionTbl.getOptionValues().isShowAllRankOnTree()) {
                TaxFacade.filterNoBrother(this.m_root);
            } else {
                TaxFacade.filterRank(this.m_root);
            }
            this.setCount(this.m_root);
            this.setModel(new DefaultTreeModel(this.m_root));
            this.expandAll();
        }
        catch (Exception exception) {
            String string = "Failed to create taxonomy tree structure.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage((Component)this, string);
            this.initTaxonomyTree();
        }
    }

    private TaxonomyTreeNode createTreeStructure(List list, Collection collection) {
        return TaxFacade.createTaxonomyTree(list, collection);
    }

    private void setLeafList(TaxonomyTreeNode taxonomyTreeNode, List list) {
        if (taxonomyTreeNode.isLeaf()) {
            list.add(taxonomyTreeNode);
        }
        int n = taxonomyTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            TaxonomyTreeNode taxonomyTreeNode2 = (TaxonomyTreeNode)taxonomyTreeNode.getChildAt(i);
            this.setLeafList(taxonomyTreeNode2, list);
        }
    }

    public Map getSpNameMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ArrayList arrayList = new ArrayList();
        this.setLeafList(this.m_root, arrayList);
        for (TaxonomyTreeNode taxonomyTreeNode : arrayList) {
            hashMap.put(taxonomyTreeNode.getAbbreviation(), taxonomyTreeNode.getName());
        }
        return hashMap;
    }

    protected void setCount(TaxonomyTreeNode taxonomyTreeNode) {
        if (taxonomyTreeNode.isLeaf()) {
            return;
        }
        int n = taxonomyTreeNode.getLeafCount();
        taxonomyTreeNode.setUserObject(taxonomyTreeNode.getName() + "(" + n + ")");
        int n2 = taxonomyTreeNode.getChildCount();
        for (int i = 0; i < n2; ++i) {
            TaxonomyTreeNode taxonomyTreeNode2 = (TaxonomyTreeNode)taxonomyTreeNode.getChildAt(i);
            this.setCount(taxonomyTreeNode2);
        }
    }

    private void removeNode(TaxonomyTreeNode taxonomyTreeNode) {
        if (taxonomyTreeNode == null) {
            return;
        }
        int n = taxonomyTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            TaxonomyTreeNode taxonomyTreeNode2 = (TaxonomyTreeNode)taxonomyTreeNode.getChildAt(i);
            this.removeNode(taxonomyTreeNode2);
        }
        taxonomyTreeNode.removeAllChildren();
    }

    private void removeNode() {
        for (TaxonomyTreeNode taxonomyTreeNode : this.m_nodeList) {
            if (taxonomyTreeNode.getChildCount() == 0) continue;
            taxonomyTreeNode.removeAllChildren();
        }
    }

    private void showPopup(Map map, Point point) {
        String string;
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenu jMenu = new JMenu("Group");
        jPopupMenu.add(jMenu);
        jMenu.add(new GroupItem(this, this.m_mediatorImpl, map, "Ingroup", 2));
        jMenu.add(new GroupItem(this, this.m_mediatorImpl, map, "Outgroup", 1));
        jMenu.add(new AutoGroupItem(this, this.m_mediatorImpl, map, "Auto Ingroup", 2));
        jMenu.add(new AutoGroupItem(this, this.m_mediatorImpl, map, "Auto Outgroup", 1));
        jMenu.add(new GroupItem(this, this.m_mediatorImpl, map, "Cancel", 0));
        jMenu = new JMenu("Color");
        jPopupMenu.add(jMenu);
        jMenu.add(new OrganismColorItem(this, this.m_mediatorImpl, map.keySet()));
        jMenu.add(new OrganismColorCancelItem(this, this.m_mediatorImpl, map.keySet()));
        if (!MapUtil.isNull(map) && map.size() == 1 && ApplicationPropertyFacade.isIncompleteOrganismCode(string = (String)map.keySet().iterator().next())) {
            jPopupMenu.addSeparator();
            jPopupMenu.add(new MapMenu(this, this.m_mediatorImpl, string));
        }
        jPopupMenu.show(this, point.x, point.y);
    }

    public void setClusterTbl(ClusterTbl clusterTbl) {
        this.m_clusterTbl = clusterTbl;
    }

    public ClusterTbl getClusterTbl() {
        return this.m_clusterTbl;
    }

    public void createTaxonomyTree() {
        this.removeNode(this.m_root);
        this.removeNode();
        if (this.m_clusterTbl != null) {
            this.createComponent(this.m_clusterTbl.getOrganismCodeList());
        } else {
            Project project = ProjectAccesser.getSelectedProject();
            this.createComponent(project.getOrganismCodeList());
        }
        this.repaint();
    }

    public String getOrganismName(String string) {
        int n = 0;
        String string2 = null;
        for (TaxonomyTreeNode taxonomyTreeNode : this.m_nodeList) {
            if (!taxonomyTreeNode.getAbbreviation().equals(string) || n >= taxonomyTreeNode.getLevel()) continue;
            n = taxonomyTreeNode.getLevel();
            string2 = taxonomyTreeNode.getName();
        }
        return !StringTool.isNull(string2) ? string2 : string;
    }

    private List getInnerNodeList() {
        ArrayList arrayList = new ArrayList();
        this.setInnerList(this.m_root, arrayList);
        return arrayList;
    }

    public Set getInnerSpSet() {
        List list = this.getInnerNodeList();
        HashSet<String> hashSet = new HashSet<String>();
        for (TaxonomyTreeNode taxonomyTreeNode : list) {
            hashSet.add(taxonomyTreeNode.getAbbreviation());
        }
        return hashSet;
    }

    public boolean isExistInner() {
        return !this.getInnerNodeList().isEmpty();
    }

    private void setInnerList(TaxonomyTreeNode taxonomyTreeNode, List list) {
        if (taxonomyTreeNode.isLeaf() && this.m_innerTbl.get(taxonomyTreeNode.getAbbreviation()) != null) {
            list.add(taxonomyTreeNode);
        }
        int n = taxonomyTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            TaxonomyTreeNode taxonomyTreeNode2 = (TaxonomyTreeNode)taxonomyTreeNode.getChildAt(i);
            this.setInnerList(taxonomyTreeNode2, list);
        }
    }

    private List getOuterNodeList() {
        ArrayList arrayList = new ArrayList();
        this.setOuterList(this.m_root, arrayList);
        return arrayList;
    }

    public Set getOuterSpSet() {
        List list = this.getOuterNodeList();
        HashSet<String> hashSet = new HashSet<String>();
        for (TaxonomyTreeNode taxonomyTreeNode : list) {
            hashSet.add(taxonomyTreeNode.getAbbreviation());
        }
        return hashSet;
    }

    private void setOuterList(TaxonomyTreeNode taxonomyTreeNode, List list) {
        if (taxonomyTreeNode.isLeaf() && this.m_outerTbl.get(taxonomyTreeNode.getAbbreviation()) != null) {
            list.add(taxonomyTreeNode);
        }
        int n = taxonomyTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            TaxonomyTreeNode taxonomyTreeNode2 = (TaxonomyTreeNode)taxonomyTreeNode.getChildAt(i);
            this.setOuterList(taxonomyTreeNode2, list);
        }
    }

    protected void setSelectedOrganism(TaxonomyTreeNode taxonomyTreeNode, Map map) {
        if (taxonomyTreeNode.isLeaf() && map.get(taxonomyTreeNode.getAbbreviation()) == null) {
            map.put(taxonomyTreeNode.getAbbreviation(), taxonomyTreeNode);
        }
        int n = taxonomyTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            TaxonomyTreeNode taxonomyTreeNode2 = (TaxonomyTreeNode)taxonomyTreeNode.getChildAt(i);
            this.setSelectedOrganism(taxonomyTreeNode2, map);
        }
    }

    public void setSelectNode(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        this.setSelectGenomeNode(hashSet);
    }

    public void setSelectNode(Collection collection) {
        Rectangle rectangle = null;
        HashSet<TreePath> hashSet = new HashSet<TreePath>();
        for (TaxonomyTreeNode taxonomyTreeNode : collection) {
            TreePath treePath = new TreePath(taxonomyTreeNode.getPath());
            hashSet.add(treePath);
            int n = this.getRowForPath(treePath);
            if (n == -1) continue;
            Rectangle rectangle2 = this.getRowBounds(n);
            if (rectangle == null) {
                rectangle = rectangle2;
                continue;
            }
            rectangle = rectangle.union(rectangle2);
        }
        if (!hashSet.isEmpty()) {
            this.setSelectionPaths(hashSet.toArray(new TreePath[hashSet.size()]));
            if (rectangle != null) {
                this.scrollRectToVisible(rectangle);
            }
        }
    }

    public void setSelectGenomeNode(Collection collection) {
        if (collection == null) {
            return;
        }
        List list = this.getAllLeafList(this.m_root);
        HashSet<TreePath> hashSet = new HashSet<TreePath>();
        Rectangle rectangle = null;
        for (TaxonomyTreeNode taxonomyTreeNode : list) {
            if (!collection.contains(taxonomyTreeNode.getAbbreviation())) continue;
            TreePath treePath = new TreePath(taxonomyTreeNode.getPath());
            hashSet.add(treePath);
            int n = this.getRowForPath(treePath);
            if (n == -1) continue;
            Rectangle rectangle2 = this.getRowBounds(n);
            if (rectangle == null) {
                rectangle = rectangle2;
                continue;
            }
            rectangle = rectangle.union(rectangle2);
        }
        if (!hashSet.isEmpty()) {
            this.setSelectionPaths(hashSet.toArray(new TreePath[hashSet.size()]));
            if (rectangle != null) {
                this.scrollRectToVisible(rectangle);
            }
        } else {
            this.clearSelection();
        }
    }

    public void initTaxonomyTree() {
        this.m_clusterTbl = null;
        this.addNoData();
        this.m_nodeList.clear();
        this.repaint();
    }

    public TaxonomyTreeNode getTaxonomyTreeNode(String string) {
        return this.getTaxonomyTreeNode(this.m_root, string);
    }

    private TaxonomyTreeNode getTaxonomyTreeNode(TaxonomyTreeNode taxonomyTreeNode, String string) {
        TaxonomyTreeNode taxonomyTreeNode2;
        TaxonomyTreeNode taxonomyTreeNode3 = null;
        int n = taxonomyTreeNode.getChildCount();
        for (int i = 0; i < n && (taxonomyTreeNode3 = (taxonomyTreeNode2 = (TaxonomyTreeNode)taxonomyTreeNode.getChildAt(i)).isLeaf() && string.equals(taxonomyTreeNode2.getAbbreviation()) ? taxonomyTreeNode2 : this.getTaxonomyTreeNode(taxonomyTreeNode2, string)) == null; ++i) {
        }
        return taxonomyTreeNode3;
    }

    public List getTaxonomyTreeNodeListByMaxSpecweight(String string, Collection collection) {
        Map map = this.createBaseLeafNodeMap(string, collection);
        ArrayList<TaxonomyTreeNode> arrayList = new ArrayList<TaxonomyTreeNode>();
        for (TaxonomyTreeNode taxonomyTreeNode : map.keySet()) {
            Set set = (Set)map.get(taxonomyTreeNode);
            arrayList.add(this.getTaxonomyTreeNodeByMaxSepcweight(set));
        }
        return arrayList;
    }

    private TaxonomyTreeNode getTaxonomyTreeNodeByMaxSepcweight(Set set) {
        long l = Long.MIN_VALUE;
        ArrayList<TaxonomyTreeNode> arrayList = new ArrayList<TaxonomyTreeNode>();
        for (TaxonomyTreeNode taxonomyTreeNode : set) {
            if (l < taxonomyTreeNode.getSpecWeight()) {
                l = taxonomyTreeNode.getSpecWeight();
                arrayList.clear();
                arrayList.add(taxonomyTreeNode);
                continue;
            }
            if (l != taxonomyTreeNode.getSpecWeight()) continue;
            arrayList.add(taxonomyTreeNode);
        }
        if (arrayList.size() > 1) {
            Collections.sort(arrayList, new TaxonomyTreeNodeComparator());
        }
        if (arrayList.isEmpty()) {
            arrayList.clear();
        }
        return (TaxonomyTreeNode)arrayList.get(0);
    }

    private List getAllLeafList(TaxonomyTreeNode taxonomyTreeNode) {
        ArrayList<TaxonomyTreeNode> arrayList = new ArrayList<TaxonomyTreeNode>();
        Enumeration<TreeNode> enumeration = taxonomyTreeNode.children();
        while (enumeration.hasMoreElements()) {
            TaxonomyTreeNode taxonomyTreeNode2 = (TaxonomyTreeNode)enumeration.nextElement();
            if (taxonomyTreeNode2.isLeaf()) {
                arrayList.add(taxonomyTreeNode2);
                continue;
            }
            arrayList.addAll(this.getAllLeafList(taxonomyTreeNode2));
        }
        return arrayList;
    }

    private Map createBaseLeafNodeMap(String string, Collection collection) {
        List list = null;
        try {
            list = TaxFacade.getTaxonomyTreeNodeList();
        }
        catch (Exception exception) {
            logger.warn("Fail to load taxonomy.dat.", exception);
            return new HashMap();
        }
        TaxonomyTreeNode taxonomyTreeNode = this.createTreeStructure(list, collection);
        ArrayList arrayList = new ArrayList();
        this.setLeafList(taxonomyTreeNode, arrayList);
        HashMap<TaxonomyTreeNode, HashSet<TaxonomyTreeNode>> hashMap = new HashMap<TaxonomyTreeNode, HashSet<TaxonomyTreeNode>>();
        block2: for (TaxonomyTreeNode taxonomyTreeNode2 : arrayList) {
            if (collection != null && !collection.contains(taxonomyTreeNode2.getAbbreviation())) continue;
            TreeNode[] treeNodeArray = taxonomyTreeNode2.getPath();
            TaxonomyTreeNode taxonomyTreeNode3 = null;
            for (int i = 0; i < treeNodeArray.length; ++i) {
                Set<TaxonomyTreeNode> set;
                TaxonomyTreeNode taxonomyTreeNode4 = (TaxonomyTreeNode)treeNodeArray[i];
                if (taxonomyTreeNode4.equalsRank(string)) {
                    set = (HashSet<TaxonomyTreeNode>)hashMap.get(taxonomyTreeNode4);
                    if (set == null) {
                        set = new HashSet<TaxonomyTreeNode>();
                        hashMap.put(taxonomyTreeNode4, (HashSet<TaxonomyTreeNode>)set);
                    }
                    set.add(taxonomyTreeNode2);
                    continue block2;
                }
                if (taxonomyTreeNode4.isMinRank(string)) {
                    set = (Set)hashMap.get(taxonomyTreeNode3);
                    if (set == null) {
                        set = new HashSet();
                        hashMap.put(taxonomyTreeNode3, (HashSet<TaxonomyTreeNode>)set);
                    }
                    set.add(taxonomyTreeNode2);
                    continue block2;
                }
                if (taxonomyTreeNode3 != null && RankDif.isNoRank(taxonomyTreeNode4.getRank())) continue;
                taxonomyTreeNode3 = taxonomyTreeNode4;
            }
        }
        return hashMap;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!OS.isWindows()) {
            this.controlMouseForShowPopup(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (OS.isWindows()) {
            this.controlMouseForShowPopup(mouseEvent);
        }
    }

    private void controlMouseForShowPopup(MouseEvent mouseEvent) {
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray != null) {
            Map map = this.createSelectedOrganismMap();
            this.setSelectChileNode();
            this.m_mediatorImpl.selectOrganismOnTaxonomyTreeEx(map.keySet());
            if (mouseEvent.isPopupTrigger()) {
                int n = this.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (this.isRowSelected(n)) {
                    this.showPopup(map, mouseEvent.getPoint());
                    return;
                }
            } else {
                this.m_mediatorImpl.setSelectedOrganism(map.keySet(), this);
            }
        } else {
            this.m_mediatorImpl.setSelectedOrganism(new HashSet(), this);
        }
    }

    protected Map createSelectedOrganismMap() {
        TreePath[] treePathArray = this.getSelectionPaths();
        HashMap hashMap = new HashMap();
        for (int i = 0; i < treePathArray.length; ++i) {
            TaxonomyTreeNode taxonomyTreeNode = (TaxonomyTreeNode)treePathArray[i].getLastPathComponent();
            this.setSelectedOrganism(taxonomyTreeNode, hashMap);
        }
        return hashMap;
    }

    protected void setSelectChileNode() {
        int n;
        TreePath[] treePathArray = this.getSelectionPaths();
        int[] nArray = this.getSelectionRows();
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        for (n = 0; n < nArray.length; ++n) {
            hashMap.put(new Integer(nArray[n]), "OK");
        }
        for (n = 0; n < treePathArray.length; ++n) {
            TreePath treePath;
            int n2 = this.getRowForPath(treePathArray[n]);
            int n3 = this.getRowCount();
            for (int i = n2 + 1; i < n3 && treePathArray[n].isDescendant(treePath = this.getPathForRow(i)); ++i) {
                if (this.isRowSelected(i) || hashMap.get(new Integer(i)) != null) continue;
                hashMap.put(new Integer(i), "OK");
            }
        }
        if (nArray.length != hashMap.size()) {
            ArrayList arrayList = new ArrayList();
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            Collections.sort(arrayList, new Comparator(){

                public int compare(Object object, Object object2) {
                    return (Integer)object - (Integer)object2;
                }
            });
            nArray = null;
            nArray = new int[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                nArray[i] = (Integer)arrayList.get(i);
            }
            this.setSelectionRows(nArray);
            nArray = null;
            arrayList.clear();
            arrayList = null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ((CommandImpl)actionEvent.getSource()).execute();
    }

    public void nodeChanged(Collection collection) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        for (TreeNode treeNode : collection) {
            defaultTreeModel.nodeChanged(treeNode);
        }
        this.repaint();
    }

    public void nodeChanged(TreeNode treeNode) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        defaultTreeModel.nodeChanged(treeNode);
        this.repaint();
    }

    private void expandAll() {
        this.expandAll(this.m_root);
    }

    private void expandAll(DefaultMutableTreeNode defaultMutableTreeNode) {
        int n = defaultMutableTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            this.expandPath(new TreePath(defaultMutableTreeNode2.getPath()));
            if (defaultMutableTreeNode2.isLeaf()) continue;
            this.expandAll(defaultMutableTreeNode2);
        }
    }

    public void expandByOneStep() {
        int n = this.getMinLayerCountOfCollapseNode(this.m_root, 0);
        this.expandByOneStep(this.m_root, 0, n);
    }

    private int getMinLayerCountOfCollapseNode(DefaultMutableTreeNode defaultMutableTreeNode, int n) {
        if (!this.isExpanded(new TreePath(defaultMutableTreeNode.getPath()))) {
            return n;
        }
        int n2 = Integer.MAX_VALUE;
        int n3 = defaultMutableTreeNode.getChildCount();
        for (int i = 0; i < n3; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            if (defaultMutableTreeNode2.isLeaf()) continue;
            n2 = Math.min(this.getMinLayerCountOfCollapseNode(defaultMutableTreeNode2, n + 1), n2);
        }
        return n2;
    }

    private void expandByOneStep(DefaultMutableTreeNode defaultMutableTreeNode, int n, int n2) {
        if (n > n2) {
            return;
        }
        this.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
        int n3 = defaultMutableTreeNode.getChildCount();
        for (int i = 0; i < n3; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            this.expandByOneStep(defaultMutableTreeNode2, n + 1, n2);
        }
    }

    public void collapseByOneStep() {
        int n = this.getMaxLayerCountOfExpandNode(this.m_root, 0);
        this.collapseByOneStep(this.m_root, 0, n - 1);
    }

    private int getMaxLayerCountOfExpandNode(DefaultMutableTreeNode defaultMutableTreeNode, int n) {
        if (this.isCollapsed(new TreePath(defaultMutableTreeNode.getPath()))) {
            return n;
        }
        int n2 = Integer.MIN_VALUE;
        int n3 = defaultMutableTreeNode.getChildCount();
        for (int i = 0; i < n3; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            n2 = Math.max(this.getMaxLayerCountOfExpandNode(defaultMutableTreeNode2, n + 1), n2);
        }
        return n2;
    }

    private void collapseByOneStep(DefaultMutableTreeNode defaultMutableTreeNode, int n, int n2) {
        if (n >= n2) {
            TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
            if (!this.isCollapsed(treePath)) {
                this.collapsePath(treePath);
            }
            return;
        }
        int n3 = defaultMutableTreeNode.getChildCount();
        for (int i = 0; i < n3; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            if (defaultMutableTreeNode2.isLeaf()) continue;
            this.collapseByOneStep(defaultMutableTreeNode2, n + 1, n2);
        }
    }

    @Override
    public Point getToolTipLocation(MouseEvent mouseEvent) {
        return new Point(mouseEvent.getX(), mouseEvent.getY() + 20);
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        TreePath treePath = this.getClosestPathForLocation(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
        if (treePath == null) {
            return null;
        }
        TaxonomyTreeNode taxonomyTreeNode = (TaxonomyTreeNode)treePath.getLastPathComponent();
        if (taxonomyTreeNode.isGenome()) {
            String string = taxonomyTreeNode.getAbbreviation();
            if (StringTool.isNull(string)) {
                return null;
            }
            Organism organism = ModifiedOrganismManager.getInstance().getModifiedOrganism(string);
            if (organism != null) {
                return organism.getToolTipString();
            }
            Organism organism2 = OrganismUtil.getOrganism(string);
            return organism2.getToolTipString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<HTML>");
        stringBuffer.append(taxonomyTreeNode.getName());
        stringBuffer.append("</HTML>");
        return stringBuffer.toString();
    }
}

