/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy.map;

import cgdp.recog.data.ClusterTbl;
import cgdp.recog.funccat.FuncCat;
import cgdp.recog.funccat.FuncCatTbl;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.taxonomy.map.AbstractTaxMapGraphCreater;
import cgdp.recog.taxonomy.map.TaxMapFuncCatDataCreater;
import cgdp.recog.taxonomy.map.TaxMapModel;
import cgdp.recog.util.ColorUtil;
import java.util.List;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.data.category.DefaultCategoryDataset;

class FuncCatGraphCreater
extends AbstractTaxMapGraphCreater {
    FuncCatGraphCreater(TaxMapModel taxMapModel, ClusterTbl clusterTbl, AbstractInfoTitle abstractInfoTitle) {
        super(taxMapModel, clusterTbl, abstractInfoTitle);
    }

    @Override
    public JFreeChart createChart() {
        TaxMapFuncCatDataCreater taxMapFuncCatDataCreater = new TaxMapFuncCatDataCreater(this.taxMapModel, this.clusterTbl, this.infoTitle);
        DefaultCategoryDataset defaultCategoryDataset = taxMapFuncCatDataCreater.createDataset();
        JFreeChart jFreeChart = this.createStackBarChart(defaultCategoryDataset);
        FuncCatTbl funcCatTbl = FuncCatTbl.getInstance();
        List list = taxMapFuncCatDataCreater.getKeyList();
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        StackedBarRenderer stackedBarRenderer = (StackedBarRenderer)categoryPlot.getRenderer();
        for (String string : list) {
            FuncCat funcCat = funcCatTbl.getFuncCat(string);
            String string2 = string + " " + funcCat.getName();
            int n = defaultCategoryDataset.getRowIndex((Comparable)((Object)string2));
            stackedBarRenderer.setSeriesPaint(n, ColorUtil.str2Color(funcCat.getColor()).darker());
        }
        stackedBarRenderer.setMaximumBarWidth(0.1);
        return jFreeChart;
    }
}

