/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy.map;

import cgdp.recog.process.ProgressImpl;
import cgdp.recog.taxonomy.TaxFacade;
import cgdp.recog.taxonomy.TaxonomyTreeNode;
import cgdp.recog.taxonomy.map.AbstractRankScoreCalculater;
import cgdp.recog.taxonomy.map.TaxMapFacade;
import cgdp.recog.taxonomy.map.TaxMapInfo;
import cgdp.recog.taxonomy.map.TaxMapModel;
import cgdp.recog.util.StringTool;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

class RankGeneCountUpperCalculater
extends AbstractRankScoreCalculater {
    RankGeneCountUpperCalculater(List list, TaxMapModel taxMapModel) {
        super(list, taxMapModel);
    }

    @Override
    public void execute(ProgressImpl progressImpl) throws Exception {
        this.updateRankTaxMapInfo();
        this.setRankScoreMap(this.createRankScoreMap());
    }

    private void updateRankTaxMapInfo() throws IOException {
        Object object;
        TaxonomyTreeNode taxonomyTreeNode2;
        List list = TaxFacade.getDisplayTaxonomyTreeNodeList();
        HashMap<String, TaxonomyTreeNode> hashMap = new HashMap<String, TaxonomyTreeNode>();
        for (TaxonomyTreeNode taxonomyTreeNode2 : list) {
            object = TaxMapModel.getKeyName(taxonomyTreeNode2);
            hashMap.put((String)object, taxonomyTreeNode2);
        }
        TaxFacade.createTaxonomyTree(list, null);
        List list2 = TaxFacade.getTaxonomyTreeNodeList();
        taxonomyTreeNode2 = TaxMapFacade.createTargetTaxonomyTree(list2, this.taxMapModel.getTreeOrganismCodeSet(), this.taxMapModel);
        object = TaxFacade.getRankNameSet(taxonomyTreeNode2);
        List list3 = this.getTaxMapInfoListByAggregateType();
        ArrayList<TaxMapInfo> arrayList = new ArrayList<TaxMapInfo>();
        HashMap<Object, ArrayList<TaxMapInfo>> hashMap2 = new HashMap<Object, ArrayList<TaxMapInfo>>();
        for (TaxMapInfo taxMapInfo : list3) {
            TaxonomyTreeNode taxonomyTreeNode3 = (TaxonomyTreeNode)hashMap.get(taxMapInfo.getLowerName());
            TaxonomyTreeNode taxonomyTreeNode4 = (TaxonomyTreeNode)hashMap.get(taxMapInfo.getUpperName());
            if (StringTool.isNull(taxMapInfo.getUpperName())) {
                taxonomyTreeNode4 = taxonomyTreeNode2;
            }
            ArrayList<TaxMapInfo> arrayList2 = null;
            List list4 = this.getPath(taxonomyTreeNode3, taxonomyTreeNode4);
            for (Object object2 : list4) {
                String string = TaxMapModel.getKeyName((TaxonomyTreeNode)object2);
                if (!object.contains(string)) continue;
                arrayList2 = object2;
                break;
            }
            if (arrayList2 != null) {
                Object object2;
                String string = TaxMapModel.getKeyName(arrayList2);
                object2 = (List)hashMap2.get(string);
                if (object2 == null) {
                    object2 = new ArrayList<TaxMapInfo>();
                    hashMap2.put(string, (ArrayList<TaxMapInfo>)object2);
                }
                object2.add(taxMapInfo);
                continue;
            }
            arrayList.add(taxMapInfo);
        }
        this.setRankTaxMapInfoMap(hashMap2);
        this.setUnassignedTaxMapInfoList(arrayList);
    }

    private List getPath(TaxonomyTreeNode taxonomyTreeNode, TaxonomyTreeNode taxonomyTreeNode2) {
        List list = this.getNodeListOnPath(taxonomyTreeNode);
        List list2 = this.getNodeListOnPath(taxonomyTreeNode2);
        list.removeAll(list2);
        list.add(0, taxonomyTreeNode2);
        return list;
    }

    private List getNodeListOnPath(DefaultMutableTreeNode defaultMutableTreeNode) {
        TreeNode[] treeNodeArray = defaultMutableTreeNode.getPath();
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        for (int i = 0; i < treeNodeArray.length; ++i) {
            arrayList.add(treeNodeArray[i]);
        }
        return arrayList;
    }
}

