/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy.map;

import cgdp.recog.info.gene.GeneInfo;
import cgdp.recog.info.gene.GeneInfoRegister;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.info.gene.GeneInfoUtil;
import cgdp.recog.process.AbstractThreadProcess;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.taxonomy.map.TaxMapGenePropertyCreater2;
import cgdp.recog.taxonomy.map.TaxMapInfo;
import cgdp.recog.taxonomy.map.TaxMapModel;
import cgdp.recog.taxonomy.map.TaxMapPropertyCondition;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.GeneUtil;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.StringTool;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TaxMapGenePropertyCreater
extends AbstractThreadProcess {
    private static final ApplicationLogger logger = new ApplicationLogger(TaxMapGenePropertyCreater2.class);
    private Component parent;
    private TaxMapPropertyCondition condition;
    private TaxMapModel taxMapModel;

    public TaxMapGenePropertyCreater(Component component, TaxMapPropertyCondition taxMapPropertyCondition, TaxMapModel taxMapModel) {
        this.parent = component;
        this.condition = taxMapPropertyCondition;
        this.taxMapModel = taxMapModel;
    }

    @Override
    public void execute(ProgressImpl progressImpl) {
        try {
            progressImpl.setTotal(3);
            Set set = this.createGeneInfoSet();
            if (progressImpl.isCanceled()) {
                this.setCancel(true);
                return;
            }
            progressImpl.increment();
            GeneInfoTitle geneInfoTitle = (GeneInfoTitle)this.condition.getInfoTitle();
            ArrayList<GeneInfoTitle> arrayList = new ArrayList<GeneInfoTitle>();
            arrayList.add(GeneInfoTitle.TITLE_ORGANISM_CODE);
            arrayList.add(GeneInfoTitle.TITLE_LOCUSTAG_SERVER);
            arrayList.add(geneInfoTitle);
            progressImpl.increment();
            Map map = GeneInfoUtil.createOrganismCodeGeneInfoListMap(set);
            geneInfoTitle.addAllOrganismCode(map.keySet());
            GeneInfoRegister.saveGeneInfo(geneInfoTitle.getLocationName(), arrayList, map);
            progressImpl.increment();
        }
        catch (Exception exception) {
            String string = "Fail to save core gene's property.";
            logger.warn(string, exception);
            this.setError(true);
            this.setErrorMessage(string);
        }
    }

    private Set createGeneInfoSet() {
        HashMap<String, GeneInfo> hashMap = new HashMap<String, GeneInfo>();
        List list = this.taxMapModel.getTaxMapInfoList();
        for (TaxMapInfo taxMapInfo : list) {
            String string;
            List list2;
            String string2;
            String string3 = taxMapInfo.getOrganismCode();
            String string4 = GeneUtil.createOrganismLocusTagKey(string3, string2 = GeneUtil.removeDomainNo(taxMapInfo.getLocusTag()));
            GeneInfo geneInfo = (GeneInfo)hashMap.get(string4);
            if (geneInfo == null) {
                geneInfo = new GeneInfo();
                geneInfo.putInfo(GeneInfoTitle.TITLE_ORGANISM_CODE, string3);
                geneInfo.putInfo(GeneInfoTitle.TITLE_LOCUSTAG_SERVER, string2);
                hashMap.put(string4, geneInfo);
            }
            if (!(list2 = geneInfo.getMultiInfo(this.condition.getInfoTitle())).contains(string = this.getMappingRankName(taxMapInfo))) {
                list2.add(string);
            }
            geneInfo.putMultiInfo(this.condition.getInfoTitle(), list2);
        }
        return new HashSet(hashMap.values());
    }

    private String getMappingRankName(TaxMapInfo taxMapInfo) {
        String string;
        if (this.condition.isTargetLower()) {
            string = taxMapInfo.getLowerName();
        } else {
            String string2 = taxMapInfo.getUpperName();
            if (StringTool.isNull(string2)) {
                string2 = "root";
            }
            string = string2;
        }
        return this.taxMapModel.getDisplayOrganismName(string);
    }

    @Override
    public void done() {
        if (this.isCancel()) {
            return;
        }
        if (this.isError()) {
            MessageManager.showErrorMessage(this.parent, this.getErrorMessages());
            return;
        }
    }
}

