/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy.map;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.observer.ApplicationObserverEvent;
import cgdp.recog.taxonomy.TaxonomyTreeNode;
import cgdp.recog.taxonomy.map.RankChangeEvent;
import cgdp.recog.taxonomy.map.TaxMapFacade;
import cgdp.recog.taxonomy.map.TaxMapModel;
import cgdp.recog.taxonomy.map.TaxMapUtil;
import cgdp.recog.util.CollectionUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

class TaxMapGraphHelper {
    private Component component;
    private MediatorImpl mediator;
    private TaxMapModel taxMapModel;

    TaxMapGraphHelper(Component component, MediatorImpl mediatorImpl) {
        this.component = component;
        this.mediator = mediatorImpl;
    }

    void setTaxMapModel(TaxMapModel taxMapModel) {
        this.taxMapModel = taxMapModel;
    }

    void clickRankName(String string) {
        Object object;
        if (string.equals("No hits")) {
            string = "nohits";
        }
        if (this.taxMapModel.isOtherName(string)) {
            object = this.taxMapModel.getOtherTaxonomyTreeNodeSet();
            this.taxMapModel.setSelectNodeList(new ArrayList(object));
        } else if (this.taxMapModel.isUnassignedName(string)) {
            object = TaxMapModel.createUnassingedNode();
            this.taxMapModel.setSelectNode((TaxonomyTreeNode)object);
        } else {
            object = this.taxMapModel.getTaxonomyTreeNode(string);
            this.taxMapModel.setSelectNode((TaxonomyTreeNode)object);
        }
        object = new RankChangeEvent(this.component);
        this.taxMapModel.nodifyObservers((ApplicationObserverEvent)object);
        List list = this.taxMapModel.getSelectedTaxMapInfoList();
        if (!CollectionUtil.isNull(list)) {
            if (this.taxMapModel.isSyncPPMFilter()) {
                List list2 = TaxMapUtil.createGeneInfoList(list);
                this.mediator.setTaxMapFilter(list2);
            }
            if (this.taxMapModel.isSyncPPMSelect()) {
                TaxMapFacade.selectClusterOnPPM(list, this.mediator);
            }
        }
    }
}

