/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy.map;

import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.taxonomy.map.TaxMapGraphTextDataCreater;
import cgdp.recog.taxonomy.map.TaxMapModel;
import cgdp.recog.util.AbstractFileExporter;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FileUtil;
import org.jfree.data.category.DefaultCategoryDataset;

class TaxMapGraphTextDataExporter
extends AbstractFileExporter {
    private static final ApplicationLogger logger = new ApplicationLogger(TaxMapGraphTextDataExporter.class);
    private static final String DELIMITER = "\t";
    private TaxMapModel taxMapModel;
    private AbstractInfoTitle infoTitle;

    TaxMapGraphTextDataExporter(TaxMapModel taxMapModel, AbstractInfoTitle abstractInfoTitle) {
        this.taxMapModel = taxMapModel;
        this.infoTitle = abstractInfoTitle;
    }

    @Override
    protected String getContents() {
        try {
            Comparable comparable;
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = !this.taxMapModel.isExistSelectedNode();
            TaxMapGraphTextDataCreater taxMapGraphTextDataCreater = new TaxMapGraphTextDataCreater(this.taxMapModel, this.infoTitle, bl);
            DefaultCategoryDataset defaultCategoryDataset = taxMapGraphTextDataCreater.createDataset();
            stringBuffer.append("Name");
            for (n = 0; n < defaultCategoryDataset.getRowCount(); ++n) {
                comparable = defaultCategoryDataset.getRowKey(n);
                stringBuffer.append(DELIMITER);
                stringBuffer.append(comparable);
            }
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            for (n = 0; n < defaultCategoryDataset.getColumnCount(); ++n) {
                comparable = defaultCategoryDataset.getColumnKey(n);
                stringBuffer.append(comparable);
                for (int i = 0; i < defaultCategoryDataset.getRowCount(); ++i) {
                    stringBuffer.append(DELIMITER);
                    stringBuffer.append(defaultCategoryDataset.getValue(i, n));
                }
                stringBuffer.append(FileUtil.LINE_SEPARETOR);
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            String string = "Fail to export property graph data.";
            logger.warn(string, exception);
            return "";
        }
    }
}

