/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.update;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.DataManager;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.option.OptionValues;
import cgdp.recog.server.AccessServer;
import cgdp.recog.server.ServerTbl;
import cgdp.recog.update.ClientServerVersionUpTask;
import cgdp.recog.update.ClientVersionDownloader;
import cgdp.recog.update.DataVersionExporter;
import cgdp.recog.update.DataVersionImporter;
import cgdp.recog.update.DataVersionUpTask;
import cgdp.recog.update.SysInfo;
import cgdp.recog.update.SysInfoDownloader;
import cgdp.recog.update.UpdateCheckTask;
import cgdp.recog.update.VersionComparator;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.StringTool;
import java.awt.Frame;
import java.io.IOException;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;

public class UpdateCheckExecuter {
    private static final ApplicationLogger logger = new ApplicationLogger(UpdateCheckExecuter.class);
    private static final long DEFAULT_UPDATE_CHECK_INTERVAL = 5000L;
    private Frame parent;
    private MediatorImpl mediator;
    private TimerTask updateCheckTask;
    private Timer timer;
    private long updateCheckInterval = 5000L;
    private boolean enableAccessServer = true;
    private boolean stock = true;
    private boolean continuation = true;
    private boolean debug = false;

    protected UpdateCheckExecuter(Frame frame, MediatorImpl mediatorImpl) {
        this.parent = frame;
        this.mediator = mediatorImpl;
        this.timer = new Timer();
        this.updateCheckInterval = OptionTbl.getInstance().getOptionValues().getUpdateCheckInterval();
        if (this.isDebug()) {
            this.updateCheckInterval = 5000L;
        }
    }

    public static UpdateCheckExecuter createContinuationUpdateCheckExecuter(Frame frame, MediatorImpl mediatorImpl) {
        UpdateCheckExecuter updateCheckExecuter = new UpdateCheckExecuter(frame, mediatorImpl);
        return updateCheckExecuter;
    }

    public static UpdateCheckExecuter createSimpleUpdateCheckExecuter(Frame frame, MediatorImpl mediatorImpl) {
        UpdateCheckExecuter updateCheckExecuter = new UpdateCheckExecuter(frame, mediatorImpl);
        updateCheckExecuter.setContinuation(false);
        return updateCheckExecuter;
    }

    public void setStock(boolean bl) {
        this.stock = bl;
    }

    private boolean isStock() {
        return this.stock;
    }

    private void setContinuation(boolean bl) {
        this.continuation = bl;
    }

    public boolean isContinuation() {
        return this.continuation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws IOException {
        if (!this.enableAccessServer) {
            return;
        }
        try {
            Object object;
            OptionValues optionValues = OptionTbl.getInstance().getOptionValues();
            if (!optionValues.isShowVersionUp()) {
                return;
            }
            Properties properties = this.getSysInfoProperties(ServerTbl.getDefaultServerHost());
            Properties properties2 = this.getSysInfoProperties(AccessServer.getInstance().getServerUrl());
            SysInfo sysInfo = SysInfo.getInstance();
            String string = "1.1.28";
            String string2 = this.getNewClientVersion();
            boolean bl = false;
            if (!StringTool.isNull(string2) && !sysInfo.isFinishedInfoClientVersion(string2)) {
                bl = this.isUpdateVersion(string, string2);
            }
            boolean bl2 = false;
            String string3 = null;
            String string4 = properties.getProperty("ver-server");
            if (!sysInfo.isFinishedInfoServerVersion(string4) && !AccessServer.getInstance().isGlobalServerOnSelectedProject()) {
                string3 = properties2.getProperty("ver-server");
                bl2 = this.isUpdateVersion(string3, string4);
            }
            String string5 = DataManager.getDataVersionFilepath();
            DataVersionImporter dataVersionImporter = new DataVersionImporter(string5);
            String string6 = properties2.getProperty("ver-data");
            boolean bl3 = false;
            if (dataVersionImporter.isExistVersionFile()) {
                dataVersionImporter.execute();
                String string7 = dataVersionImporter.getDataVersion();
                if (!sysInfo.isFinishedInfoDataVersion(string6)) {
                    bl3 = this.isUpdateVersion(string7, string6);
                }
            } else if (!StringTool.isNull(string6)) {
                object = new DataVersionExporter(string6, string5);
                ((DataVersionExporter)object).execute();
            }
            if (!(bl || bl2 || bl3)) {
                return;
            }
            if (bl || bl2) {
                object = bl ? string2 : null;
                String string8 = bl2 ? string4 : null;
                ClientServerVersionUpTask clientServerVersionUpTask = new ClientServerVersionUpTask(this.parent, this.mediator, (String)object, string8);
                this.registerNewSystemInfo(clientServerVersionUpTask);
            }
            if (bl3) {
                object = new DataVersionUpTask(this.parent, this.mediator, string6);
                this.registerNewSystemInfo((Runnable)object);
            }
        }
        catch (Exception exception) {
            logger.warn("Fail to check application update.", exception);
            this.enableAccessServer = false;
        }
        finally {
            if (this.isContinuation()) {
                this.startUpdateCheckTask();
            }
        }
    }

    protected Properties getSysInfoProperties(String string) throws Exception {
        SysInfoDownloader sysInfoDownloader = new SysInfoDownloader(string);
        sysInfoDownloader.execute();
        Properties properties = sysInfoDownloader.getSysInfoProperties();
        return properties;
    }

    private String getNewClientVersion() {
        try {
            ClientVersionDownloader clientVersionDownloader = new ClientVersionDownloader();
            clientVersionDownloader.execute();
            return clientVersionDownloader.getClientVersion();
        }
        catch (Exception exception) {
            logger.warn("Fail to download clienet version.", exception);
            return null;
        }
    }

    private boolean isUpdateVersion(String string, String string2) {
        VersionComparator versionComparator = new VersionComparator();
        return versionComparator.compare(string, string2) > 0;
    }

    protected void registerNewSystemInfo(Runnable runnable) {
        if (this.isStock()) {
            this.mediator.registerNewSystemInfo(runnable);
        } else {
            runnable.run();
        }
    }

    private void startUpdateCheckTask() {
        this.updateCheckTask = new UpdateCheckTask(this);
        this.setStock(true);
        this.timer.schedule(this.updateCheckTask, this.updateCheckInterval);
    }

    public void setUpdateCheckInterval(long l) {
        this.updateCheckInterval = l;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    private boolean isDebug() {
        return this.debug;
    }
}

