/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.access;

import cgdp.recog.access.AbstractFileAccessExecuter;
import cgdp.recog.access.FileAccessType;
import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.ClusterUtil;
import cgdp.recog.process.ProcessImpl;
import cgdp.recog.process.ProgressDialog;
import cgdp.recog.set.gene.GeneSet;
import cgdp.recog.set.gene.GeneSetImportDialog;
import cgdp.recog.set.gene.GeneSetRegister;
import java.awt.Component;
import java.util.Collection;
import java.util.List;

public class GeneSetImportExecuter
extends AbstractFileAccessExecuter {
    private int importType;
    private List geneInfoList;
    private GeneSet geneSet;

    GeneSetImportExecuter(Component component, MediatorImpl mediatorImpl, String string, int n) {
        this(component, mediatorImpl, string, null, n);
    }

    GeneSetImportExecuter(Component component, MediatorImpl mediatorImpl, String string, GeneSet geneSet, int n) {
        super(component, mediatorImpl, string);
        this.importType = n;
        this.geneSet = geneSet;
    }

    void registerGeneInfoList(List list, Collection collection) {
        this.geneInfoList = ClusterUtil.getGeneInfoList(list, collection);
    }

    void setGeneInfoList(List list) {
        this.geneInfoList = list;
    }

    @Override
    int getAccessType() {
        return this.importType;
    }

    @Override
    public void execute() throws Exception {
        if (FileAccessType.isRegisterByFile(this.getAccessType())) {
            this.executeForNewSetFromFile();
        } else if (FileAccessType.isRegisterByClusterList(this.getAccessType())) {
            this.executeForNewSetFromCluster();
        } else if (FileAccessType.isAddElement(this.getAccessType())) {
            this.executeForAddCluster();
        } else if (FileAccessType.isRegisterByGeneInfo(this.getAccessType())) {
            this.executeByGeneInfo();
        }
    }

    private void executeForNewSetFromFile() {
        GeneSetImportDialog geneSetImportDialog = GeneSetImportDialog.getInstanse(this.parent);
        geneSetImportDialog.updateValue(this.location, !FileAccessType.isRegisterByClusterList(this.getAccessType()));
        geneSetImportDialog.setVisible(true);
        if (geneSetImportDialog.isCanceled()) {
            return;
        }
        GeneSet geneSet = geneSetImportDialog.createGeneSet();
        String string = geneSetImportDialog.getFilepath();
        GeneSetRegister geneSetRegister = new GeneSetRegister(this.parent, geneSet, string){

            @Override
            public void done() {
                GeneSetImportExecuter.this.mediator.updateGeneSetTree();
            }
        };
        ProgressDialog.executeProgress(this.parent, this.mediator, 100, "Register gene set...", false, (ProcessImpl)geneSetRegister);
    }

    private void executeForNewSetFromCluster() {
        GeneSetImportDialog geneSetImportDialog = GeneSetImportDialog.getInstanse(this.parent);
        geneSetImportDialog.updateValue(this.location, !FileAccessType.isRegisterByClusterList(this.getAccessType()));
        geneSetImportDialog.setVisible(true);
        if (geneSetImportDialog.isCanceled()) {
            return;
        }
        GeneSet geneSet = geneSetImportDialog.createGeneSet();
        GeneSetRegister geneSetRegister = new GeneSetRegister(this.parent, geneSet, this.geneInfoList){

            @Override
            public void done() {
                GeneSetImportExecuter.this.mediator.updateGeneSetTree();
            }
        };
        ProgressDialog.executeProgress(this.parent, this.mediator, 100, "Register gene set...", false, (ProcessImpl)geneSetRegister);
    }

    private void executeForAddCluster() {
        this.geneSet.addAddList();
        GeneSetRegister geneSetRegister = new GeneSetRegister(this.parent, this.geneSet, this.geneInfoList){

            @Override
            public void done() {
                GeneSetImportExecuter.this.mediator.updateGeneSetTree();
            }
        };
        ProgressDialog.executeProgress(this.parent, this.mediator, 100, "Register gene set...", false, (ProcessImpl)geneSetRegister);
    }

    private void executeByGeneInfo() {
        GeneSetImportDialog geneSetImportDialog = GeneSetImportDialog.getInstanse(this.parent);
        geneSetImportDialog.updateValue(this.location, !FileAccessType.isRegisterByGeneInfo(this.getAccessType()));
        geneSetImportDialog.setVisible(true);
        if (geneSetImportDialog.isCanceled()) {
            return;
        }
        GeneSet geneSet = geneSetImportDialog.createGeneSet();
        GeneSetRegister geneSetRegister = new GeneSetRegister(this.parent, geneSet, this.geneInfoList){

            @Override
            public void done() {
                GeneSetImportExecuter.this.mediator.updateGeneSetTree();
            }
        };
        ProgressDialog.executeProgress(this.parent, this.mediator, 100, "Register gene set...", false, (ProcessImpl)geneSetRegister);
    }
}

