/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.align;

import cgdp.recog.align.GlobalAlignElement;
import cgdp.recog.align.GlobalAlignType;
import cgdp.recog.coregenome.OrthologGroup;
import cgdp.recog.data.Cluster;
import cgdp.recog.data.Gene;
import cgdp.recog.organism.Organism;
import cgdp.recog.util.GeneUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class GlobalAlignGroup
implements Cloneable {
    private OrthologGroup orthologGroup;
    private Cluster cluster;
    private int globalAlignType;
    private Map organismElementMap = new HashMap();
    private GlobalAlignGroup globalAlignGroup;
    private boolean universal;
    private boolean unique;
    private boolean oneToOne;

    GlobalAlignGroup() {
    }

    int getGlobalAlignType() {
        return this.globalAlignType;
    }

    void setGlobalAlignType(int n) {
        this.globalAlignType = n;
    }

    GlobalAlignGroup getGlobalAlignGroup() {
        return this.globalAlignGroup;
    }

    void setGlobalAlignGroup(GlobalAlignGroup globalAlignGroup) {
        this.globalAlignGroup = globalAlignGroup;
    }

    boolean isExistGlobalAlignGroup() {
        return this.getGlobalAlignGroup() != null;
    }

    Set getGlobalAlignGroupSet() {
        HashSet<GlobalAlignGroup> hashSet = new HashSet<GlobalAlignGroup>();
        hashSet.add(this);
        GlobalAlignGroup globalAlignGroup = this.getGlobalAlignGroup();
        if (globalAlignGroup != null) {
            hashSet.add(globalAlignGroup);
        }
        return hashSet;
    }

    String getOrthologGroupId() {
        return this.orthologGroup.getOrthologGroupId();
    }

    void setOrthologGroup(OrthologGroup orthologGroup) {
        this.orthologGroup = orthologGroup;
    }

    OrthologGroup getOrthologGroup() {
        return this.orthologGroup;
    }

    boolean isExistOrthologGroup() {
        return this.orthologGroup != null;
    }

    boolean isExistCluster() {
        return this.cluster != null;
    }

    Cluster getCluster() {
        return this.cluster;
    }

    void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }

    String getConbineClusterId() {
        return this.getCluster().getConbinedClusterId();
    }

    void putElementList(String string, List list) {
        this.organismElementMap.put(string, list);
    }

    private void addElementList(String string, List list) {
        List list2 = (List)this.organismElementMap.get(string);
        if (list2 == null) {
            this.organismElementMap.put(string, list);
        } else {
            list2.addAll(list);
        }
    }

    private Set getOrganismCodeSet() {
        return this.organismElementMap.keySet();
    }

    Set getAlignElementSet() {
        HashSet hashSet = new HashSet();
        for (List list : this.organismElementMap.values()) {
            hashSet.addAll(list);
        }
        return hashSet;
    }

    List getGlobalElementList(String string) {
        return (List)this.organismElementMap.get(string);
    }

    List getAlignElementList(String string) {
        List list = (List)this.organismElementMap.get(string);
        if (list == null) {
            return new ArrayList();
        }
        return list;
    }

    GlobalAlignElement getMinPositionAlignGroup(String string) {
        List list = this.getGlobalElementList(string);
        if (list == null) {
            return null;
        }
        GlobalAlignElement globalAlignElement = null;
        for (GlobalAlignElement globalAlignElement2 : list) {
            if (globalAlignElement == null) {
                globalAlignElement = globalAlignElement2;
            }
            if (!(globalAlignElement.getPosition() > globalAlignElement2.getPosition())) continue;
            globalAlignElement = globalAlignElement2;
        }
        return globalAlignElement;
    }

    static GlobalAlignGroup createAlignGroup(List list, OrthologGroup orthologGroup) {
        GlobalAlignGroup globalAlignGroup = new GlobalAlignGroup();
        globalAlignGroup.setGlobalAlignType(1);
        globalAlignGroup.setCluster(orthologGroup.getCluster());
        globalAlignGroup.setOrthologGroup(orthologGroup);
        for (Organism organism : list) {
            List list2 = orthologGroup.getLocusTagList(organism.getOrganismCode());
            if (list2 == null) continue;
            ArrayList<GlobalAlignElement> arrayList = new ArrayList<GlobalAlignElement>();
            for (String string : list2) {
                GlobalAlignElement globalAlignElement = new GlobalAlignElement();
                globalAlignElement.setOrganism(organism);
                globalAlignElement.setLocusTag(string);
                globalAlignElement.setGlobalAlignGroup(globalAlignGroup);
                arrayList.add(globalAlignElement);
            }
            globalAlignGroup.putElementList(organism.getOrganismCode(), arrayList);
        }
        return globalAlignGroup;
    }

    private static boolean registerNonCoreElement(List list, Cluster cluster, GlobalAlignGroup globalAlignGroup, Collection collection) {
        boolean bl = false;
        for (Organism organism : list) {
            List list2 = cluster.getLocusTagList(organism.getOrganismCode());
            if (list2 == null) continue;
            ArrayList<GlobalAlignElement> arrayList = new ArrayList<GlobalAlignElement>();
            for (String string : list2) {
                String string2 = GeneUtil.createOrganismLocusTagKey(organism.getOrganismCode(), string);
                if (collection != null && collection.contains(string2)) continue;
                GlobalAlignElement globalAlignElement = new GlobalAlignElement();
                globalAlignElement.setOrganism(organism);
                globalAlignElement.setLocusTag(string);
                globalAlignElement.setGlobalAlignGroup(globalAlignGroup);
                arrayList.add(globalAlignElement);
            }
            if (arrayList.isEmpty()) continue;
            globalAlignGroup.putElementList(organism.getOrganismCode(), arrayList);
            bl = true;
        }
        return bl;
    }

    static GlobalAlignGroup createNonCoreAlignGroup(List list, Cluster cluster, GlobalAlignGroup globalAlignGroup, Set set) {
        boolean bl;
        GlobalAlignGroup globalAlignGroup2 = new GlobalAlignGroup();
        globalAlignGroup2.setGlobalAlignType(2);
        globalAlignGroup2.setGlobalAlignGroup(globalAlignGroup);
        if (globalAlignGroup != null) {
            globalAlignGroup.setGlobalAlignGroup(globalAlignGroup2);
        }
        globalAlignGroup2.setCluster(cluster);
        HashSet hashSet = new HashSet(set);
        if (globalAlignGroup != null) {
            hashSet.addAll(globalAlignGroup.getOrganismLocusTagKeySet());
        }
        if (bl = GlobalAlignGroup.registerNonCoreElement(list, cluster, globalAlignGroup2, hashSet)) {
            return globalAlignGroup2;
        }
        return null;
    }

    static GlobalAlignGroup createRnaAlignGroup(Organism organism, Gene gene) {
        if (gene == null) {
            return null;
        }
        GlobalAlignGroup globalAlignGroup = new GlobalAlignGroup();
        globalAlignGroup.setGlobalAlignType(3);
        ArrayList<GlobalAlignElement> arrayList = new ArrayList<GlobalAlignElement>();
        GlobalAlignElement globalAlignElement = new GlobalAlignElement();
        globalAlignElement.setOrganism(organism);
        globalAlignElement.setLocusTag(gene.getLocusTagWithDomainNo());
        globalAlignElement.setGlobalAlignGroup(globalAlignGroup);
        arrayList.add(globalAlignElement);
        globalAlignGroup.putElementList(organism.getOrganismCode(), arrayList);
        return globalAlignGroup;
    }

    static GlobalAlignGroup createComplementAlignGroup(GlobalAlignElement globalAlignElement) {
        GlobalAlignGroup globalAlignGroup = new GlobalAlignGroup();
        globalAlignGroup.setGlobalAlignType(2);
        ArrayList<GlobalAlignElement> arrayList = new ArrayList<GlobalAlignElement>();
        globalAlignElement.setGlobalAlignGroup(globalAlignGroup);
        arrayList.add(globalAlignElement);
        globalAlignGroup.putElementList(globalAlignElement.getOrganismCode(), arrayList);
        return globalAlignGroup;
    }

    boolean containsOrganism(String string) {
        return this.organismElementMap.containsKey(string);
    }

    boolean isUniversal() {
        return this.universal;
    }

    private void setUniversal(boolean bl) {
        this.universal = bl;
    }

    private boolean isUniversal(Collection collection, Map map) {
        if (collection.size() > map.size()) {
            return false;
        }
        return map.keySet().containsAll(collection);
    }

    private void updateUniversal(Collection collection) {
        this.setUniversal(this.isUniversal(collection, this.organismElementMap));
    }

    boolean isOneToOne() {
        return this.oneToOne;
    }

    private void setOneToOne(boolean bl) {
        this.oneToOne = bl;
    }

    private static boolean isOneToOne(Collection collection, Map map) {
        for (String string : collection) {
            List list = (List)map.get(string);
            if (list == null || list.size() <= 1) continue;
            return false;
        }
        return true;
    }

    private void updateOneToOne(Collection collection) {
        this.setOneToOne(GlobalAlignGroup.isOneToOne(collection, this.organismElementMap));
    }

    boolean isUnique() {
        return this.unique;
    }

    private void setUnique(boolean bl) {
        this.unique = bl;
    }

    private static boolean isUnique(Collection collection, Map map) {
        int n = 0;
        for (String string : collection) {
            List list = (List)map.get(string);
            if (list == null || (n += list.size()) <= 1) continue;
            return false;
        }
        return n == 1;
    }

    private void updateUnique(Collection collection) {
        boolean bl = GlobalAlignGroup.isUnique(collection, this.organismElementMap);
        if (this.getGlobalAlignGroup() != null) {
            bl &= GlobalAlignGroup.isUnique(collection, this.getGlobalAlignGroup().organismElementMap);
        }
        this.setUnique(bl);
    }

    void updateStatus(Collection collection) {
        this.updateUniversal(collection);
        this.updateOneToOne(collection);
        this.updateUnique(collection);
    }

    List getLocusTagListWithoutDomain(String string) {
        List list = this.getAlignElementList(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (GlobalAlignElement globalAlignElement : list) {
            String string2 = globalAlignElement.getLocusTagWithoutDomain();
            arrayList.add(string2);
        }
        return arrayList;
    }

    Set getOrganismLocusTagKeySet() {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : this.organismElementMap.keySet()) {
            List list = (List)this.organismElementMap.get(string);
            for (GlobalAlignElement globalAlignElement : list) {
                String string2 = GeneUtil.createOrganismLocusTagKey(string, globalAlignElement.getLocusTag());
                hashSet.add(string2);
            }
        }
        return hashSet;
    }

    boolean isCore() {
        return GlobalAlignType.isCore(this.getGlobalAlignType());
    }

    boolean isNonCore() {
        return GlobalAlignType.isNonCore(this.getGlobalAlignType());
    }

    boolean isRna() {
        return GlobalAlignType.isRna(this.getGlobalAlignType());
    }

    protected Object clone() {
        GlobalAlignGroup globalAlignGroup = new GlobalAlignGroup();
        globalAlignGroup.setGlobalAlignGroup(this.getGlobalAlignGroup());
        globalAlignGroup.setGlobalAlignType(this.getGlobalAlignType());
        globalAlignGroup.setOrthologGroup(this.getOrthologGroup());
        globalAlignGroup.setCluster(this.getCluster());
        globalAlignGroup.setUniversal(this.isUniversal());
        globalAlignGroup.setOneToOne(this.isOneToOne());
        globalAlignGroup.setUnique(this.isUnique());
        for (String string : this.getOrganismCodeSet()) {
            ArrayList arrayList = new ArrayList(this.getAlignElementList(string));
            globalAlignGroup.addElementList(string, arrayList);
        }
        return globalAlignGroup;
    }
}

