/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.align;

import cgdp.recog.align.GlobalAlign;
import cgdp.recog.align.GlobalAlignContext;
import cgdp.recog.align.GlobalAlignElement;
import cgdp.recog.align.GlobalAlignElementComparator;
import cgdp.recog.align.GlobalAlignElementLoopExecuter;
import cgdp.recog.align.GlobalAlignGroup;
import cgdp.recog.align.GlobalAlignRange;
import cgdp.recog.align.GlobalAlignViewModel;
import cgdp.recog.data.Chromosome;
import cgdp.recog.organism.Organism;
import cgdp.recog.organism.OrganismViewModel;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.MathUtil;
import cgdp.recog.util.Range;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class GlobalAlignPositionManager
implements Cloneable {
    private static final ApplicationLogger logger = new ApplicationLogger(GlobalAlignPositionManager.class);
    private static final String LABEL_ROW_KEY_POSITIVE = "positive";
    private static final String LABEL_ROW_KEY_NEGATIVE = "negative";
    private GlobalAlignViewModel globalAlignViewModel;
    private GlobalAlignContext globalAlignContext;
    private Map genomeLineStartPositionMap = new HashMap();
    private Map viewGlobalAlignElementListMap = new HashMap();

    GlobalAlignPositionManager(GlobalAlignViewModel globalAlignViewModel) {
        this.globalAlignViewModel = globalAlignViewModel;
        this.globalAlignContext = new GlobalAlignContext();
        this.globalAlignContext.setDrawEfficient(true);
    }

    void setGlobalAlignContext(GlobalAlignContext globalAlignContext) {
        this.globalAlignContext = globalAlignContext;
    }

    void setGlobalAlignViewModel(GlobalAlignViewModel globalAlignViewModel) {
        this.globalAlignViewModel = globalAlignViewModel;
    }

    double getScaleLength() {
        return MathUtil.getEfficientRound(this.getGlobalAlign().getMaxChromosomeLength(), 2);
    }

    private double getViewStartPosition(String string) {
        double d = this.getGlobalAlignViewModel().getStartPosition();
        Chromosome chromosome = this.getGlobalAlign().getMainChromosome(string);
        double d2 = chromosome.getLength();
        double d3 = this.getGlobalAlignViewModel().getCentralPosition(string, chromosome.getId());
        double d4 = this.getGlobalAlignViewModel().getCentralViewPosition(string, chromosome.getId());
        System.err.print(string + ": StartPos0=" + d + "," + d3);
        double d5 = d + d3;
        System.err.print("; StartPos1=" + d5);
        double d6 = this.getOffsetMainChromosomePosition(string);
        if (chromosome.isCircular()) {
            d5 = this.adjustPosition(d5, d2);
        }
        System.err.println(": StartPos3=" + d5);
        return d5;
    }

    private double getViewCentralPosition(GlobalAlignElement globalAlignElement) {
        String string = globalAlignElement.getOrganism().getOrganismCode();
        double d = this.getGlobalAlignViewModel().getStartPosition();
        Chromosome chromosome = this.getGlobalAlign().getMainChromosome(string);
        double d2 = chromosome.getLength();
        double d3 = this.getGlobalAlignViewModel().getCentralPosition(string, chromosome.getId());
        double d4 = d + d3;
        d4 += (double)(this.getDrawGenomeLength() / 2);
        return d4 += this.getGlobalAlignViewModel().getStartPosition();
    }

    Range getViewRange(String string) {
        Chromosome chromosome = this.getGlobalAlign().getMainChromosome(string);
        double d = chromosome.getLength();
        double d2 = this.getDrawGenomeLength();
        if (d2 > d) {
            d2 = d;
        }
        double d3 = this.getViewStartPosition(string);
        double d4 = d3 + d2;
        if (this.globalAlignViewModel.isReverseGenome(chromosome.getId())) {
            double d5 = d3;
            d3 = d4;
            d4 = d5;
        }
        if (chromosome.isCircular()) {
            if (d3 < 0.0) {
                d3 += d;
            } else if (d3 > d) {
                d3 -= d;
            }
            if (d4 < 0.0) {
                d4 += d;
            } else if (d4 > d) {
                d4 -= d;
            }
        }
        Range range = new Range((int)d3, (int)d4);
        return range;
    }

    private double getOffsetMainChromosomePosition(String string) {
        Chromosome chromosome = this.getGlobalAlign().getMainChromosome(string);
        if (chromosome.isCircular()) {
            return (this.getScaleLength() - (double)chromosome.getLength()) / 2.0;
        }
        return 0.0;
    }

    private double getReferenceChromosomeLength() {
        return this.getGlobalAlign().getMainChromosome(this.globalAlignViewModel.getReferenceOrganism().getOrganismCode()).getLength();
    }

    private double getReferenceChromosomeLengthAll() {
        List list = this.globalAlignViewModel.getGlobalAlign().getChromosomeList(this.globalAlignViewModel.getReferenceOrganism().getOrganismCode());
        double d = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            Chromosome chromosome = (Chromosome)list.get(i);
            d += (double)chromosome.getLength();
        }
        return d;
    }

    int getDrawGenomeLength() {
        return (int)(this.getScaleLength() / this.globalAlignViewModel.getZoomScale());
    }

    private Chromosome getReferenceChromosome() {
        Organism organism = this.globalAlignViewModel.getReferenceOrganism();
        return this.getGlobalAlign().getMainChromosome(organism.getOrganismCode());
    }

    private double getViewLengthForMove() {
        if (this.globalAlignViewModel.isAdjustMode()) {
            return this.getReferenceChromosomeLength();
        }
        return this.getScaleLength();
    }

    void moveLeft() {
        int n = (int)(this.globalAlignViewModel.getStartPosition() - (double)this.getMoveInterval());
        int n2 = (int)this.getViewLengthForMove();
        System.err.println("###START" + this.globalAlignViewModel.getStartPosition() + " " + n);
        if (n < -n2 / 2) {
            Chromosome chromosome = this.getReferenceChromosome();
            n = chromosome.isCircular() && this.globalAlignViewModel.isAdjustMode() ? (n += n2) : 0;
        }
        this.globalAlignViewModel.setStartPosition(n);
        System.err.println("******");
        System.err.println(this.globalAlignViewModel.isAdjustMode());
        if (this.globalAlignViewModel.isAdjustMode()) {
            this.changeCentralPositionForMove();
        }
    }

    void moveRight() {
        int n = (int)(this.globalAlignViewModel.getStartPosition() + (double)this.getMoveInterval());
        int n2 = (int)this.getViewLengthForMove();
        Chromosome chromosome = this.getReferenceChromosome();
        if (n > n2) {
            if (chromosome.isCircular() && this.globalAlignViewModel.isAdjustMode()) {
                n -= n2;
            }
        } else if (!(n <= n2 - this.getDrawGenomeLength() || chromosome.isCircular() && this.globalAlignViewModel.isAdjustMode())) {
            n = n2 - this.getDrawGenomeLength();
        }
        this.globalAlignViewModel.setStartPosition(n);
        if (this.globalAlignViewModel.isAdjustMode()) {
            this.changeCentralPositionForMove();
        }
    }

    void moveCenter(Set set) {
        Object object4;
        Object object2 = this.globalAlignViewModel.getReferenceOrganismCode();
        Object object3 = null;
        for (Object object4 : set) {
            List list = ((GlobalAlignGroup)object4).getAlignElementList((String)object2);
            if (CollectionUtil.isNull(list)) continue;
            object3 = object4;
            break;
        }
        if (object3 == null) {
            block1: for (Object object4 : this.getGlobalAlignViewModel().getViewOrganismCodeList()) {
                for (GlobalAlignGroup globalAlignGroup : set) {
                    List list = globalAlignGroup.getAlignElementList((String)object4);
                    if (CollectionUtil.isNull(list)) continue;
                    object3 = globalAlignGroup;
                    object2 = object4;
                    continue block1;
                }
            }
        }
        Iterator iterator = ((GlobalAlignGroup)object3).getAlignElementList((String)object2);
        object4 = (GlobalAlignElement)iterator.get(0);
        this.changeCentralPosition((GlobalAlignGroup)object3, (GlobalAlignElement)object4);
    }

    public void changeCentralPositionForMove() {
        this.globalAlignViewModel.setReverseChromIdSet(new HashSet());
        GlobalAlignElement globalAlignElement = this.getReferenceGenomeElementNearCenter();
        if (globalAlignElement != null) {
            this.changeCentralPosition(globalAlignElement.getGlobalAlignGroup(), globalAlignElement);
        }
    }

    private void changeCentralPositionForMove(GlobalAlignElement globalAlignElement) {
        System.err.println("#MOVE");
        if (globalAlignElement == null) {
            this.globalAlignViewModel.setReferneceGlobalAlignElement(null);
            this.globalAlignViewModel.setReferenceGlobalAlignGroup(null);
            this.reverseGenome();
            this.updateViewPosition();
            return;
        }
        this.globalAlignViewModel.setReferneceGlobalAlignElement(globalAlignElement);
        this.globalAlignViewModel.setReferenceGlobalAlignGroup(globalAlignElement.getGlobalAlignGroup());
        this.reverseGenome();
        Chromosome chromosome = this.getReferenceChromosome();
        GlobalAlignGroup globalAlignGroup = globalAlignElement.getGlobalAlignGroup();
        List list = this.globalAlignViewModel.getOrganismViewModel().getViewOrganismCodeList();
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            List list2 = globalAlignGroup.getAlignElementList(string);
            System.err.println("##ORG=>" + string);
            if (list2.isEmpty()) {
                System.err.println("SKIP");
                continue;
            }
            GlobalAlignElement globalAlignElement2 = (GlobalAlignElement)list2.get(0);
            Chromosome chromosome2 = this.getGlobalAlign().getChromosome(string, globalAlignElement2.getChromID());
            double d = globalAlignElement2.getPosition();
            double d2 = globalAlignElement2.getViewPosition() - globalAlignElement.getViewPosition();
            System.err.println("center0=" + d);
            if (chromosome2.isCircular()) {
                this.globalAlignViewModel.setCentralPosition(string, globalAlignElement2.getChromID(), d);
                continue;
            }
            this.setGenomeLineStartPosition(string, -d);
        }
        this.updateViewPosition();
    }

    private double modifyCenterPositionForIncludeView(double d, double d2) {
        double d3 = d;
        double d4 = this.getDrawGenomeLength();
        double d5 = this.globalAlignViewModel.getStartPosition();
        double d6 = this.globalAlignViewModel.getStartPosition() + d4 + this.globalAlignContext.calcLength(this.globalAlignContext.getMarginRight());
        double d7 = this.getReferenceChromosomeLength();
        double d8 = d2 - d3;
        if (d8 < d5) {
            int n = 0;
            while (d8 < d5) {
                d8 += d7;
                ++n;
            }
            if (d8 <= d6) {
                d3 -= d7 * (double)n;
            }
        } else if (d8 > d6) {
            int n = 0;
            while (d8 > d6) {
                d8 -= d7;
                ++n;
            }
            if (d8 >= d5) {
                d3 += d7 * (double)n;
            }
        }
        return d3;
    }

    void changeCentralPosition(GlobalAlignGroup globalAlignGroup, GlobalAlignElement globalAlignElement) {
        System.err.println("MOVECENTER0");
        this.globalAlignViewModel.setReferneceGlobalAlignElement(globalAlignElement);
        this.globalAlignViewModel.setReferenceGlobalAlignGroup(globalAlignGroup);
        this.globalAlignViewModel.setReferenceOrganism(globalAlignElement.getOrganism());
        List list = globalAlignGroup.getAlignElementList(this.globalAlignViewModel.getReferenceOrganism().getOrganismCode());
        if (CollectionUtil.isNull(list)) {
            System.err.println("**NO Ortholog**");
            this.reverseGenome();
            this.updateViewPosition();
            return;
        }
        GlobalAlignElement globalAlignElement2 = (GlobalAlignElement)list.get(0);
        double d = 0.0;
        System.err.println("MOVECENTER1");
        System.err.println("WindowWidth: " + this.getDrawGenomeLineLength());
        System.err.println("CenterPosInRefGenome: " + globalAlignElement2.getViewPosition());
        System.err.println("startpos: " + this.globalAlignViewModel.getStartPosition());
        System.err.println("shift: " + d);
        if (!this.globalAlignViewModel.isLeftCoordinate()) {
            double d2 = this.getReferenceChromosomeLengthAll();
            d -= (this.getScaleLength() - d2) / 2.0;
        }
        if (this.globalAlignViewModel.containsReverseChromId(globalAlignElement2.getChromID())) {
            d *= -1.0;
        }
        System.err.println("MOVECENTER2");
        System.err.println("shift=" + d);
        this.globalAlignViewModel.setStartPosition(-this.getDrawGenomeLineLength() / 2.0);
        this.reverseGenome();
        System.err.println("MOVECENTER3");
        Chromosome chromosome = this.getReferenceChromosome();
        List list2 = this.globalAlignViewModel.getOrganismViewModel().getViewOrganismCodeList();
        for (int i = 0; i < list2.size(); ++i) {
            String string = (String)list2.get(i);
            List list3 = globalAlignGroup.getAlignElementList(string);
            if (list3.isEmpty()) continue;
            GlobalAlignElement globalAlignElement3 = (GlobalAlignElement)list3.get(0);
            Chromosome chromosome2 = this.getGlobalAlign().getChromosome(string, globalAlignElement3.getChromID());
            double d3 = globalAlignElement3.getPosition();
            double d4 = globalAlignElement3.getViewPosition() - globalAlignElement2.getViewPosition();
            if (string.equals("HJ99") || string.equals("HSAf7") || string.equals("HB8")) {
                System.err.println("globAliElem.viewpos=" + globalAlignElement3.getViewPosition());
                System.err.println("globAliElem.pos=" + globalAlignElement3.getPosition());
                System.err.println("CC0:" + string + " " + d4);
                System.err.println("MMM: " + this.getGlobalAlignViewModel().getStartPosition() + " " + globalAlignElement2.getViewPosition());
            }
            if (chromosome2.isCircular() && !chromosome.isCircular()) {
                d4 += this.getReferenceChromosomeLength() / 2.0;
            } else if (!chromosome2.isCircular() && chromosome.isCircular()) {
                d4 -= this.getReferenceChromosomeLength() / 2.0;
            }
            if (this.globalAlignViewModel.isReferenceOrganism(string)) {
                d4 = 0.0;
            }
            if (chromosome2.isCircular() && !this.globalAlignViewModel.isChromCoordinate()) {
                d4 += ((double)this.getGlobalAlign().getChromosomeLengthByChromId(string, globalAlignElement3.getChromID()) - this.getReferenceChromosomeLength()) / 2.0;
            }
            if (chromosome2.isCircular()) {
                d4 += (double)(-chromosome2.getLength()) / 2.0;
            }
            System.err.println("globAliElem.pos2=" + globalAlignElement3.getViewPosition());
            System.err.println("CC3:" + string + " " + d4 + " " + d3 + " " + this.getGlobalAlignViewModel().getStartPosition() + " " + (d4 + this.getGlobalAlignViewModel().getStartPosition()));
            System.err.println(chromosome2.getLength() + " " + this.getGlobalAlign().getChromosomeLengthByChromId(string, globalAlignElement3.getChromID()));
            if (chromosome2.isCircular()) {
                this.globalAlignViewModel.setCentralPosition(string, globalAlignElement3.getChromID(), d3);
                continue;
            }
            this.setGenomeLineStartPosition(string, -d4);
        }
        System.err.println("****####\n");
        this.updateViewPosition();
    }

    private int getMoveInterval() {
        return this.getDrawGenomeLength() / 5;
    }

    void zoom(double d) {
        boolean bl = this.globalAlignViewModel.isSetZoomoutScale();
        double d2 = this.getDrawGenomeLength();
        this.globalAlignViewModel.setZoomScale(d);
        double d3 = this.getDrawGenomeLength();
        boolean bl2 = this.globalAlignViewModel.isSetZoomoutScale();
        this.globalAlignViewModel.updateDetailDisplay(d3, this.globalAlignContext.getDrawWidth());
        double d4 = (d2 - d3) / 2.0;
        double d5 = this.globalAlignViewModel.getStartPosition() + d4;
        this.globalAlignViewModel.setStartPosition(d5);
        this.changeCoordinateGenePositionByZoom(bl, bl2);
        if (d == 1.0) {
            // empty if block
        }
    }

    private void changeCoordinateGenePositionByZoom(boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4 = !bl && this.globalAlignViewModel.isAdjustMode();
        boolean bl5 = bl3 = !bl2 && this.globalAlignViewModel.isAdjustMode();
        if (!bl4 && !bl3) {
            return;
        }
        System.err.println("PPPP:" + bl + " " + bl2);
    }

    void changeCoordinateGenePositionByChangeAdjustMode(boolean bl) {
        if (!this.globalAlignViewModel.isSetZoomoutScale()) {
            return;
        }
        this.changeCoordinateGenePosition(bl);
    }

    private void changeCoordinateGenePosition(boolean bl) {
        Organism organism = this.globalAlignViewModel.getReferenceOrganism();
        Chromosome chromosome = this.getGlobalAlign().getMainChromosome(organism.getOrganismCode());
        double d = 0.0;
        GlobalAlignGroup globalAlignGroup = this.globalAlignViewModel.getReferenceGlobalAlignGroup();
        Map map = this.getReverseChromIdMap(globalAlignGroup);
        List list = this.globalAlignViewModel.getOrganismViewModel().getViewOrganismCodeList();
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            Chromosome chromosome2 = this.getGlobalAlign().getMainChromosome(string);
        }
        this.reverseGenome();
        this.updateViewPosition();
    }

    Map initLabelMaxXMap() {
        return this.initLabelMaxXMap(0.0);
    }

    Map initLabelMaxXMap(double d) {
        HashMap hashMap = new HashMap();
        for (Organism organism : this.getOrganismViewModel().getViewOrganismList()) {
            String string = this.createLabelRowKeyPositive(organism.getOrganismCode());
            String string2 = this.createLabelRowKeyNegative(organism.getOrganismCode());
            ArrayList<Double> arrayList = new ArrayList<Double>();
            ArrayList<Double> arrayList2 = new ArrayList<Double>();
            for (int i = 0; i < this.globalAlignViewModel.getMaxLabelRowCount(); ++i) {
                arrayList.add(new Double(d));
                arrayList2.add(new Double(d));
            }
            hashMap.put(string, arrayList);
            hashMap.put(string2, arrayList2);
        }
        return hashMap;
    }

    double getGenomeLineStartX_new(String string) {
        Chromosome chromosome = this.getGlobalAlign().getMainChromosome(string);
        int n = chromosome.getId();
        double d = chromosome.isCircular() ? (double)(-chromosome.getLength()) / 2.0 : (this.globalAlignViewModel.containsReverseChromId(n) ? -((double)chromosome.getLength() - this.globalAlignViewModel.getCentralPosition(string, n)) : -this.globalAlignViewModel.getCentralPosition(string, n));
        System.err.println("pos=" + d);
        return this.globalAlignContext.calcX(d);
    }

    double getGenomeLineStartX(String string) {
        Chromosome chromosome = this.getGlobalAlign().getMainChromosome(string);
        if (!chromosome.isCircular()) {
            return this.globalAlignContext.calcX(this.getGenomeLineStartPosition(string));
        }
        return 0.0;
    }

    Map getSelectableAreaMap() {
        final HashMap hashMap = new HashMap();
        GlobalAlignElementLoopExecuter globalAlignElementLoopExecuter = new GlobalAlignElementLoopExecuter(this){
            private List globalAlignRangeList;

            @Override
            protected void beforeGlobalAlignElement(Organism organism) {
                this.globalAlignRangeList = new ArrayList();
            }

            @Override
            protected boolean loopGlobalAlignElement(GlobalAlignElement globalAlignElement, int n, int n2) {
                GlobalAlignRange globalAlignRange = new GlobalAlignRange(n, n2, globalAlignElement);
                this.globalAlignRangeList.add(globalAlignRange);
                return true;
            }

            @Override
            protected void afterGlobalAlignElement(Organism organism) {
                hashMap.put(organism.getOrganismCode(), this.globalAlignRangeList);
            }
        };
        globalAlignElementLoopExecuter.setOffsetGenomeLineStartX(this.globalAlignContext.getAlignStartX());
        globalAlignElementLoopExecuter.execute();
        return hashMap;
    }

    double getGenomeLineOneSideLabelCount() {
        return this.globalAlignViewModel.getMaxLabelRowCount();
    }

    List calcGenomeLineStartY(FontMetrics fontMetrics) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        double d = this.getGenomeLineOneSideLabelCount();
        double d2 = this.getGeneHeightFromGenomeLine();
        List list = this.getOrganismViewModel().getViewOrganismList();
        double d3 = this.globalAlignContext.getGenomeLineStartY() + d2 + d * this.globalAlignContext.getLabelRowHeight();
        arrayList.add(new Double(d3));
        double d4 = this.getGenomeLineIntervalY();
        for (int i = 1; i < list.size(); ++i) {
            arrayList.add(new Double(d3 += d4));
        }
        return arrayList;
    }

    private double getGenomeLineIntervalY() {
        double d = this.getGenomeLineOneSideLabelCount();
        double d2 = this.getGeneHeightFromGenomeLine();
        return d2 * 2.0 + d * 2.0 * this.globalAlignContext.getLabelRowHeight() + this.globalAlignContext.getLabelToLabelMargin();
    }

    int indexOfOrganism(int n, boolean bl) {
        boolean bl2 = false;
        int n2 = 0;
        double d = this.getGenomeLineIntervalY() / 2.0;
        Iterator iterator = this.globalAlignContext.getGenomeLineStartYList().iterator();
        while (iterator.hasNext()) {
            double d2 = (Double)iterator.next();
            if ((double)n >= d2 - d && (double)n <= d2 + d) {
                bl2 = true;
                break;
            }
            if ((double)n < d2 - d) {
                n2 = -1;
                break;
            }
            ++n2;
        }
        if (bl2) {
            return n2;
        }
        return -1;
    }

    double getGeneHeightFromGenomeLine() {
        return this.globalAlignContext.getGeneHeightIncludeMargin() + this.globalAlignContext.getLabelMargin();
    }

    String createLabelRowKey(GlobalAlignElement globalAlignElement) {
        if (this.globalAlignViewModel.isViewAbstract()) {
            return this.createLabelRowKeyPositive(globalAlignElement.getOrganism().getOrganismCode());
        }
        if (globalAlignElement.isPositive()) {
            return this.createLabelRowKeyPositive(globalAlignElement.getOrganism().getOrganismCode());
        }
        return this.createLabelRowKeyNegative(globalAlignElement.getOrganism().getOrganismCode());
    }

    private String createLabelRowKeyPositive(String string) {
        return string + LABEL_ROW_KEY_POSITIVE;
    }

    private String createLabelRowKeyNegative(String string) {
        return string + LABEL_ROW_KEY_NEGATIVE;
    }

    int getGeneStartY(GlobalAlignElement globalAlignElement, double d) {
        int n = this.globalAlignViewModel.isViewAbstract() ? (int)(d - this.globalAlignContext.getGeneHeight() / 2.0) : (this.globalAlignViewModel.isDirectionPosition(globalAlignElement) ? (int)(d - this.globalAlignContext.getGeneHeightIncludeMargin()) : (int)(d + this.globalAlignContext.getGenomeLineGeneMargin()));
        return n;
    }

    double getDrawLimitLeft() {
        return this.getOffsetX();
    }

    double getDrawLimitRight() {
        return this.globalAlignContext.getAlignDrawWidth() + this.globalAlignContext.getMarginRight() + this.getOffsetX();
    }

    private double getDrawGenomeLineLength() {
        return this.getScaleLength() / this.globalAlignViewModel.getZoomScale();
    }

    private double getDrawCenteralGenomePosition() {
        return this.getDrawGenomeLineLength() / 2.0 + this.globalAlignViewModel.getStartPosition();
    }

    private double getDrawCenteralGenomePosition(GlobalAlignElement globalAlignElement) {
        return this.globalAlignViewModel.getCentralPosition(globalAlignElement.getOrganismCode(), globalAlignElement.getChromID());
    }

    static double adjustPointForIncludeDrawArea(double d, double d2, double d3) {
        double d4 = d;
        d4 = d4 < d2 ? (double)((int)d2) : d4;
        d4 = d4 > d3 ? (double)((int)d3) : d4;
        return d4;
    }

    static boolean containsRange(double d, double d2, double d3) {
        return d >= d2 && d <= d3;
    }

    double getOffsetX() {
        return this.globalAlignViewModel.getStartPosition() * this.globalAlignContext.getScaleX();
    }

    private double calcGenePositionForAdjustCentralPosition_Old(GlobalAlign globalAlign, GlobalAlignElement globalAlignElement, double d, double d2, boolean bl) {
        double d3;
        double d4;
        int n = 0;
        String string = globalAlignElement.getOrganism().getOrganismCode();
        Chromosome chromosome = globalAlign.getChromosome(string, globalAlignElement.getChromID());
        int n2 = chromosome.getLength();
        double d5 = d2 - d;
        if (d5 == 0.0) {
            n = 1;
            System.err.println("#>#" + globalAlignElement.getOrganism().getOrganismCode() + ": " + d2);
        }
        if (chromosome.isCircular() && this.globalAlignViewModel.isAdjustMode()) {
            d4 = this.getDrawGenomeLength();
            d3 = this.globalAlignViewModel.getStartPosition();
            double d6 = this.globalAlignViewModel.getStartPosition() + d4 + this.globalAlignContext.calcLength(this.globalAlignContext.getMarginRight());
            double d7 = chromosome.getLength();
            double d8 = d5;
            if (d7 == 0.0) {
                System.err.println(chromosome);
                d7 = 1.0;
            }
            if (Math.abs(d8) > d7) {
                d8 %= d7;
            }
            if (d5 < d3) {
                while (d8 < d3) {
                    d8 += d7;
                }
                if (d8 <= d6) {
                    d5 = d8;
                }
            } else if (d5 > d6) {
                while (d8 > d6) {
                    d8 -= d7;
                }
                if (d8 >= d3) {
                    d5 = d8;
                }
            }
            if (n > 0) {
                System.err.println("adjustPos: " + d5 + " " + d3 + " " + d6);
            }
        }
        d4 = d5;
        if (!chromosome.isCircular() || chromosome.isCircular() && this.globalAlignViewModel.isChromCoordinate()) {
            d3 = globalAlign.getChromosomeStartPosition(string, globalAlignElement.getChromID());
            d4 = d5 + d3;
            if (chromosome.isCircular()) {
                int n3 = globalAlign.getAllChromosomeLengthByOrganism(string);
                d4 += (double)(n3 - n2) / 2.0;
                d4 = this.adjustPosition(d4, n3);
            }
        }
        return d4;
    }

    private double calcGenePositionForAdjustCentralPosition(GlobalAlignElement globalAlignElement) {
        double d;
        double d2;
        int n = 0;
        String string = globalAlignElement.getOrganism().getOrganismCode();
        GlobalAlign globalAlign = this.getGlobalAlign();
        Chromosome chromosome = globalAlign.getChromosome(string, globalAlignElement.getChromID());
        int n2 = chromosome.getLength();
        double d3 = this.globalAlignViewModel.getCentralPosition(globalAlignElement.getOrganism().getOrganismCode(), globalAlignElement.getChromID());
        double d4 = this.globalAlignViewModel.getCentralViewPosition(globalAlignElement.getOrganism().getOrganismCode(), globalAlignElement.getChromID());
        double d5 = globalAlignElement.getPosition();
        double d6 = globalAlignElement.getViewPosition();
        boolean bl = this.globalAlignViewModel.isAdjustMode();
        double d7 = d5 - d3;
        if (d5 == d3) {
            n = 1;
            System.err.println("#>#" + globalAlignElement.getOrganism().getOrganismCode() + ": " + d5);
            System.err.println("adjustPos: " + d7 + " " + d5 + " >>" + d3);
        }
        if (chromosome.isCircular()) {
            d2 = this.getDrawGenomeLength();
            d = -n2 / 2;
            double d8 = n2 / 2;
            double d9 = chromosome.getLength();
            double d10 = d7;
            if (d9 == 0.0) {
                System.err.println(chromosome);
                d9 = 1.0;
            }
            if (Math.abs(d10) > d9) {
                d10 %= d9;
            }
            if (d7 < d) {
                while (d10 < d) {
                    d10 += d9;
                }
                if (d10 <= d8) {
                    d7 = d10;
                }
            } else if (d7 > d8) {
                while (d10 > d8) {
                    d10 -= d9;
                }
                if (d10 >= d) {
                    d7 = d10;
                }
            }
            if (n > 0) {
                System.err.println("adjustPos: " + globalAlignElement.getOrganism().getOrganismCode() + " " + d7 + " " + d + " " + d8 + " " + d9);
            }
        }
        d2 = d7;
        if (!chromosome.isCircular() || chromosome.isCircular() && this.globalAlignViewModel.isChromCoordinate()) {
            d = globalAlign.getChromosomeStartPosition(string, globalAlignElement.getChromID());
            d2 = d7 + d;
        }
        return d2;
    }

    private double adjustPosition(double d, double d2) {
        double d3 = d;
        if (d3 > d2) {
            d3 %= d2;
        }
        if (d3 < 0.0) {
            d3 = d2 + d3 % d2;
        }
        return d3;
    }

    OrganismViewModel getOrganismViewModel() {
        return this.globalAlignViewModel.getOrganismViewModel();
    }

    private GlobalAlign getGlobalAlign() {
        return this.globalAlignViewModel.getGlobalAlign();
    }

    GlobalAlignContext getGlobalAlignContext() {
        return this.globalAlignContext;
    }

    GlobalAlignViewModel getGlobalAlignViewModel() {
        return this.globalAlignViewModel;
    }

    private List getDrawGlobalAlignElementList(String string) {
        Range range = this.getViewRange(string);
        List list = this.getGlobalAlignViewModel().getViewGlobalAlignGroupList();
        List list2 = this.getGlobalAlignViewModel().getGlobalAlignElementList(string, list);
        Collections.sort(list2, new GlobalAlignElementComparator());
        if (range.getX1() == range.getX2()) {
            return list2;
        }
        ArrayList<GlobalAlignElement> arrayList = new ArrayList<GlobalAlignElement>();
        for (GlobalAlignElement globalAlignElement : list2) {
            if (range.getX1() <= range.getX2()) {
                if (!range.contains((int)globalAlignElement.getPosition())) continue;
                arrayList.add(globalAlignElement);
                continue;
            }
            if (range.contains((int)globalAlignElement.getPosition())) continue;
            arrayList.add(globalAlignElement);
        }
        return arrayList;
    }

    private GlobalAlignElement getReferenceGenomeElementNearCenter() {
        double d;
        double d2;
        Organism organism = this.globalAlignViewModel.getReferenceOrganism();
        String string = organism.getOrganismCode();
        GlobalAlignElement globalAlignElement = null;
        double d3 = Double.MAX_VALUE;
        List list = this.getDrawGlobalAlignElementList(string);
        if (list.isEmpty()) {
            return null;
        }
        Range range = this.getViewRange(string);
        boolean bl = range.getX1() > range.getX2();
        Chromosome chromosome = this.getGlobalAlign().getChromosome(string, ((GlobalAlignElement)list.get(0)).getChromID());
        double d4 = chromosome.getLength();
        if (bl) {
            double d5 = d4 - (double)range.getX1();
            d2 = range.getX2();
            d = (d5 + d2) / 2.0;
        } else {
            d = range.getCenter();
        }
        for (GlobalAlignElement globalAlignElement2 : list) {
            if (!this.globalAlignViewModel.isShowGene(globalAlignElement2.getGlobalAlignGroup()) || globalAlignElement2.getGlobalAlignGroup().isUnique()) continue;
            d2 = globalAlignElement2.getPosition();
            double d6 = bl ? (d2 >= (double)range.getX1() ? Math.abs(d - (d2 - (double)range.getX1())) : Math.abs(d - d2 - (d4 - (double)range.getX1()))) : Math.abs(d2 - d);
            if (!(d3 > d6)) continue;
            d3 = d6;
            globalAlignElement = globalAlignElement2;
        }
        if (logger.isDebugEnabled()) {
            logger.info("============ gene innformation near center ============");
            logger.info("centralGenomePosition : " + d);
            if (globalAlignElement != null) {
                logger.info("Center : " + globalAlignElement.getLocusTagWithoutDomain());
            } else {
                logger.info("Center : null");
            }
            logger.info("=======================================================");
        }
        return globalAlignElement;
    }

    void reverseGenome() {
        GlobalAlignGroup globalAlignGroup = this.globalAlignViewModel.getReferenceGlobalAlignGroup();
        Map map = this.getReverseChromIdMap(globalAlignGroup);
        this.globalAlignViewModel.updateReverseChromIdSet(map);
    }

    private Map getReverseChromIdMap(GlobalAlignGroup globalAlignGroup) {
        if (this.globalAlignViewModel.isDirArrangePositive()) {
            return this.getReverseChromIdMapByPositive(globalAlignGroup);
        }
        if (this.globalAlignViewModel.isDirArrangeConsensusOrtholog()) {
            return this.getReverseChromIdMapByOrthologConsensus(globalAlignGroup);
        }
        return this.getReverseChromIdMapByReferenceGenome(globalAlignGroup);
    }

    private Map getReverseChromIdMapByPositive(GlobalAlignGroup globalAlignGroup) {
        HashMap<Integer, Boolean> hashMap = new HashMap<Integer, Boolean>();
        if (globalAlignGroup == null) {
            return hashMap;
        }
        for (String string : this.globalAlignViewModel.getViewOrganismCodeList()) {
            List list = globalAlignGroup.getAlignElementList(string);
            if (CollectionUtil.isNull(list)) continue;
            GlobalAlignElement globalAlignElement = (GlobalAlignElement)list.get(0);
            if (globalAlignElement.isNegative()) {
                hashMap.put(new Integer(globalAlignElement.getChromID()), true);
                continue;
            }
            hashMap.put(new Integer(globalAlignElement.getChromID()), false);
        }
        return hashMap;
    }

    private Map getReverseChromIdMapByOrthologConsensus(GlobalAlignGroup globalAlignGroup) {
        HashMap<Integer, Boolean> hashMap = new HashMap<Integer, Boolean>();
        if (globalAlignGroup == null) {
            return hashMap;
        }
        GlobalAlignElement globalAlignElement = null;
        if (this.globalAlignViewModel.getReferneceGlobalAlignElement() != null) {
            globalAlignElement = this.globalAlignViewModel.getReferneceGlobalAlignElement();
        }
        for (String string : this.globalAlignViewModel.getViewOrganismCodeList()) {
            List list = globalAlignGroup.getAlignElementList(string);
            if (CollectionUtil.isNull(list)) continue;
            GlobalAlignElement globalAlignElement2 = (GlobalAlignElement)list.get(0);
            if (globalAlignGroup.isCore()) {
                if (!globalAlignElement2.equalsDirection(globalAlignGroup.getOrthologGroup().getDirection())) {
                    hashMap.put(new Integer(globalAlignElement2.getChromID()), true);
                    continue;
                }
                hashMap.put(new Integer(globalAlignElement2.getChromID()), false);
                continue;
            }
            System.err.println("!!******" + globalAlignElement2.getChromID());
            if (globalAlignElement2.getChromID() == 146) {
                System.err.println("####***" + globalAlignElement2.equalsDirection(globalAlignElement));
            }
            if (globalAlignElement == null || string.equals(this.globalAlignViewModel.getReferenceOrganismCode())) continue;
            if (!globalAlignElement2.equalsDirection(globalAlignElement)) {
                hashMap.put(new Integer(globalAlignElement2.getChromID()), true);
                continue;
            }
            hashMap.put(new Integer(globalAlignElement2.getChromID()), false);
        }
        return hashMap;
    }

    private Map getReverseChromIdMapByReferenceGenome(GlobalAlignGroup globalAlignGroup) {
        HashMap<Integer, Boolean> hashMap = new HashMap<Integer, Boolean>();
        if (globalAlignGroup == null) {
            return hashMap;
        }
        GlobalAlignElement globalAlignElement = this.getReferenceElement(globalAlignGroup);
        if (globalAlignElement == null) {
            return hashMap;
        }
        for (String string : this.globalAlignViewModel.getViewOrganismCodeList()) {
            List list = globalAlignGroup.getAlignElementList(string);
            if (CollectionUtil.isNull(list)) continue;
            GlobalAlignElement globalAlignElement2 = (GlobalAlignElement)list.get(0);
            if (!globalAlignElement2.equalsDirection(globalAlignElement)) {
                hashMap.put(new Integer(globalAlignElement2.getChromID()), true);
                continue;
            }
            hashMap.put(new Integer(globalAlignElement2.getChromID()), false);
        }
        return hashMap;
    }

    private GlobalAlignElement getReferenceElement(GlobalAlignGroup globalAlignGroup) {
        Organism organism = this.globalAlignViewModel.getReferenceOrganism();
        List list = globalAlignGroup.getAlignElementList(organism.getOrganismCode());
        if (CollectionUtil.isNull(list)) {
            return null;
        }
        GlobalAlignElement globalAlignElement = (GlobalAlignElement)list.get(0);
        return globalAlignElement;
    }

    private void reverseViewPositionByReferenceGenome(Map map) {
        this.globalAlignViewModel.updateReverseChromIdSet(map);
        for (GlobalAlignGroup globalAlignGroup : this.getGlobalAlign().getGlobalAlignGroupList()) {
            for (GlobalAlignElement globalAlignElement : globalAlignGroup.getAlignElementSet()) {
                double d = this.reverseViewPosition(globalAlignElement);
                Chromosome chromosome = this.getGlobalAlign().getChromosome(globalAlignElement.getOrganism().getOrganismCode(), globalAlignElement.getChromID());
                if (globalAlignElement.getLocusTag().equals("HPB8_13")) {
                    System.err.println("0*******" + globalAlignElement.getPosition() + " " + d);
                }
                if (chromosome != null && chromosome.isCircular() && d > (double)chromosome.getLength() / 2.0) {
                    d -= (double)chromosome.getLength();
                }
                globalAlignElement.setViewPosition(d);
            }
        }
        this.updateViewGlobalAlignElementListMap();
    }

    private double reverseViewPosition(GlobalAlignElement globalAlignElement) {
        if (!this.globalAlignViewModel.isReverseGenome(globalAlignElement.getChromID())) {
            return globalAlignElement.getPosition();
        }
        if (!this.globalAlignViewModel.getOrganismViewModel().isViewOrganism(globalAlignElement.getOrganism())) {
            return globalAlignElement.getPosition();
        }
        double d = this.getGlobalAlign().getMainChromosome(globalAlignElement.getOrganism().getOrganismCode()).getLength();
        double d2 = globalAlignElement.getPosition();
        double d3 = this.getDrawCenteralGenomePosition(globalAlignElement);
        double d4 = this.getViewCentralPosition(globalAlignElement);
        double d5 = this.getReferenceChromosomeLength();
        double d6 = 2.0 * d3 - d2;
        if (globalAlignElement.getOrganismCode().equals("HB8") && globalAlignElement.getLocusTag().equals("HPB8_1458")) {
            System.err.println("##CentPos==>" + d3 + " " + d4 + " " + d2 + " " + d6 + " " + globalAlignElement.getLocusTag());
        }
        if (d6 > d) {
            d6 -= d;
        }
        if (d6 < 0.0) {
            d6 += d;
        }
        if (logger.isDebugEnabled() && (globalAlignElement.getLocusTagWithoutDomain().equals("BA2261") || globalAlignElement.getLocusTagWithoutDomain().equals("BA5735"))) {
            logger.info("=========== the result of reverse calculation ===========");
            logger.info("LocusTag:" + globalAlignElement.getLocusTagWithoutDomain());
            logger.info("startPosition:" + this.globalAlignViewModel.getStartPosition());
            logger.info("getDrawGenomeLineLength:" + this.getDrawGenomeLineLength());
            logger.info("chrLength:" + d);
            logger.info("scaleLength:" + d5);
            logger.info("vp:" + d2);
            logger.info("cp:" + d3);
            logger.info("viewPosition:" + d6);
            logger.info("======================================================");
        }
        return d6;
    }

    void updateViewPosition_Old() {
        this.globalAlignViewModel.printCentralPositions();
        for (GlobalAlignGroup globalAlignGroup : this.getGlobalAlign().getGlobalAlignGroupList()) {
            for (GlobalAlignElement globalAlignElement : globalAlignGroup.getAlignElementSet()) {
                if (!this.globalAlignViewModel.getOrganismViewModel().isViewOrganism(globalAlignElement.getOrganism())) continue;
                double d = this.globalAlignViewModel.getCentralPosition(globalAlignElement.getOrganism().getOrganismCode(), globalAlignElement.getChromID());
                double d2 = this.calcGenePositionForAdjustCentralPosition_Old(this.getGlobalAlign(), globalAlignElement, d, globalAlignElement.getViewPosition(), this.globalAlignViewModel.isAdjustMode());
                if (globalAlignElement.getLocusTag().equals("HPKB_1321")) {
                    System.err.println("***" + globalAlignElement.getOrganism().getOrganismCode() + " " + globalAlignElement.getChromID() + " " + globalAlignElement.getLocusTag() + " S>" + globalAlignElement.getStart() + " " + d + " " + globalAlignElement.getPosition() + " " + globalAlignElement.getViewPosition() + " " + d2);
                }
                globalAlignElement.setViewPosition(d2);
            }
        }
        this.updateViewGlobalAlignElementListMap();
    }

    void updateViewPosition() {
        this.globalAlignViewModel.printCentralPositions();
        for (GlobalAlignGroup globalAlignGroup : this.getGlobalAlign().getGlobalAlignGroupList()) {
            for (GlobalAlignElement globalAlignElement : globalAlignGroup.getAlignElementSet()) {
                if (!this.globalAlignViewModel.getOrganismViewModel().isViewOrganism(globalAlignElement.getOrganism())) continue;
                double d = this.globalAlignViewModel.getCentralViewPosition(globalAlignElement.getOrganism().getOrganismCode(), globalAlignElement.getChromID());
                double d2 = this.calcGenePositionForAdjustCentralPosition(globalAlignElement);
                if (this.globalAlignViewModel.isReverseGenome(globalAlignElement.getChromID())) {
                    d2 *= -1.0;
                }
                globalAlignElement.setViewPosition(d2);
            }
        }
        this.updateViewGlobalAlignElementListMap();
    }

    private void updateViewGlobalAlignElementListMap() {
        for (Organism organism : this.getOrganismViewModel().getViewOrganismList()) {
            List list = this.globalAlignViewModel.getGlobalAlignElementList(organism.getOrganismCode(), this.globalAlignViewModel.getViewGlobalAlignGroupList());
            Collections.sort(list, new GlobalAlignElementComparator());
            this.viewGlobalAlignElementListMap.put(organism.getOrganismCode(), list);
        }
    }

    List getViewGlobalAlignElementList(String string) {
        return (List)this.viewGlobalAlignElementListMap.get(string);
    }

    void initGenomeLineStartPositionMap() {
        double d = this.getScaleLength();
        for (Organism organism : this.getOrganismViewModel().getViewOrganismList()) {
            Chromosome chromosome = this.getGlobalAlign().getMainChromosome(organism.getOrganismCode());
            double d2 = this.getGlobalAlign().getAllChromosomeLengthByOrganism(organism.getOrganismCode());
            double d3 = chromosome.isCircular() ? (d - d2) / 2.0 : 0.0;
            this.genomeLineStartPositionMap.put(organism.getOrganismCode(), new Double(d3));
        }
    }

    double getGenomeLineStartPosition(String string) {
        return (Double)this.genomeLineStartPositionMap.get(string);
    }

    void setGenomeLineStartPosition(String string, double d) {
        this.genomeLineStartPositionMap.put(string, new Double(d));
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return this;
        }
    }
}

