/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.align;

import cgdp.recog.align.GlobalAlign;
import cgdp.recog.align.GlobalAlignContext;
import cgdp.recog.align.GlobalAlignElement;
import cgdp.recog.align.GlobalAlignElementLoopExecuter;
import cgdp.recog.align.GlobalAlignGroup;
import cgdp.recog.align.GlobalAlignPositionManager;
import cgdp.recog.align.GlobalAlignRange;
import cgdp.recog.align.GlobalAlignScaleRenderer;
import cgdp.recog.align.GlobalAlignViewModel;
import cgdp.recog.align.GradientColor;
import cgdp.recog.color.ColorDrawable;
import cgdp.recog.color.ColorFacade;
import cgdp.recog.data.Chromosome;
import cgdp.recog.organism.Organism;
import cgdp.recog.organism.OrganismViewModel;
import cgdp.recog.process.ThreadCancelListener;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.Range;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

class GlobalAlignRenderer
implements Cloneable {
    private static final ApplicationLogger logger = new ApplicationLogger(GlobalAlignRenderer.class);
    private GlobalAlignViewModel globalAlignViewModel;
    private GlobalAlignContext globalAlignContext;
    private GradientColor gradientColor;
    private GlobalAlignPositionManager globalAlignPositionManager;
    private GlobalAlignScaleRenderer scaleRenderer;

    GlobalAlignRenderer(GlobalAlignViewModel globalAlignViewModel) {
        this.globalAlignViewModel = globalAlignViewModel;
        this.gradientColor = new GradientColor();
        this.globalAlignPositionManager = this.globalAlignViewModel.getGlobalAlignPositionManager();
        this.globalAlignContext = this.globalAlignPositionManager.getGlobalAlignContext();
        this.scaleRenderer = new GlobalAlignScaleRenderer(this.globalAlignViewModel, this.globalAlignContext, this.globalAlignPositionManager);
    }

    void beforeDraw(Graphics2D graphics2D) {
        this.beforeDraw(graphics2D, 1.0);
    }

    void beforeDraw(Graphics2D graphics2D, double d) {
        this.globalAlignContext.setOrganismNameWidth(this.calcOrganismNameSize(graphics2D));
        this.globalAlignContext.setScaleX(this.getGenomeScaleX() * this.globalAlignViewModel.getZoomScale() * d);
        this.globalAlignContext.setGenomeLineStartYList(this.globalAlignPositionManager.calcGenomeLineStartY(graphics2D.getFontMetrics()));
        this.globalAlignContext.setDrawHeight(this.calcHeight());
    }

    private double calcOrganismNameSize(Graphics2D graphics2D) {
        Font font = graphics2D.getFont();
        graphics2D.setFont(this.globalAlignContext.createFont());
        double d = this.getOrganismViewModel().calcOrganismNameWidth(graphics2D);
        graphics2D.setFont(font);
        String string = "(0000000-0000000 +)";
        double d2 = graphics2D.getFontMetrics().stringWidth(string);
        d = Math.max(d, d2);
        return d;
    }

    void draw(Graphics2D graphics2D, ThreadCancelListener threadCancelListener) {
        this.gradientColor.initColor(this.globalAlignViewModel.getTargetShowGlobalAlignGroupCount());
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Font font = graphics2D.getFont().deriveFont(this.globalAlignContext.getLabelFontSize());
        graphics2D.setFont(font);
        double d = this.globalAlignPositionManager.getOffsetX();
        graphics2D.translate(-d, 0.0);
        long l = System.currentTimeMillis();
        if (this.globalAlignViewModel.isAdjustMode()) {
            this.drawGenomeLineForAdjustMode(graphics2D);
        } else {
            this.drawGenomeLineForSimpleMode(graphics2D);
        }
        long l2 = System.currentTimeMillis();
        this.drawOrthologLines(graphics2D, threadCancelListener);
        long l3 = System.currentTimeMillis();
        this.drawLabel(graphics2D);
        long l4 = System.currentTimeMillis();
        graphics2D.translate(d, 0.0);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
    }

    void drawSelectedOrthologLines(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double d = this.globalAlignPositionManager.getOffsetX() - this.globalAlignContext.getAlignStartX();
        graphics2D.translate(-d, 0.0);
        HashMap hashMap = new HashMap();
        List list = this.getOrganismViewModel().getViewOrganismList();
        List list2 = this.globalAlignContext.getGenomeLineStartYList();
        for (GlobalAlignGroup globalAlignGroup : this.globalAlignViewModel.getSelectedGlobalAlignGroupSet()) {
            this.drawSelectOrthologLine(graphics2D, globalAlignGroup, list, list2, hashMap);
        }
        graphics2D.translate(d, 0.0);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
    }

    void drawFrame(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.drawScale(graphics2D);
        this.drawOrganismName(graphics2D);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
    }

    private void drawScale(Graphics2D graphics2D) {
        this.scaleRenderer.draw(graphics2D);
    }

    private void drawGenomeLineForSimpleMode(Graphics2D graphics2D) {
        List list = this.getOrganismViewModel().getViewOrganismList();
        double d = this.globalAlignPositionManager.getDrawLimitRight();
        double d2 = this.globalAlignPositionManager.getDrawLimitLeft();
        List list2 = this.globalAlignContext.getGenomeLineStartYList();
        for (int i = 0; i < list.size(); ++i) {
            double d3 = (Double)list2.get(i);
            Organism organism = (Organism)list.get(i);
            double d4 = this.getGlobalAlign().getAllChromosomeLengthByOrganism(organism.getOrganismCode());
            double d5 = this.globalAlignContext.calcGenomeLineWidth(d4);
            double d6 = this.globalAlignPositionManager.getGenomeLineStartX_new(organism.getOrganismCode());
            double d7 = d6 + d5;
            System.err.println("## " + d6 + " " + d7);
            List list3 = this.getGlobalAlign().getChromosomeList(organism.getOrganismCode());
            Chromosome chromosome = (Chromosome)list3.get(0);
            double d8 = 0.0;
            double d9 = d6 + this.globalAlignContext.calcGenomeLineWidth(d8);
            for (int j = 0; j < list3.size(); ++j) {
                double d10;
                double d11;
                Chromosome chromosome2 = (Chromosome)list3.get(j);
                double d12 = this.globalAlignContext.calcGenomeLineWidth(chromosome2.getLength());
                double d13 = d9 + d12;
                if (d9 < d2 && d13 < d2) {
                    if (d9 <= d7 && d13 > d7) {
                        d9 = d13 - d7 + d6 + 1.0;
                        continue;
                    }
                    d9 = d13 + 1.0;
                    continue;
                }
                System.err.println("##pos=" + i + " " + j + " " + d9 + " " + d13 + "; " + d7);
                graphics2D.setColor(this.getGenomeLineColor(j, list3.size()));
                if (d9 <= d7 && d13 > d7 + 1.0) {
                    d11 = (int)GlobalAlignPositionManager.adjustPointForIncludeDrawArea(d9, d2, d);
                    d10 = d7;
                    if (!(d9 < d2 && d10 < d2 || d9 > d && d10 > d)) {
                        graphics2D.drawLine((int)d11 + 2, (int)d3, (int)d10 + 2, (int)d3);
                    }
                    double d14 = d6;
                    double d15 = d13 - d7 + d6;
                    if (!(d14 < d2 && d15 < d2 || d14 > d && d15 > d)) {
                        graphics2D.drawLine((int)d14, (int)d3, (int)d15 - 2, (int)d3);
                        graphics2D.drawLine((int)d14, (int)d3, (int)d15 - 2, (int)d3);
                    }
                    if (d9 == d11 && d11 >= d2 && d11 <= d) {
                        graphics2D.drawLine((int)d11 + 2, (int)d3 + 2, (int)d11 + 2, (int)d3 - 2);
                    }
                    if (d15 >= d2 && d15 >= d2 && d15 <= d) {
                        graphics2D.drawLine((int)d15 - 2, (int)d3 + 2, (int)d15 - 2, (int)d3 - 2);
                    }
                    d9 = d15;
                    continue;
                }
                d11 = GlobalAlignPositionManager.adjustPointForIncludeDrawArea(d9, d2, d);
                d10 = GlobalAlignPositionManager.adjustPointForIncludeDrawArea(d13, d2, d);
                graphics2D.drawLine((int)d11 + 2, (int)d3, (int)d10 - 2, (int)d3);
                if (d9 == d11) {
                    graphics2D.drawLine((int)d11 + 2, (int)d3 + 2, (int)d11 + 2, (int)d3 - 2);
                }
                if (d13 == d10) {
                    graphics2D.drawLine((int)d10 - 2, (int)d3 + 2, (int)d10 - 2, (int)d3 - 2);
                }
                d9 = d13;
            }
        }
    }

    private void drawGenomeLineForAdjustMode(Graphics2D graphics2D) {
        List list = this.getOrganismViewModel().getViewOrganismList();
        double d = this.globalAlignPositionManager.getDrawLimitRight();
        double d2 = this.globalAlignPositionManager.getDrawLimitLeft();
        List list2 = this.globalAlignContext.getGenomeLineStartYList();
        graphics2D.setColor(Color.black);
        for (int i = 0; i < list.size(); ++i) {
            Organism organism = (Organism)list.get(i);
            Chromosome chromosome = this.getGlobalAlign().getMainChromosome(organism.getOrganismCode());
            double d3 = chromosome.getLength();
            double d4 = this.globalAlignContext.calcGenomeLineWidth(d3);
            double d5 = this.getGlobalAlign().getAllChromosomeLengthByOrganism(organism.getOrganismCode());
            double d6 = 0.0;
            if (chromosome.isCircular()) {
                d6 = (d5 - d3) / 2.0;
            }
            double d7 = this.globalAlignPositionManager.getGenomeLineStartX(organism.getOrganismCode()) + this.globalAlignContext.calcGenomeLineWidth(d6);
            double d8 = d7 + d4;
            double d9 = d2;
            double d10 = d;
            if (chromosome.isCircular()) {
                if (d7 >= d2 && d8 <= d) {
                    d9 = d7 + 2.0;
                    d10 = d8 - 2.0;
                }
            } else {
                if (d7 >= d2) {
                    d9 = d7 + 2.0;
                }
                if (d8 <= d) {
                    d10 = d8 - 2.0;
                }
            }
            double d11 = (Double)list2.get(i);
            graphics2D.drawLine((int)d9, (int)d11, (int)d10, (int)d11);
            if (d9 == d7 + 2.0) {
                graphics2D.drawLine((int)d9, (int)d11 + 2, (int)d9, (int)d11 - 2);
            }
            if (d10 != d8 - 2.0) continue;
            graphics2D.drawLine((int)d10, (int)d11 + 2, (int)d10, (int)d11 - 2);
        }
    }

    private Color getGenomeLineColor(int n, int n2) {
        if (n2 % 2 == 0) {
            if (n % 2 == 0) {
                return Color.black;
            }
            return Color.red;
        }
        if (n2 % 3 == 0) {
            if (n % 3 == 0) {
                return Color.black;
            }
            if (n % 3 == 1) {
                return Color.red;
            }
            return Color.blue;
        }
        if (n % 5 == 0) {
            return Color.black;
        }
        if (n % 5 == 1) {
            return Color.red;
        }
        if (n % 5 == 2) {
            return Color.blue;
        }
        if (n % 5 == 3) {
            return Color.green;
        }
        return Color.magenta;
    }

    void drawOrganismName(Graphics2D graphics2D) {
        Font font = graphics2D.getFont();
        List list = this.getOrganismViewModel().getViewOrganismList();
        List list2 = this.globalAlignContext.getGenomeLineStartYList();
        double d = this.globalAlignContext.getMarginLeft();
        for (int i = 0; i < list.size(); ++i) {
            double d2 = (Double)list2.get(i);
            Organism organism = (Organism)list.get(i);
            String string = this.getOrganismViewModel().getDisplayOrganisnName(organism);
            graphics2D.setFont(this.globalAlignContext.createFont());
            graphics2D.setColor(this.getOrganismNameFontColor(organism));
            graphics2D.drawString(string, (float)d, (float)d2);
            graphics2D.setFont(font);
            if (!this.globalAlignViewModel.isSetZoomoutScale()) continue;
            graphics2D.drawString(this.getLocationString(organism), (float)d, (float)(d2 + (double)this.globalAlignContext.getFontSize()));
        }
    }

    private Color getOrganismNameFontColor(Organism organism) {
        Color color = Color.black;
        if (this.globalAlignViewModel.isReferenceOrganism(organism.getOrganismCode())) {
            color = Color.red;
        }
        return color;
    }

    private String getLocationString(Organism organism) {
        Range range = this.globalAlignPositionManager.getViewRange(organism.getOrganismCode());
        Chromosome chromosome = this.getGlobalAlign().getMainChromosome(organism.getOrganismCode());
        return "(" + range.getX1() + "-" + range.getX2() + " " + this.getGenomeStrandString(chromosome.getId()) + ")";
    }

    private String getGenomeStrandString(int n) {
        return this.globalAlignViewModel.isReverseGenome(n) ? "-" : "+";
    }

    private void drawOrthologLines(Graphics2D graphics2D, ThreadCancelListener threadCancelListener) {
        List list = this.getOrganismViewModel().getViewOrganismList();
        List list2 = this.globalAlignContext.getGenomeLineStartYList();
        int n = 0;
        HashMap hashMap = new HashMap();
        ArrayList arrayList = new ArrayList(this.globalAlignViewModel.getViewGlobalAlignGroupList());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext() && !threadCancelListener.isCancel()) {
            GlobalAlignGroup globalAlignGroup = (GlobalAlignGroup)iterator.next();
            Color color = null;
            if (globalAlignGroup.isCore() && this.globalAlignViewModel.isShowGene(globalAlignGroup)) {
                color = this.gradientColor.getGradientColor();
            }
            this.drawOrthologLine(graphics2D, globalAlignGroup, list, list2, color, this.globalAlignContext.getNonCoreColor(), 1, hashMap);
            ++n;
        }
    }

    private void drawOrthologLine(Graphics2D graphics2D, GlobalAlignGroup globalAlignGroup, List list, List list2, Color color, Color color2, int n, Map map) {
        List list3 = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            double d = (Double)list2.get(i);
            Organism organism = (Organism)list.get(i);
            if (!globalAlignGroup.containsOrganism(organism.getOrganismCode()) || !this.globalAlignViewModel.isShowGene(globalAlignGroup)) continue;
            List list4 = globalAlignGroup.getAlignElementList(organism.getOrganismCode());
            boolean bl = this.globalAlignViewModel.isShowOrthologLine(globalAlignGroup);
            List list5 = this.drawOrthologGroupLine(graphics2D, globalAlignGroup, list4, d, list3, color, color2, n, map, bl, false);
            list3 = bl ? list5 : new ArrayList();
        }
    }

    private void drawSelectOrthologLine(Graphics2D graphics2D, GlobalAlignGroup globalAlignGroup, List list, List list2, Map map) {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            double d = (Double)list2.get(i);
            Organism organism = (Organism)list.get(i);
            if (!globalAlignGroup.containsOrganism(organism.getOrganismCode())) continue;
            ArrayList arrayList2 = new ArrayList();
            List list3 = globalAlignGroup.getAlignElementList(organism.getOrganismCode());
            arrayList2.addAll(this.drawOrthologGroupLine(graphics2D, globalAlignGroup, list3, d, arrayList, null, null, 3, map, true, true));
            arrayList = arrayList2;
        }
    }

    private List drawOrthologGroupLine(Graphics2D graphics2D, GlobalAlignGroup globalAlignGroup, List list, double d, List list2, Color color, Color color2, int n, Map map, boolean bl, boolean bl2) {
        ArrayList<Point> arrayList = new ArrayList<Point>();
        double d2 = this.globalAlignPositionManager.getDrawLimitRight();
        double d3 = this.globalAlignPositionManager.getDrawLimitLeft();
        for (GlobalAlignElement globalAlignElement : list) {
            String string;
            Organism organism = globalAlignElement.getOrganism();
            if (this.globalAlignViewModel.isAdjustMode() && !this.getGlobalAlign().isMainChromosome(organism.getOrganismCode(), globalAlignElement.getChromID())) continue;
            double d4 = this.globalAlignPositionManager.getGenomeLineStartX(organism.getOrganismCode());
            double d5 = globalAlignElement.getViewPosition();
            double d6 = d5 - (double)globalAlignElement.getLength() / 2.0;
            double d7 = d5 + (double)globalAlignElement.getLength() / 2.0;
            Chromosome chromosome = this.getGlobalAlign().getChromosome(organism.getOrganismCode(), globalAlignElement.getChromID());
            if (d6 > d7) {
                d7 += (double)chromosome.getLength();
            }
            int n2 = (int)(d4 + this.globalAlignContext.calcX(d6));
            int n3 = (int)(d4 + this.globalAlignContext.calcX(d7));
            int n4 = this.globalAlignPositionManager.getGeneStartY(globalAlignElement, d);
            int n5 = (int)(d + this.globalAlignContext.getGeneHeight() / 2.0);
            if (bl) {
                int n6 = (int)(this.globalAlignContext.getGeneHeight() / 2.0);
                int n7 = (n2 + n3) / 2;
                int n8 = n4 + n6;
                Point point = new Point(n7, n8);
                for (Point point2 : list2) {
                    int n9;
                    int n10;
                    int n11;
                    int n12;
                    String string2;
                    if (!((double)n7 <= d2 && (double)n7 >= d3) && (!((double)point2.x <= d2) || !((double)point2.x >= d3))) continue;
                    double d8 = ((double)Math.abs(n8 - point2.y) - this.globalAlignContext.getGeneHeight()) / (double)Math.abs(n7 - point2.x);
                    double d9 = (int)GlobalAlignPositionManager.adjustPointForIncludeDrawArea(point2.x, d3, d2);
                    double d10 = point2.y;
                    if (d9 != (double)point2.x) {
                        d10 = n7 < point2.x ? (d10 += (double)((int)(Math.abs((double)point2.x - d2) * d8))) : (d10 += (double)((int)(Math.abs((double)point2.x - d3) * d8)));
                    }
                    double d11 = (int)GlobalAlignPositionManager.adjustPointForIncludeDrawArea(n7, d3, d2);
                    double d12 = point.y;
                    if (d11 != (double)n7) {
                        d12 = n7 < point2.x ? (d12 -= (double)((int)(Math.abs(d3 - (double)n7) * d8))) : (d12 -= (double)((int)(Math.abs(d2 - (double)n7) * d8)));
                    }
                    if (map.containsKey(string2 = this.createDrawShapeKey(n12 = (int)d9, n11 = (int)(d10 + (double)n6), n10 = (int)d11, n9 = (int)(d12 - (double)n6))) && this.globalAlignContext.isDrawEfficient()) continue;
                    Stroke stroke = graphics2D.getStroke();
                    Color color3 = this.getOrthologGroupLineColor(globalAlignGroup, globalAlignElement, color, color2, bl2);
                    if (color3 == null) continue;
                    graphics2D.setColor(color3);
                    graphics2D.setStroke(new BasicStroke(n));
                    if (color3.getRed() == 255) {
                        System.err.println("line:" + color3.getRed() + " " + n12 + " " + n11 + " " + n10 + " " + n9);
                    }
                    graphics2D.drawLine(n12, n11, n10, n9);
                    graphics2D.setStroke(stroke);
                }
                arrayList.add(point);
            }
            if (!((double)n2 <= d2) && !((double)n3 >= d3)) continue;
            if (globalAlignElement.getLength() < 0) {
                System.err.println("###" + globalAlignElement.getLocusTag() + " " + d6 + " " + d7 + "; " + n2 + " " + n3 + " " + n4 + " " + n5 + "; " + d2 + " " + d3);
            }
            Color color4 = this.getGeneColor(globalAlignGroup, globalAlignElement, color, color2, bl2);
            if (this.globalAlignViewModel.isViewAbstract()) {
                String string3;
                if (!GlobalAlignPositionManager.containsRange(n2, d3, d2) || map.containsKey(string3 = this.createDrawShapeKey(n2, n4, n3, n5)) && this.globalAlignContext.isDrawEfficient()) continue;
                graphics2D.setColor(color4);
                Shape shape = this.getAbstractGeneShape(n2, n4, n3, n5, n);
                if (color4 == null) continue;
                graphics2D.fill(shape);
                graphics2D.draw(shape);
                continue;
            }
            Shape shape = this.getGeneDetailGeneShape(globalAlignElement, n2, n4, n3, d3, d2, n, d4);
            if (shape == null || map.containsKey(string = this.createDrawShapeKey(n2, n4, n3, n5)) && this.globalAlignContext.isDrawEfficient()) continue;
            if (color4 != null) {
                graphics2D.setColor(color4);
                graphics2D.fill(shape);
            }
            graphics2D.setColor(this.globalAlignContext.getGeneBorderColor());
            graphics2D.draw(shape);
        }
        return arrayList;
    }

    private Color getGeneColor(GlobalAlignGroup globalAlignGroup, GlobalAlignElement globalAlignElement, Color color, Color color2, boolean bl) {
        Color color3;
        if (bl) {
            color3 = Color.cyan;
        } else if (this.globalAlignViewModel.isColorPPM()) {
            color3 = ColorFacade.getInstance().getPrimaryColor(globalAlignGroup.getCluster(), globalAlignElement.getOrganism(), globalAlignElement.getLocusTag());
        } else {
            color3 = color2;
            if (globalAlignGroup.isCore()) {
                color3 = color;
            } else if (globalAlignGroup.isRna()) {
                color3 = Color.blue.darker();
            }
        }
        return color3;
    }

    private Color getOrthologGroupLineColor(GlobalAlignGroup globalAlignGroup, GlobalAlignElement globalAlignElement, Color color, Color color2, boolean bl) {
        Color color3;
        if (bl) {
            color3 = Color.cyan;
        } else if (this.globalAlignViewModel.isColorPPM()) {
            color3 = Color.lightGray;
            color3 = this.getGeneColor(globalAlignGroup, globalAlignElement, color, color2, bl);
        } else {
            color3 = color2;
            if (globalAlignGroup.isCore()) {
                color3 = color;
            } else if (globalAlignGroup.isRna()) {
                color3 = Color.blue.darker();
            }
        }
        return color3;
    }

    private String createDrawShapeKey(int n, int n2, int n3, int n4) {
        return n + ":" + n2 + ":" + n3 + ":" + n4;
    }

    private void drawLabel(final Graphics2D graphics2D) {
        if (!this.globalAlignViewModel.isShowLocusTagForView()) {
            return;
        }
        final FontMetrics fontMetrics = graphics2D.getFontMetrics();
        graphics2D.setColor(Color.black);
        GlobalAlignElementLoopExecuter globalAlignElementLoopExecuter = new GlobalAlignElementLoopExecuter(this.globalAlignPositionManager){
            private double genomeLineY;
            private Map labelMaxXMap;
            private static final double INITPOS = -1.0E20;

            @Override
            protected void init() {
                this.labelMaxXMap = this.getGlobalAlignPositionManager().initLabelMaxXMap(-1.0E20);
            }

            @Override
            protected void beforeGlobalAlignElement(Organism organism) {
                List list = GlobalAlignRenderer.this.getGlobalAlignContext().getGenomeLineStartYList();
                int n = GlobalAlignRenderer.this.getOrganismViewModel().indexOfOrganism(organism.getOrganismCode());
                this.genomeLineY = (Double)list.get(n);
            }

            @Override
            protected boolean loopGlobalAlignElement(GlobalAlignElement globalAlignElement, int n, int n2) {
                String string = GlobalAlignRenderer.this.globalAlignPositionManager.createLabelRowKey(globalAlignElement);
                List list = (List)this.labelMaxXMap.get(string);
                for (int i = 0; i < list.size(); ++i) {
                    double d = (Double)list.get(i);
                    System.err.println("***000:" + d + " " + n + " " + globalAlignElement.getLocusTag());
                    if (!(d < (double)n)) continue;
                    d = (double)(n + fontMetrics.stringWidth(globalAlignElement.getLocusTag())) + 2.0;
                    list.set(i, new Double(d));
                    System.err.println("******:" + d + " " + n + " " + globalAlignElement.getLocusTag());
                    int n3 = (int)GlobalAlignRenderer.this.getLabelStartY(globalAlignElement, this.genomeLineY, i);
                    graphics2D.drawString(globalAlignElement.getLocusTag(), n, n3);
                    break;
                }
                return true;
            }
        };
        globalAlignElementLoopExecuter.execute();
    }

    private double getLabelStartY(GlobalAlignElement globalAlignElement, double d, int n) {
        double d2 = this.globalAlignPositionManager.getGeneHeightFromGenomeLine();
        int n2 = this.globalAlignViewModel.isViewAbstract() ? (int)(d - d2 - (double)n * this.globalAlignContext.getLabelRowHeight()) : (this.globalAlignViewModel.isDirectionPosition(globalAlignElement) ? (int)(d - d2 - (double)n * this.globalAlignContext.getLabelRowHeight()) : (int)(d + d2 + (double)(n + 1) * this.globalAlignContext.getLabelRowHeight()));
        return n2;
    }

    private Shape getAbstractGeneShape(double d, double d2, double d3, double d4, int n) {
        if (d == d3 && n == 1) {
            return new Line2D.Double(d, d2, d, d4);
        }
        int n2 = (int)Math.max(Math.abs(d3 - d), (double)n);
        return new Rectangle2D.Double(d, d2, n2, Math.abs(d4 - d2));
    }

    private Shape getGeneDetailGeneShape(GlobalAlignElement globalAlignElement, double d, double d2, double d3, double d4, double d5, int n, double d6) {
        int n2;
        int n3 = (int)GlobalAlignPositionManager.adjustPointForIncludeDrawArea(d, d4, d5);
        if (n3 == (n2 = (int)GlobalAlignPositionManager.adjustPointForIncludeDrawArea(d3, d4, d5)) && (n3 == (int)d4 || n3 == (int)d5)) {
            return null;
        }
        if (Math.abs(d - d3) <= 1.0) {
            if (globalAlignElement.isShowArrow()) {
                int n4;
                if (this.globalAlignViewModel.isDirectionPosition(globalAlignElement)) {
                    n4 = (int)(this.globalAlignContext.getGeneDirectionHeight() - this.globalAlignContext.getGeneHeight());
                    d2 -= (double)n4;
                }
                n4 = (int)(d2 + this.globalAlignContext.getGeneDirectionHeight());
                if (this.globalAlignViewModel.isDirectionPosition(globalAlignElement)) {
                    GeneralPath generalPath = new GeneralPath();
                    generalPath.moveTo(n3, (float)d2);
                    generalPath.lineTo((float)n2 + 5.0f, n4);
                    generalPath.lineTo(n3, n4);
                    generalPath.closePath();
                    return generalPath;
                }
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo((float)n3 - 5.0f, (float)d2);
                generalPath.lineTo(n2, (float)d2);
                generalPath.lineTo(n3, n4);
                generalPath.closePath();
                return generalPath;
            }
            int n5 = (int)(d2 + this.globalAlignContext.getGeneHeight());
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(n3, (float)d2);
            generalPath.lineTo((float)n2 - 5.0f, (float)d2);
            generalPath.lineTo((float)n2 - 5.0f, n5);
            generalPath.closePath();
            return generalPath;
        }
        double d7 = Math.abs(d3 - d);
        double d8 = this.globalAlignContext.getGeneDirectionWidth(d7);
        int n6 = (int)(d2 + this.globalAlignContext.getGeneHeight());
        if (d8 != 0.0 && globalAlignElement.isShowArrow()) {
            if (this.globalAlignViewModel.isDirectionPosition(globalAlignElement)) {
                double d9 = d3 - d8;
                if (globalAlignElement.isExon()) {
                    return this.drawIntronExonGene(globalAlignElement, d2, n6, d6);
                }
                if (d9 > (double)n2) {
                    return this.getAbstractGeneShape(n3, d2, n2, n6, n);
                }
                double d10 = (double)n6 - this.globalAlignContext.getGeneDirectionHeight();
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo((float)d3, n6);
                generalPath.lineTo((float)d9, (float)d10);
                generalPath.lineTo((float)d9, (float)d2);
                generalPath.lineTo(n3, (float)d2);
                generalPath.lineTo(n3, n6);
                generalPath.closePath();
                return generalPath;
            }
            double d11 = d + d8;
            if (d11 < (double)n3) {
                return this.getAbstractGeneShape(n3, d2, n2, n6, n);
            }
            if (globalAlignElement.isExon()) {
                return this.drawIntronExonGene(globalAlignElement, d2, n6, d6);
            }
            double d12 = d2 + this.globalAlignContext.getGeneDirectionHeight();
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo((float)d, (float)d2);
            generalPath.lineTo((float)d11, (float)d12);
            generalPath.lineTo((float)d11, n6);
            generalPath.lineTo(n2, n6);
            generalPath.lineTo(n2, (float)d2);
            generalPath.closePath();
            return generalPath;
        }
        return new Rectangle2D.Double(d, d2, d3 - d, this.globalAlignContext.getGeneHeight());
    }

    private Shape drawIntronExonGene(GlobalAlignElement globalAlignElement, double d, double d2, double d3) {
        Point2D.Float float_;
        float f;
        List list;
        float f2;
        float f3;
        float f4;
        float f5;
        int n = (int)this.globalAlignContext.getIntronMargin();
        if (this.globalAlignViewModel.isDirectionPosition(globalAlignElement)) {
            f5 = (float)(d + (double)n);
            f4 = (float)(d2 - (double)n);
            f3 = (float)d;
            f2 = (float)d2;
            list = globalAlignElement.getAdjustReverseLocationList(this.globalAlignViewModel);
        } else {
            f5 = (float)(d2 - (double)n);
            f4 = (float)(d + (double)n);
            f3 = (float)d2;
            f2 = (float)d;
            list = globalAlignElement.getAdjustReverseLocationList(this.globalAlignViewModel);
            Collections.reverse(list);
        }
        GeneralPath generalPath = new GeneralPath();
        GlobalAlignRange globalAlignRange = (GlobalAlignRange)list.get(0);
        int n2 = this.getIntronExsonPosition(globalAlignElement, globalAlignRange.getX1ByDirection(this.globalAlignViewModel), d3);
        int n3 = this.getIntronExsonPosition(globalAlignElement, globalAlignRange.getX2ByDirection(this.globalAlignViewModel), d3);
        Stack<Point2D.Float> stack = new Stack<Point2D.Float>();
        int n4 = Integer.MIN_VALUE;
        for (int i = 0; i < list.size(); ++i) {
            GlobalAlignRange globalAlignRange2 = (GlobalAlignRange)list.get(i);
            n2 = this.getIntronExsonPosition(globalAlignElement, globalAlignRange2.getX1ByDirection(this.globalAlignViewModel), d3);
            n3 = this.getIntronExsonPosition(globalAlignElement, globalAlignRange2.getX2ByDirection(this.globalAlignViewModel), d3);
            if (n4 == Integer.MIN_VALUE) {
                generalPath.moveTo(n2, f3);
            } else {
                generalPath.lineTo(n4, f4);
                generalPath.lineTo(n2, f4);
                stack.push(new Point2D.Float(n4, f5));
                stack.push(new Point2D.Float(n2, f5));
            }
            generalPath.lineTo(n2, f2);
            generalPath.lineTo(n3, f2);
            stack.push(new Point2D.Float(n2, f3));
            stack.push(new Point2D.Float(n3, f3));
            n4 = n3;
        }
        double d4 = Math.abs(n3 - n2);
        double d5 = this.globalAlignContext.getGeneDirectionWidth(d4);
        if (this.globalAlignViewModel.isDirectionPosition(globalAlignElement)) {
            f = (float)((double)n3 - d5);
            generalPath.lineTo(f, (float)((double)f2 - this.globalAlignContext.getGeneDirectionHeight()));
            float_ = (Point2D.Float)stack.peek();
            float_.setLocation(f, float_.y);
        } else {
            f = (float)((double)n3 + d5);
            generalPath.lineTo(f, (float)((double)f2 + this.globalAlignContext.getGeneDirectionHeight()));
            float_ = (Point2D.Float)stack.peek();
            float_.setLocation(f, float_.y);
        }
        int n5 = stack.size();
        for (int i = 0; i < n5; ++i) {
            Point2D.Float float_2 = (Point2D.Float)stack.pop();
            generalPath.lineTo(float_2.x, float_2.y);
        }
        generalPath.closePath();
        return generalPath;
    }

    private int getIntronExsonPosition(GlobalAlignElement globalAlignElement, int n, double d) {
        double d2 = globalAlignElement.getViewPosition() - (double)globalAlignElement.getLength() / 2.0 + (double)n;
        return (int)(d + this.globalAlignContext.calcX(d2));
    }

    private GlobalAlign getGlobalAlign() {
        return this.globalAlignViewModel.getGlobalAlign();
    }

    private OrganismViewModel getOrganismViewModel() {
        return this.globalAlignViewModel.getOrganismViewModel();
    }

    private double getGenomeScaleX() {
        return this.globalAlignContext.getAlignDrawWidth() / this.globalAlignPositionManager.getScaleLength();
    }

    GlobalAlignContext getGlobalAlignContext() {
        return this.globalAlignContext;
    }

    double getDrawWidth() {
        return this.globalAlignContext.getDrawWidth();
    }

    double getDrawHeight() {
        return this.globalAlignContext.getDrawHeight();
    }

    double getAlignStartX() {
        return this.globalAlignContext.getAlignStartX();
    }

    int indexOfOrganism(int n) {
        return this.globalAlignPositionManager.indexOfOrganism(n, this.globalAlignViewModel.isViewAbstract());
    }

    boolean isOrganismTitleX(Point point) {
        return this.globalAlignContext.isOrganismTitleX(point);
    }

    double calcHeight() {
        List list = this.globalAlignContext.getGenomeLineStartYList();
        return (Double)list.get(list.size() - 1) + this.globalAlignContext.getGeneDirectionHeight() + this.globalAlignContext.getLabelRowHeight() * this.globalAlignPositionManager.getGenomeLineOneSideLabelCount() + this.globalAlignContext.getMarginBottom();
    }

    GlobalAlignElement getGlobalAlignElement(String string, int n, int n2) {
        List list = (List)this.globalAlignViewModel.getSelectableAreaMap().get(string);
        if (list == null) {
            return null;
        }
        int n3 = (int)((double)n + this.globalAlignPositionManager.getOffsetX());
        int n4 = this.getOrganismViewModel().indexOfOrganismCode(string);
        double d = this.globalAlignContext.getGenomeLineStartY(n4);
        for (GlobalAlignRange globalAlignRange : list) {
            if (globalAlignRange.contains(n3)) {
                GlobalAlignElement globalAlignElement = globalAlignRange.getGlobalAlignElement();
                if (!(this.globalAlignViewModel.isDirectionPosition(globalAlignElement) && d > (double)n2) && (this.globalAlignViewModel.isDirectionPosition(globalAlignElement) || !(d < (double)n2))) continue;
                return globalAlignRange.getGlobalAlignElement();
            }
            if (!globalAlignRange.less(n3)) continue;
            break;
        }
        return null;
    }

    void moveLeft() {
        this.globalAlignPositionManager.moveLeft();
    }

    void moveRight() {
        this.globalAlignPositionManager.moveRight();
    }

    void moveCenter(Set set) {
        if (!this.globalAlignViewModel.isSetZoomoutScale() && !this.globalAlignViewModel.isAdjustMode()) {
            return;
        }
        this.globalAlignPositionManager.moveCenter(set);
    }

    void zoom(double d) {
        this.globalAlignPositionManager.zoom(d);
    }

    void changeCentralPosition(GlobalAlignGroup globalAlignGroup, GlobalAlignElement globalAlignElement) {
        this.globalAlignPositionManager.changeCentralPosition(globalAlignGroup, globalAlignElement);
    }

    void setDrawWidth(double d) {
        this.globalAlignContext.setDrawWidth(d);
        this.globalAlignViewModel.updateDetailDisplay(this.globalAlignPositionManager.getDrawGenomeLength(), this.globalAlignContext.getDrawWidth());
    }

    void setDrawSize(double d, double d2) {
        this.globalAlignContext.setDrawWidth(d);
        this.globalAlignContext.setDrawHeight(d2);
        this.globalAlignViewModel.updateDetailDisplay(this.globalAlignPositionManager.getDrawGenomeLength(), this.globalAlignContext.getDrawWidth());
    }

    void updateSelectableAreaMap() {
        this.globalAlignViewModel.setSelectableAreaMap(this.globalAlignPositionManager.getSelectableAreaMap());
    }

    private void setGlobalAlignContext(GlobalAlignContext globalAlignContext) {
        this.globalAlignContext = globalAlignContext;
    }

    private void setGlobalAlignViewModel(GlobalAlignViewModel globalAlignViewModel) {
        this.globalAlignViewModel = globalAlignViewModel;
    }

    private GlobalAlignPositionManager getGlobalAlignPositionManager() {
        return this.globalAlignPositionManager;
    }

    private void setGlobalAlignPositionManager(GlobalAlignPositionManager globalAlignPositionManager) {
        this.globalAlignPositionManager = globalAlignPositionManager;
    }

    protected Object clone() {
        try {
            GlobalAlignRenderer globalAlignRenderer = (GlobalAlignRenderer)super.clone();
            GlobalAlignContext globalAlignContext = (GlobalAlignContext)this.globalAlignContext.clone();
            GlobalAlignViewModel globalAlignViewModel = (GlobalAlignViewModel)this.globalAlignViewModel.clone();
            globalAlignRenderer.setGlobalAlignContext(globalAlignContext);
            globalAlignRenderer.setGlobalAlignViewModel(globalAlignViewModel);
            GlobalAlignPositionManager globalAlignPositionManager = (GlobalAlignPositionManager)globalAlignRenderer.getGlobalAlignPositionManager().clone();
            globalAlignPositionManager.setGlobalAlignContext(globalAlignContext);
            globalAlignPositionManager.setGlobalAlignViewModel(globalAlignViewModel);
            globalAlignRenderer.setGlobalAlignPositionManager(globalAlignPositionManager);
            return globalAlignRenderer;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return this;
        }
    }

    class GroupListComparator
    implements Comparator<GlobalAlignGroup> {
        Organism ref_organism;

        GroupListComparator(Organism organism) {
            this.ref_organism = organism;
        }

        @Override
        public int compare(GlobalAlignGroup globalAlignGroup, GlobalAlignGroup globalAlignGroup2) {
            ColorDrawable colorDrawable = ColorFacade.getInstance().getPrimaryColorDrawable(globalAlignGroup.getCluster(), this.ref_organism);
            ColorDrawable colorDrawable2 = ColorFacade.getInstance().getPrimaryColorDrawable(globalAlignGroup2.getCluster(), this.ref_organism);
            if (colorDrawable.getNodeLabel().equals("Base Color") && !colorDrawable2.getNodeLabel().equals("Base Color")) {
                return -1;
            }
            if (colorDrawable2.getNodeLabel().equals("Base Color") && !colorDrawable.getNodeLabel().equals("Base Color")) {
                return 1;
            }
            return 0;
        }
    }
}

