/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.align;

import cgdp.recog.align.DirArrangeType;
import cgdp.recog.align.GlobalAlignViewModel;
import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.organism.Organism;
import cgdp.recog.organism.OrganismNamePanel;
import cgdp.recog.organism.OrganismSelectPanel;
import cgdp.recog.organism.OrganismViewModel;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.SliderTextPanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class GlobalAlignUpdateDialog
extends AbstractApplyDialog {
    private static final String TITLE = "Genome Comparison Viewer";
    private MediatorImpl mediator;
    private GlobalAlignViewModel globalAlignViewModel;
    private OrganismSelectPanel organismSelectPanel;
    private OrganismNamePanel organismNamePanel;
    private JCheckBox coreCheckBox;
    private JCheckBox nonCoreCheckBox;
    private JCheckBox rnaCheckBox;
    private JCheckBox coreUniversalCheckBox;
    private JCheckBox coreOneToOneCheckBox;
    private JCheckBox coreLineCheckBox;
    private JCheckBox nonCoreUniversalCheckBox;
    private JCheckBox nonCoreUniqueCheckBox;
    private JCheckBox nonCoreOneToOneCheckBox;
    private JCheckBox nonCoreLineCheckBox;
    private JRadioButton dirPosButton;
    private JRadioButton dirConsensusButton;
    private JRadioButton dirRefButton;
    private JCheckBox locusTagShowCheckBox;
    private SliderTextPanel labelRowPanel;
    private JRadioButton scalePositionFromCenterButton;
    private JRadioButton scaleReferenceGenomeButton;

    public GlobalAlignUpdateDialog(Frame frame, MediatorImpl mediatorImpl, GlobalAlignViewModel globalAlignViewModel) {
        super(frame);
        this.mediator = mediatorImpl;
        this.globalAlignViewModel = globalAlignViewModel;
        this.createComponents();
    }

    private void createComponents() {
        this.setTitle(TITLE);
        this.setModal(true);
        this.setResizable(false);
        this.organismSelectPanel = new OrganismSelectPanel(this.globalAlignViewModel.getGlobalAlign().getOrganismList(), this.globalAlignViewModel.getOrganismViewModel().getViewOrganismList(), null, true);
        this.organismNamePanel = new OrganismNamePanel(2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.organismSelectPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        this.getContentPane().add((Component)this.createDisplayPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 10, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.organismNamePanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 10), 0, 0));
        this.getContentPane().add((Component)this.createGeneArrangePanel(), new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        this.getContentPane().add((Component)this.createLabelPanel(), new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 0, new Insets(10, 0, 5, 0), 0, 0));
        this.updateValue();
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void setEnableDisplayElementParts() {
        if (this.coreCheckBox.isSelected()) {
            this.coreLineCheckBox.setEnabled(true);
            if (this.coreLineCheckBox.isSelected()) {
                this.coreUniversalCheckBox.setEnabled(true);
                this.coreOneToOneCheckBox.setEnabled(true);
            } else {
                this.coreUniversalCheckBox.setEnabled(false);
                this.coreOneToOneCheckBox.setEnabled(false);
            }
        } else {
            this.coreLineCheckBox.setEnabled(false);
            this.coreUniversalCheckBox.setEnabled(false);
            this.coreOneToOneCheckBox.setEnabled(false);
        }
        if (this.nonCoreCheckBox.isSelected()) {
            this.nonCoreUniqueCheckBox.setEnabled(true);
            if (!this.nonCoreUniqueCheckBox.isSelected()) {
                this.nonCoreLineCheckBox.setEnabled(true);
                if (this.nonCoreLineCheckBox.isSelected()) {
                    this.nonCoreUniversalCheckBox.setEnabled(true);
                    this.nonCoreOneToOneCheckBox.setEnabled(true);
                } else {
                    this.nonCoreUniversalCheckBox.setEnabled(false);
                    this.nonCoreOneToOneCheckBox.setEnabled(false);
                }
            } else {
                this.nonCoreLineCheckBox.setEnabled(false);
                this.nonCoreUniversalCheckBox.setEnabled(false);
                this.nonCoreOneToOneCheckBox.setEnabled(false);
            }
        } else {
            this.nonCoreUniqueCheckBox.setEnabled(false);
            this.nonCoreLineCheckBox.setEnabled(false);
            this.nonCoreUniversalCheckBox.setEnabled(false);
            this.nonCoreOneToOneCheckBox.setEnabled(false);
        }
    }

    private JPanel createDisplayPanel() {
        this.coreCheckBox = new JCheckBox("Core genes");
        this.coreCheckBox.addActionListener(this);
        this.coreLineCheckBox = new JCheckBox("Line:");
        this.coreLineCheckBox.addActionListener(this);
        this.coreUniversalCheckBox = new JCheckBox("Universal Only");
        this.coreOneToOneCheckBox = new JCheckBox("1vs1 Only");
        this.nonCoreCheckBox = new JCheckBox("Non-Core genes");
        this.nonCoreCheckBox.addActionListener(this);
        this.nonCoreLineCheckBox = new JCheckBox("Line:");
        this.nonCoreLineCheckBox.addActionListener(this);
        this.nonCoreUniversalCheckBox = new JCheckBox("Universal Only");
        this.nonCoreUniqueCheckBox = new JCheckBox("Unique Only");
        this.nonCoreUniqueCheckBox.addActionListener(this);
        this.nonCoreOneToOneCheckBox = new JCheckBox("1vs1 Only");
        JLabel jLabel = new JLabel("(");
        JLabel jLabel2 = new JLabel(")");
        this.rnaCheckBox = new JCheckBox("RNA");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.nonCoreCheckBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(2, 2, 2, 0), 0, 0));
        jPanel.add((Component)jLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 20, 2, 0), 0, 0));
        jPanel.add((Component)this.nonCoreUniqueCheckBox, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 0, 2, 0), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 2, 0), 0, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder("Display elements"));
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.add((Component)this.coreCheckBox, new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        jPanel2.add((Component)this.coreLineCheckBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 20, 2, 2), 0, 0));
        jPanel2.add((Component)this.coreUniversalCheckBox, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        jPanel2.add((Component)this.coreOneToOneCheckBox, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        jPanel2.add((Component)jPanel, new GridBagConstraints(0, 2, 3, 1, 1.0, 1.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        jPanel2.add((Component)this.nonCoreLineCheckBox, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 20, 2, 2), 0, 0));
        jPanel2.add((Component)this.nonCoreUniversalCheckBox, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        jPanel2.add((Component)this.nonCoreOneToOneCheckBox, new GridBagConstraints(2, 3, 1, 1, 1.0, 1.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        jPanel2.add((Component)this.rnaCheckBox, new GridBagConstraints(0, 4, 3, 1, 1.0, 1.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        return jPanel2;
    }

    private JPanel createLabelPanel() {
        this.locusTagShowCheckBox = new JCheckBox("Show");
        JLabel jLabel = new JLabel("Row count:");
        this.labelRowPanel = new SliderTextPanel();
        this.labelRowPanel.setMinimum(1);
        this.labelRowPanel.setMaximum(5);
        this.labelRowPanel.setValue(this.globalAlignViewModel.getMaxLabelRowCount());
        this.labelRowPanel.setTextColumns(3);
        this.labelRowPanel.setPaintTicks(true);
        this.labelRowPanel.setPaintLabels(true);
        this.labelRowPanel.setLabelTable(1);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Locus tag"));
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.locusTagShowCheckBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        jPanel.add((Component)jLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 10), 0, 0));
        jPanel.add((Component)this.labelRowPanel, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 2, 2, 2), 0, 0));
        return jPanel;
    }

    private JPanel createGeneArrangePanel() {
        this.dirPosButton = new JRadioButton("Arranged in the positive direction");
        this.dirConsensusButton = new JRadioButton("Arranged in the consensus direction of the core genome");
        this.dirRefButton = new JRadioButton("Arranged in the direction of the reference genome");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.dirPosButton);
        buttonGroup.add(this.dirConsensusButton);
        buttonGroup.add(this.dirRefButton);
        this.dirRefButton.setSelected(true);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Arrangement of orthologous genes"));
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.dirPosButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        jPanel.add((Component)this.dirConsensusButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        jPanel.add((Component)this.dirRefButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        return jPanel;
    }

    private void updateValue() {
        this.coreCheckBox.setSelected(this.globalAlignViewModel.isShowCore());
        this.coreLineCheckBox.setSelected(this.globalAlignViewModel.isShowCoreLine());
        this.coreUniversalCheckBox.setSelected(this.globalAlignViewModel.isShowCoreUniversal());
        this.coreOneToOneCheckBox.setSelected(this.globalAlignViewModel.isShowCoreOneToOne());
        this.nonCoreCheckBox.setSelected(this.globalAlignViewModel.isShowNonCore());
        this.nonCoreLineCheckBox.setSelected(this.globalAlignViewModel.isShowNonCoreLine());
        this.nonCoreUniversalCheckBox.setSelected(this.globalAlignViewModel.isShowNonCoreUniversal());
        this.nonCoreUniqueCheckBox.setSelected(this.globalAlignViewModel.isShowNonCoreUnique());
        this.nonCoreOneToOneCheckBox.setSelected(this.globalAlignViewModel.isShowNonCoreOneToOne());
        this.rnaCheckBox.setSelected(this.globalAlignViewModel.isShowRna());
        this.locusTagShowCheckBox.setSelected(this.globalAlignViewModel.isShowLocusTag());
        OrganismViewModel organismViewModel = this.globalAlignViewModel.getOrganismViewModel();
        this.organismNamePanel.setOrganismNameType(organismViewModel.getOrganismNameType());
        this.organismNamePanel.setAddStrainToName(organismViewModel.isAddStrainToName());
        this.organismSelectPanel.setReferenceOrganism(this.globalAlignViewModel.getReferenceOrganism());
        this.updateValueDirArrange(this.globalAlignViewModel.getDirArrangeType());
        this.setEnableDisplayElementParts();
    }

    private void updateValueDirArrange(int n) {
        if (DirArrangeType.isPositive(n)) {
            this.dirPosButton.setSelected(true);
        } else if (DirArrangeType.isConsensusOrtholog(n)) {
            this.dirConsensusButton.setSelected(true);
        } else {
            this.dirRefButton.setSelected(true);
        }
    }

    private int getDirArrangeType() {
        int n = 3;
        if (this.dirPosButton.isSelected()) {
            n = 1;
        } else if (this.dirConsensusButton.isSelected()) {
            n = 2;
        }
        return n;
    }

    @Override
    protected boolean check() {
        if (!this.organismSelectPanel.isExistViewOrganism()) {
            MessageManager.showErrorMessage((Component)this, "Select organism");
            return false;
        }
        return true;
    }

    @Override
    protected boolean apply() {
        this.setVisible(false);
        this.globalAlignViewModel.setShowCore(this.coreCheckBox.isSelected());
        this.globalAlignViewModel.setShowCoreLine(this.coreLineCheckBox.isSelected());
        this.globalAlignViewModel.setShowCoreUniversal(this.coreUniversalCheckBox.isSelected());
        this.globalAlignViewModel.setShowCoreOneToOne(this.coreOneToOneCheckBox.isSelected());
        this.globalAlignViewModel.setShowNonCore(this.nonCoreCheckBox.isSelected());
        this.globalAlignViewModel.setShowNonCoreLine(this.nonCoreLineCheckBox.isSelected());
        this.globalAlignViewModel.setShowNonCoreUnique(this.nonCoreUniqueCheckBox.isSelected());
        this.globalAlignViewModel.setShowNonCoreUniversal(this.nonCoreUniversalCheckBox.isSelected());
        this.globalAlignViewModel.setShowNonCoreOneToOne(this.nonCoreOneToOneCheckBox.isSelected());
        this.globalAlignViewModel.setShowRna(this.rnaCheckBox.isSelected());
        this.globalAlignViewModel.setDirArrangeType(this.getDirArrangeType());
        this.globalAlignViewModel.setShowLocusTag(this.locusTagShowCheckBox.isSelected());
        this.globalAlignViewModel.setMaxLabelRowCount((int)this.labelRowPanel.getValue());
        Organism organism = this.organismSelectPanel.getReferenceOrganism();
        this.globalAlignViewModel.setReferenceOrganism(organism);
        List list = this.organismSelectPanel.getTargetOrganismList();
        int n = this.organismNamePanel.getOrganismNameType();
        boolean bl = this.organismNamePanel.isAddStrainToName();
        OrganismViewModel organismViewModel = this.globalAlignViewModel.getOrganismViewModel();
        organismViewModel.setViewOrganismList(list);
        organismViewModel.setOrganismNameType(n);
        organismViewModel.setAddStrainToName(bl);
        this.globalAlignViewModel.processAfterUpdateOrganism();
        this.globalAlignViewModel.updateAlignGroupStatus();
        this.globalAlignViewModel.clearSelectGlobalAlignGroup();
        this.globalAlignViewModel.updateViewPosition();
        this.mediator.updateGlobalAlignMap(true);
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.coreCheckBox || actionEvent.getSource() == this.coreLineCheckBox || actionEvent.getSource() == this.nonCoreCheckBox || actionEvent.getSource() == this.nonCoreLineCheckBox || actionEvent.getSource() == this.nonCoreUniqueCheckBox) {
            this.setEnableDisplayElementParts();
        }
    }
}

