/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.controltree;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.controltree.ControlTitleNode;
import cgdp.recog.controltree.ControlTreeRenderer;
import cgdp.recog.controltree.ControlTreeTransferHandler;
import cgdp.recog.system.OS;
import cgdp.recog.util.AbstractTree;
import java.awt.Frame;
import java.awt.Point;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

abstract class AbstractControlTree
extends AbstractTree {
    protected Frame parent;
    protected MediatorImpl mediator;
    protected DefaultTreeModel treeModel;

    public AbstractControlTree(Frame frame, MediatorImpl mediatorImpl) {
        super(OS.isWindows());
        this.parent = frame;
        this.mediator = mediatorImpl;
        this.mediator.register(this);
        this.createComponents();
        this.treeModel = new DefaultTreeModel(this.createTreeStructure());
        this.setModel(this.treeModel);
        this.setVisibleRoot();
        this.setCellRenderer(new ControlTreeRenderer());
        this.addMouseListener(this);
        this.setDragEnabled(true);
        this.setTransferHandler(new ControlTreeTransferHandler(this.mediator));
    }

    protected abstract void createComponents();

    @Override
    protected void setVisibleRoot() {
        this.setRootVisible(false);
    }

    @Override
    protected void showPopup(Point point) {
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray == null) {
            return;
        }
        int n = this.getControlTitleType();
        JPopupMenu jPopupMenu = this.createPopupMenu(n);
        if (jPopupMenu != null) {
            jPopupMenu.show(this, point.x, point.y);
        }
    }

    protected int getControlTitleType() {
        TreePath treePath = this.getSelectionPath();
        if (treePath == null || treePath.getPathCount() <= 1) {
            return -1;
        }
        ControlTitleNode controlTitleNode = (ControlTitleNode)treePath.getPathComponent(1);
        return controlTitleNode.getControlTitleType();
    }

    protected abstract JPopupMenu createPopupMenu(int var1);

    ControlTitleNode getTitleNode(int n) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getModel().getRoot();
        return this.findTitleNode(defaultMutableTreeNode, n);
    }

    private ControlTitleNode findTitleNode(DefaultMutableTreeNode defaultMutableTreeNode, int n) {
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            if (!(defaultMutableTreeNode2 instanceof ControlTitleNode)) continue;
            ControlTitleNode controlTitleNode = (ControlTitleNode)defaultMutableTreeNode2;
            if (controlTitleNode.equalsControlTitleType(n)) {
                return controlTitleNode;
            }
            if ((controlTitleNode = this.findTitleNode(controlTitleNode, n)) == null) continue;
            return controlTitleNode;
        }
        return null;
    }
}

