/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.coregenome;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.coregenome.CoreGenomeAlignment;
import cgdp.recog.coregenome.CoreGenomeAlignmentCondition;
import cgdp.recog.coregenome.CoreGenomeFrame;
import cgdp.recog.coregenome.CoreGenomeViewModel;
import cgdp.recog.coregenome.GenomeAlign;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.process.ProgressDialog;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import javax.swing.SwingUtilities;

public class ConnectionUpdater
extends CoreGenomeAlignment {
    private static final ApplicationLogger logger = new ApplicationLogger(ConnectionUpdater.class);
    private static final String[] PROGRESS_MESSAGES = new String[]{"Create Connections.."};
    private CoreGenomeFrame coreGenomeFrame;
    private CoreGenomeViewModel coreGenomeViewModel;
    private CoreGenomeAlignmentCondition condition;

    public ConnectionUpdater(MediatorImpl mediatorImpl, Component component, ClusterTbl clusterTbl, CoreGenomeFrame coreGenomeFrame, CoreGenomeViewModel coreGenomeViewModel, CoreGenomeAlignmentCondition coreGenomeAlignmentCondition) {
        super(mediatorImpl, component, clusterTbl);
        this.coreGenomeFrame = coreGenomeFrame;
        this.coreGenomeViewModel = coreGenomeViewModel;
        this.condition = coreGenomeAlignmentCondition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(ProgressImpl progressImpl) {
        try {
            this.condition.setUpdateParameterFlag(false);
            GenomeAlign genomeAlign = ConnectionUpdater.createGenomeAlign(progressImpl, this.clusterTbl, this.coreGenomeViewModel.getGenomeAlign().getFilepath(), this.condition);
            this.condition.setUpdateParameterFlag(true);
            if (progressImpl.isCanceled()) {
                return;
            }
            this.coreGenomeViewModel.setGenomeAlign(genomeAlign);
            this.coreGenomeViewModel.setCondition(this.condition);
            this.coreGenomeViewModel.setUpdateConnectionDepth(true);
            ConnectionUpdater.setHeadGeneNames(this.coreGenomeViewModel);
            progressImpl.setCount(99);
            progressImpl.increment();
            ((ProgressDialog)progressImpl).setVisible(false);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConnectionUpdater.this.coreGenomeFrame.fireUpadteCoreGenomeViewModel();
                }
            });
        }
        catch (Exception exception) {
            logger.warn("Fail to execute core genome alignment.", exception);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MessageManager.showErrorMessage(ConnectionUpdater.this.parent, "Fail to execute core genome alignment.");
                }
            });
        }
        finally {
            this.mediator.updateMemory();
        }
    }

    @Override
    public String[] getProgressMessages() {
        return PROGRESS_MESSAGES;
    }
}

