/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.coregenome;

import cgdp.recog.option.OptionTbl;
import cgdp.recog.util.ColorUtil;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class InOutgroupTableCellRenderer
extends JLabel
implements TableCellRenderer {
    public static final String KEY_INGROUP = "IN";
    public static final String KEY_OUTGROUP = "OUT";
    private Color ingroupColor;
    private Color outgroupColor;

    public InOutgroupTableCellRenderer() {
        this.setOpaque(true);
        this.setHorizontalAlignment(0);
        OptionTbl optionTbl = OptionTbl.getInstance();
        this.ingroupColor = ColorUtil.str2Color(optionTbl.getOptionValues().getIngroupFontColor());
        this.outgroupColor = ColorUtil.str2Color(optionTbl.getOptionValues().getOutgroupFontColor());
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        String string = (String)object;
        this.setText(string);
        if (bl) {
            this.setForeground(jTable.getSelectionForeground());
            this.setBackground(jTable.getSelectionBackground());
        } else if (jTable.isEnabled()) {
            if (string.equals(KEY_INGROUP)) {
                this.setForeground(this.ingroupColor);
            } else if (string.equals(KEY_OUTGROUP)) {
                this.setForeground(this.outgroupColor);
            } else {
                this.setForeground(jTable.getForeground());
            }
            this.setBackground(jTable.getBackground());
        } else {
            this.setForeground(Color.LIGHT_GRAY);
            this.setBackground(jTable.getBackground());
        }
        return this;
    }
}

