/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.data;

import cgdp.recog.data.ClusterTbl;
import cgdp.recog.data.DataManager;
import cgdp.recog.data.MergeClusterExporter;
import cgdp.recog.data.MergeClusterImporter;
import cgdp.recog.data.SplitClusterExporter;
import cgdp.recog.data.SplitClusterImporter;
import cgdp.recog.project.Project;
import cgdp.recog.system.property.ApplicationProperty;
import cgdp.recog.system.property.ApplicationPropertyAccessable;
import cgdp.recog.util.ApplicationLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class ModifiedClusterManager
implements ApplicationPropertyAccessable {
    private static final ApplicationLogger logger = new ApplicationLogger(ModifiedClusterManager.class);
    private int startClusterId = 0;
    private int increment = 1;
    private ClusterTbl clusterTbl;

    ModifiedClusterManager(ClusterTbl clusterTbl) {
        this.setClusterTbl(clusterTbl);
    }

    void setClusterTbl(ClusterTbl clusterTbl) {
        this.clusterTbl = clusterTbl;
    }

    void setStartClusterId(int n) {
        this.startClusterId = n;
    }

    private int getStartClusterId() {
        return this.startClusterId;
    }

    synchronized int createClusterId() {
        int n = this.getStartClusterId() + this.getIncrement();
        this.increment();
        return n;
    }

    private synchronized int getIncrement() {
        return this.increment;
    }

    private synchronized void increment() {
        ++this.increment;
    }

    private List importMergeClusterList(Project project, String string, Map map) throws IOException {
        String string2 = DataManager.getMergeClusterFilepath(project, string);
        MergeClusterImporter mergeClusterImporter = new MergeClusterImporter(string2, map);
        mergeClusterImporter.execute();
        return mergeClusterImporter.getMergeClusterList();
    }

    private void exportMergeClusterList(Project project, String string, List list) throws IOException {
        String string2 = DataManager.getMergeClusterFilepath(project, string);
        MergeClusterExporter mergeClusterExporter = new MergeClusterExporter(string2, list);
        mergeClusterExporter.execute();
    }

    private List importSplitClusterList(Project project, String string, Map map) throws IOException {
        String string2 = DataManager.getSplitClusterFilepath(project, string);
        SplitClusterImporter splitClusterImporter = new SplitClusterImporter(string2, map);
        splitClusterImporter.execute();
        return splitClusterImporter.getSplitClusterList();
    }

    private void exportSplitClusterList(Project project, String string, List list) throws IOException {
        String string2 = DataManager.getSplitClusterFilepath(project, string);
        SplitClusterExporter splitClusterExporter = new SplitClusterExporter(string2, list);
        splitClusterExporter.execute();
    }

    @Override
    public String getCategory() {
        return "ModifiedCluster";
    }

    @Override
    public List getPropertyList(Project project, String string) {
        ArrayList<ApplicationProperty> arrayList;
        if (this.clusterTbl == null) {
            return null;
        }
        try {
            arrayList = this.clusterTbl.getMergeClusterList();
            this.exportMergeClusterList(project, string, arrayList);
        }
        catch (IOException iOException) {
            logger.warn("Fail to save merge cluster file. Project = " + project.getProjectName() + " DomClust ID:" + string, iOException);
        }
        try {
            arrayList = this.clusterTbl.getSplitClusterList();
            this.exportSplitClusterList(project, string, arrayList);
        }
        catch (IOException iOException) {
            logger.warn("Fail to save split cluster file. Project = " + project.getProjectName() + " DomClust ID:" + string, iOException);
        }
        arrayList = new ArrayList<ApplicationProperty>();
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "ModifiedClusterMergeClusterFile", "yes"));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "ModifiedClusterSplitClusterFile", "yes"));
        return arrayList;
    }

    @Override
    public int getPropertyType() {
        return 2;
    }

    @Override
    public void updateProperty(Map map, Project project, String string) {
        List list;
        if (this.clusterTbl == null) {
            return;
        }
        Map map2 = this.clusterTbl.createClusterMap();
        try {
            list = this.importMergeClusterList(project, string, map2);
            this.clusterTbl.setMergeClusterList(list);
        }
        catch (Exception exception) {
            logger.warn("Fail to load merge cluster. Project = " + project.getProjectName() + " DomClust ID:" + string, exception);
        }
        try {
            list = this.importSplitClusterList(project, string, map2);
            this.clusterTbl.setSplitClusterList(list);
        }
        catch (Exception exception) {
            logger.warn("Fail to load split cluster. Project = " + project.getProjectName() + " DomClust ID:" + string, exception);
        }
    }
}

