/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.domclust;

import cgdp.recog.domclust.DomClustCondition;
import cgdp.recog.util.StringTool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;

public class DomClustConditionImporter {
    private File domClustConditionFile;
    private DomClustCondition domClustCondition;

    public DomClustConditionImporter(File file) {
        this.domClustConditionFile = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws IOException {
        FileInputStream fileInputStream = null;
        BufferedReader bufferedReader = null;
        try {
            String string;
            fileInputStream = new FileInputStream(this.domClustConditionFile);
            bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            this.domClustCondition = new DomClustCondition();
            while ((string = bufferedReader.readLine()) != null) {
                Vector vector = StringTool.splitString(string, "=", 2);
                String string2 = (String)vector.get(0);
                String string3 = (String)vector.get(1);
                this.setDomClustConditionParam(string2, string3, this.domClustCondition);
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    private void setDomClustConditionParam(String string, String string2, DomClustCondition domClustCondition) {
        if (string.equals("domclust_conditionName")) {
            domClustCondition.setConditionName(string2);
        } else if (string.equals("domclust_mutableFlag")) {
            domClustCondition.setMutable(new Boolean(string2));
        } else if (string.equals("domclust_alignCoverage")) {
            try {
                double d = Double.parseDouble(string2);
                domClustCondition.setAlignCoverage(d);
            }
            catch (NumberFormatException numberFormatException) {
                domClustCondition.setAlignCoverage(-2.147483648E9);
            }
        } else if (string.equals("domclust_alignCoverageDomain")) {
            try {
                double d = Double.parseDouble(string2);
                domClustCondition.setAlignCoverageDomain(d);
            }
            catch (NumberFormatException numberFormatException) {
                domClustCondition.setAlignCoverageDomain(-2.147483648E9);
            }
        } else if (string.equals("domclust_bestHitCriterion")) {
            domClustCondition.setBestHitCriterion(string2);
        } else if (string.equals("domclust_clusteringMode")) {
            domClustCondition.setClusteringMode(string2);
        } else if (string.equals("domclust_coverageAbsorbingCluster")) {
            try {
                double d = Double.parseDouble(string2);
                domClustCondition.setCoverageAbsorbingCluster(d);
            }
            catch (NumberFormatException numberFormatException) {
                domClustCondition.setCoverageAbsorbingCluster(-2.147483648E9);
            }
        } else if (string.equals("domclust_cutoffDp")) {
            try {
                double d = Double.parseDouble(string2);
                domClustCondition.setCutoffDp(d);
            }
            catch (NumberFormatException numberFormatException) {
                domClustCondition.setCutoffDp(-2.147483648E9);
            }
        } else if (string.equals("domclust_cutoffPam")) {
            try {
                double d = Double.parseDouble(string2);
                domClustCondition.setCutoffPam(d);
            }
            catch (NumberFormatException numberFormatException) {
                domClustCondition.setCutoffPam(-2.147483648E9);
            }
        } else if (string.equals("domclust_cutoffEvalue")) {
            try {
                double d = Double.parseDouble(string2);
                domClustCondition.setCutoffEvalue(d);
            }
            catch (NumberFormatException numberFormatException) {
                domClustCondition.setCutoffEvalue(-2.147483648E9);
            }
        } else if (string.equals("domclust_cutoffIdentity")) {
            try {
                double d = Double.parseDouble(string2);
                domClustCondition.setCutoffIdentity(d);
            }
            catch (NumberFormatException numberFormatException) {
                domClustCondition.setCutoffIdentity(-2.147483648E9);
            }
        } else if (string.equals("domclust_cutoffIngroup")) {
            try {
                double d = Double.parseDouble(string2);
                domClustCondition.setCutoffIngroup(d);
            }
            catch (NumberFormatException numberFormatException) {
                domClustCondition.setCutoffIngroup(-2.147483648E9);
            }
        } else if (string.equals("domclust_cutoffParalogTreeSplit")) {
            try {
                double d = Double.parseDouble(string2);
                domClustCondition.setCutoffParalogTreeSplit(d);
            }
            catch (NumberFormatException numberFormatException) {
                domClustCondition.setCutoffParalogTreeSplit(-2.147483648E9);
            }
        } else if (string.equals("domclust_cutoffSocreBest")) {
            try {
                double d = Double.parseDouble(string2);
                domClustCondition.setCutoffSocreBest(d);
            }
            catch (NumberFormatException numberFormatException) {
                domClustCondition.setCutoffParalogTreeSplit(-2.147483648E9);
            }
        } else if (string.equals("domclust_overlapMergingCluster")) {
            try {
                double d = Double.parseDouble(string2);
                domClustCondition.setOverlapMergingCluster(d);
            }
            catch (NumberFormatException numberFormatException) {
                domClustCondition.setOverlapMergingCluster(-2.147483648E9);
            }
        } else if (string.equals("domclust_phylogOrganism")) {
            domClustCondition.setPhylogOrganism(string2);
        } else if (string.equals("domclust_scoreCutoffForDomain")) {
            try {
                double d = Double.parseDouble(string2);
                domClustCondition.setScoreCutoffForDomain(d);
            }
            catch (NumberFormatException numberFormatException) {
                domClustCondition.setScoreCutoffForDomain(-2.147483648E9);
            }
        } else if (string.equals("domclust_scoreMissingRelationship")) {
            try {
                double d = Double.parseDouble(string2);
                domClustCondition.setScoreMissingRelationship(d);
            }
            catch (NumberFormatException numberFormatException) {
                domClustCondition.setScoreMissingRelationship(-2.147483648E9);
            }
        } else if (string.equals("domclust_similarityOrthology")) {
            domClustCondition.setSimilarityOrthology(string2);
        } else if (string.equals("domclust_use_dump")) {
            domClustCondition.setUseDump(new Boolean(string2));
        } else if (string.equals("domclust_horizweight")) {
            try {
                double d = Double.parseDouble(string2);
                domClustCondition.setHorizweight(d);
            }
            catch (NumberFormatException numberFormatException) {
                domClustCondition.setHorizweight(-2.147483648E9);
            }
        } else if (string.equals("other_options")) {
            domClustCondition.setOtherOptions(string2);
        }
    }

    public DomClustCondition getDomClustCondition() {
        return this.domClustCondition;
    }
}

