/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.filefilter;

import cgdp.recog.filefilter.FileExtension;
import cgdp.recog.util.AbstractFileFilter;
import cgdp.recog.util.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class SingleFileFilter
extends AbstractFileFilter {
    private List extensionList = new ArrayList();
    private String description;
    private boolean showDirectory;

    public SingleFileFilter(String string, String string2) {
        this(string, string2, false);
    }

    public SingleFileFilter(List list, String string) {
        this(list, string, false);
    }

    public SingleFileFilter(String string, String string2, boolean bl) {
        this.extensionList.add(string);
        this.description = string2;
        this.showDirectory = bl;
    }

    public SingleFileFilter(List list, String string, boolean bl) {
        if (list != null) {
            this.extensionList.addAll(list);
        }
        this.description = string;
        this.showDirectory = bl;
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory() && this.showDirectory) {
            return true;
        }
        if (this.extensionList == null || this.extensionList.isEmpty()) {
            return true;
        }
        if (!file.isFile()) {
            return false;
        }
        for (String string : this.extensionList) {
            if (!FileExtension.isMatchExtension(string, file.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String getExtension() {
        if (this.extensionList != null && !this.extensionList.isEmpty()) {
            return (String)this.extensionList.get(0);
        }
        return null;
    }

    @Override
    public String modifiedExtension(File file) {
        return FileUtil.modifiedExtension(file, this.getExtension());
    }

    @Override
    public String modifiedExtension(String string) {
        return FileUtil.modifiedExtension(string, this.getExtension());
    }
}

